/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.ore;

import igentuman.nc.NuclearCraft;
import igentuman.nc.content.materials.Ores;
import igentuman.nc.handler.config.OreGenConfig;
import igentuman.nc.setup.registration.NCBlocks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.block.Block;

public class NCOre {
    public boolean initialized = false;
    public String name;
    public int color;
    public List<String> dimensions;
    public int veinSize;
    public int veinAmount;
    public boolean registered = true;
    public int[] height;

    private NCOre(String name) {
        this.name = name;
    }

    public NCOre vein(int size, int amount) {
        this.veinSize = size;
        this.veinAmount = amount;
        return this;
    }

    public NCOre height(int min, int max) {
        this.height = new int[]{min, max};
        return this;
    }

    public static NCOre get(String name) {
        return new NCOre(name);
    }

    public NCOre dim(String ... dim) {
        this.dimensions = List.of(dim);
        return this;
    }

    public NCOre config() {
        if (!this.initialized) {
            try {
                int id = Ores.all().keySet().stream().toList().indexOf(this.name);
                this.registered = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).register.get();
                this.veinSize = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).veinSize.get();
                this.height[0] = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).min_height.get();
                this.height[1] = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).max_height.get();
                this.initialized = true;
                try {
                    this.dimensions = ((ArrayList)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).dimensions.get()).stream().toList();
                }
                catch (Exception e) {
                    NuclearCraft.LOGGER.warn("Error while loading dimensions ore config for " + this.name + "!");
                }
            }
            catch (Exception e) {
                int id = Ores.all().keySet().stream().toList().indexOf(this.name);
                this.registered = (Boolean)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).register.getDefault();
                this.veinSize = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).veinSize.getDefault();
                this.height[0] = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).min_height.getDefault();
                this.height[1] = (Integer)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).max_height.getDefault();
                this.initialized = true;
                try {
                    this.dimensions = ((ArrayList)OreGenConfig.ORE_CONFIG.ORES.get((Object)this.name).dimensions.getDefault()).stream().toList();
                }
                catch (Exception e1) {
                    NuclearCraft.LOGGER.warn("Error while loading dimensions ore config for " + this.name + "!");
                }
            }
        }
        return this;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Block block(String suffix) {
        return (Block)NCBlocks.ORE_BLOCKS.get(this.name + suffix).get();
    }

    public Block block() {
        return (Block)NCBlocks.ORE_BLOCKS.get(this.name).get();
    }
}

