/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.world.structure;

import com.mojang.serialization.Codec;
import igentuman.nc.NuclearCraft;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.WorldGeneration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.registries.RegistryObject;

public class WastelandStructureFeature
extends Feature<NoneFeatureConfiguration> {
    public static final List<ResourceLocation> structures = new ArrayList<ResourceLocation>();
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> WASTELAND_RUINS_FEATURE = Registries.FEATURE_REGISTER.register("wasteland_ruins", () -> new WastelandStructureFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));

    public WastelandStructureFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public static void init() {
    }

    private List<ResourceLocation> findWastelandStructures(StructureTemplateManager templateManager) {
        int i;
        int rarityIndex;
        int rarityValue;
        String fileName;
        if (!structures.isEmpty()) {
            return structures;
        }
        String wastelandPath = "nuclearcraft:wasteland/";
        Stream allTemplates = templateManager.m_230355_();
        for (ResourceLocation location : allTemplates.toList()) {
            String path = location.m_135815_();
            if (!path.startsWith("wasteland/")) continue;
            fileName = path.substring(path.lastIndexOf(47) + 1);
            rarityValue = 0;
            if (fileName.matches(".*\\d+$")) {
                String rarityStr = fileName.replaceAll(".*?([0-9]+)$", "$1");
                rarityValue = Integer.parseInt(rarityStr);
            }
            rarityIndex = 11 - Math.abs(rarityValue);
            for (i = 0; i < rarityIndex; ++i) {
                structures.add(ResourceLocation.m_135820_((String)location.toString()));
            }
            structures.add(location);
        }
        if (structures.isEmpty()) {
            for (ResourceLocation location : allTemplates.toList()) {
                String fullPath = location.toString();
                if (!fullPath.contains(wastelandPath)) continue;
                fileName = fullPath.substring(fullPath.lastIndexOf(47) + 1);
                rarityValue = 0;
                if (fileName.matches(".*\\d+$")) {
                    String rarityStr = fileName.replaceAll(".*?([0-9]+)$", "$1");
                    rarityValue = Integer.parseInt(rarityStr);
                }
                rarityIndex = 11 - Math.abs(rarityValue);
                for (i = 0; i < rarityIndex; ++i) {
                    structures.add(ResourceLocation.m_135820_((String)location.toString()));
                }
            }
        }
        if (!structures.isEmpty()) {
            NuclearCraft.debugLog("Wasteland structures pool size: " + structures.size());
        }
        return structures;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos;
        WorldGenLevel world = context.m_159774_();
        if (!world.m_204166_(pos = context.m_159777_()).m_203656_(WorldGeneration.WASTELAND)) {
            return false;
        }
        StructureTemplateManager templateManager = ((WorldGenRegion)world).m_6018_().m_215082_();
        List<ResourceLocation> availableStructures = this.findWastelandStructures(templateManager);
        if (availableStructures.isEmpty()) {
            NuclearCraft.debugLog("No wasteland structures found in datapack");
            return false;
        }
        int id = context.m_225041_().m_188503_(availableStructures.size());
        ResourceLocation structureId = availableStructures.get(id);
        StructureTemplate template = templateManager.m_230407_(structureId).orElse(null);
        if (template == null) {
            NuclearCraft.debugLog("Failed to load structure template: " + structureId);
            return false;
        }
        String featureName = structureId.m_135815_();
        if (featureName.contains("/")) {
            featureName = featureName.substring(featureName.lastIndexOf(47) + 1);
        }
        Rotation[] rotations = Rotation.values();
        Rotation randomRotation = rotations[context.m_225041_().m_188503_(rotations.length)];
        Mirror randomMirror = context.m_225041_().m_188499_() ? Mirror.NONE : (context.m_225041_().m_188499_() ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK);
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74392_(false).m_74377_(randomMirror).m_74379_(randomRotation);
        int vSize = template.m_163801_().m_123342_();
        boolean BLOCK_UPDATE = true;
        int KEEP_EXISTING = 16;
        int STRUCTURE_SIZE = 7;
        int totalHeight = 0;
        int sampleCount = 0;
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int sampleStep = 2;
        for (int x = 0; x < 7; x += sampleStep) {
            for (int z = 0; z < 7; z += sampleStep) {
                BlockPos checkPos = pos.m_7918_(x, 0, z);
                int groundY = this.findGroundLevel((LevelAccessor)world, checkPos);
                if (groundY <= 0) continue;
                totalHeight += groundY;
                ++sampleCount;
                minHeight = Math.min(minHeight, groundY);
                maxHeight = Math.max(maxHeight, groundY);
            }
        }
        if (sampleCount == 0) {
            return false;
        }
        int avgHeight = totalHeight / sampleCount;
        if (featureName.contains("bunker")) {
            avgHeight -= vSize - 2;
        }
        avgHeight -= 2;
        if (maxHeight - minHeight > 5) {
            return false;
        }
        BlockPos placementPos = new BlockPos(pos.m_123341_(), avgHeight, pos.m_123343_());
        template.m_230328_((ServerLevelAccessor)world, placementPos, placementPos, placeSettings, world.m_213780_(), 17);
        return true;
    }

    private int findGroundLevel(LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), world.m_151558_(), pos.m_123343_());
        while (mutablePos.m_123342_() > world.m_141937_() && world.m_46859_((BlockPos)mutablePos)) {
            mutablePos.m_122184_(0, -1, 0);
        }
        if (mutablePos.m_123342_() <= world.m_141937_()) {
            return -1;
        }
        return mutablePos.m_123342_();
    }
}

