/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block;

import igentuman.nc.handler.config.WorldConfig;
import igentuman.nc.util.TextUtils;
import igentuman.nc.world.dimension.Dimensions;
import igentuman.nc.world.dimension.ModTeleporter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;

public class PortalBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);

    public PortalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60913_(8.0f, 3600.0f).m_60999_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.teleportTo((Entity)player, pos.m_122012_());
        }
    }

    private void teleportTo(Entity player, BlockPos pPos) {
        ResourceKey<Level> resourcekey;
        ServerLevel serverlevel;
        MinecraftServer minecraftserver;
        ServerLevel portalDimension;
        if (!((Boolean)WorldConfig.DIMENSION_CONFIG.registerWasteland.get()).booleanValue()) {
            return;
        }
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (portalDimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = player.m_9236_().m_46472_() == Dimensions.WASTELAND ? Level.f_46428_ : Dimensions.WASTELAND)) != null && !player.m_20159_()) {
            if (resourcekey == Dimensions.WASTELAND) {
                player.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos));
            } else {
                player.changeDimension(portalDimension, (ITeleporter)new ModTeleporter(pPos));
            }
        }
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> list, TooltipFlag pFlag) {
        if (!((Boolean)WorldConfig.DIMENSION_CONFIG.registerWasteland.get()).booleanValue()) {
            list.add((Component)TextUtils.__("tooltip.nc.wasteland.disabled", new Object[0]).m_130940_(ChatFormatting.RED));
        } else {
            list.add((Component)TextUtils.__("tooltip.nc.wasteland.portal.descr", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
    }
}

