/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.accelerator.entity;

import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.content.particles.CapabilityParticleStackHandler;
import igentuman.nc.content.particles.IParticleStackHandler;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.ParticleStorage;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.RegistryObject;

public class AbstractAcceleratorControllerBE
extends MultiblockControllerBE {
    @NBTField
    public int heatMax = 0;
    @NBTField
    public BlockPos ionSourcePos = BlockPos.f_121853_;
    @NBTField
    public boolean hasParticle = false;
    @NBTField
    public int coolers;
    @NBTField
    public int beamLength = 0;
    @NBTField
    public boolean controllerEnabled = false;
    @NBTField
    public int amplifiers = 0;
    @NBTField
    public int quadroupoles = 0;
    @NBTField
    public int dipoles = 0;
    @NBTField
    public double focus = 0.0;
    @NBTField
    public int maxTemperature = 0;
    @NBTField
    public int heatRate = 0;
    @NBTField
    public int heat = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public double quadStrength = 0.0;
    @NBTField
    public double dipoleStrength = 0.0;
    @NBTField
    public long acceleratingVoltage = 0L;
    @NBTField
    public int energyRequired = 0;
    @NBTField
    public int coolingRate = 0;
    @NBTField
    public double redstoneLevel = 0.0;
    protected final LazyOptional<IParticleStackHandler> particleHandler;
    protected final ParticleStorage particleStorage;
    protected final LazyOptional<IEnergyStorage> energy;
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage = this.createEnergy();
    private List<ItemStack> allowedInputs;
    private List<FluidStack> allowedInputFluids;
    protected LinearAcceleratorControllerBE.CoolantRecipe coolantRecipe;
    protected List<LinearAcceleratorControllerBE.CoolantRecipe> coolantRecipes;
    private List<FluidStack> allowedCoolants;
    private List<FluidStack> allowedCoolantsOutput;

    protected AbstractAcceleratorControllerBE(BlockEntityType<?> pType, BlockPos pos, BlockState state) {
        super(pType, pos, state);
        this.energyStorage.setInputEnergyTier(this.getBaseGTEnergyTier()).setOutputEnergyTier(0L).setInputAmperage(16L).setOutputAmperage(0L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
        this.contentHandler = new SidedContentHandler(1, 1, 1, 3, 1000);
        this.contentHandler().itemHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().itemHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler().fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(1, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().fluidHandler.setGlobalMode(2, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(3, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        this.contentHandler().setBlockEntity(this);
        this.contentHandler().setAllowedInputFluids(0, this::getAllowedInputFluids);
        this.contentHandler().setAllowedInputFluids(2, this::getAllowedCoolants);
        this.contentHandler().setAllowedInputFluids(3, this::getAllowedCoolantsOutput);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).setCapacity(100000);
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(3))).setCapacity(100000);
        this.particleStorage = new ParticleStorage();
        this.particleStorage.setTileEntity(this);
        this.particleHandler = CapabilityParticleStackHandler.createHandler(this.particleStorage);
    }

    public ParticleStack getParticleStack() {
        return this.particleStorage.getParticle();
    }

    public CommonConfig.GTCEUCompatibilityConfig.GTCEUTier getTier() {
        return (CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.ACCELERATORS_ENERGY_TIER.get());
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputFluids == null) {
            this.allowedInputFluids = new ArrayList<FluidStack>();
            for (String name : ParticleSources.fluidSources.keySet()) {
                this.allowedInputFluids.addAll(IngredientCreatorAccess.fluid().from(name, 1).getRepresentations());
            }
        }
        return this.allowedInputFluids;
    }

    public List<LinearAcceleratorControllerBE.CoolantRecipe> getCoolantRecipes() {
        if (this.coolantRecipes == null) {
            this.coolantRecipes = NcRecipeType.getAllRecipesFor("accelerator_coolant", this.m_58904_());
        }
        return this.coolantRecipes;
    }

    protected List<FluidStack> getAllowedCoolants() {
        if (this.allowedCoolants == null) {
            this.allowedCoolants = new ArrayList<FluidStack>();
            for (LinearAcceleratorControllerBE.CoolantRecipe recipe : this.getCoolantRecipes()) {
                this.allowedCoolants.addAll(recipe.getInputFluids(0));
            }
        }
        return this.allowedCoolants;
    }

    protected List<FluidStack> getAllowedCoolantsOutput() {
        if (this.allowedCoolantsOutput == null) {
            this.allowedCoolantsOutput = new ArrayList<FluidStack>();
            for (LinearAcceleratorControllerBE.CoolantRecipe recipe : this.getCoolantRecipes()) {
                this.allowedCoolantsOutput.addAll(recipe.getOutputFluids(0));
            }
        }
        return this.allowedCoolantsOutput;
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.ACCELERATORS_ENERGY_TIER.get())).ordinal();
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (RegistryObject<Item> item : NCItems.ION_SOURCES.values()) {
                this.allowedInputs.add(new ItemStack((ItemLike)item.get()));
            }
        }
        return this.allowedInputs;
    }

    public int getMinEnergy() {
        return 0;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 100000000, 0){

            @Override
            protected void onEnergyChanged() {
                AbstractAcceleratorControllerBE.this.m_6596_();
            }
        };
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.particleStorage.readFromNBT(infoTag.m_128469_("particle_storage"));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128365_("particle_storage", (Tag)this.particleStorage.writeToNBT(new CompoundTag()));
            this.particleStorage.clear();
        }
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        super.loadClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            this.particleStorage.readFromNBT(infoTag.m_128469_("particle_storage"));
        }
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        super.saveClientData(tag);
        if (tag.m_128441_("Info")) {
            CompoundTag infoTag = tag.m_128469_("Info");
            infoTag.m_128365_("particle_storage", (Tag)this.particleStorage.writeToNBT(new CompoundTag()));
            this.particleStorage.clear();
        }
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public boolean isProcessing() {
        return this.hasParticle && this.controllerEnabled;
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    protected boolean drainEnergy() {
        if (this.energyStorage().getEnergyStored() < this.energyRequired) {
            return false;
        }
        this.energyStorage().extractEnergy(this.energyRequired, false);
        return true;
    }

    public boolean hasCoolant() {
        FluidStack coolant = this.contentHandler().fluidHandler.getFluidInSlot(2);
        if (coolant.isEmpty()) {
            this.coolantRecipe = null;
            return false;
        }
        if (this.coolantRecipe == null) {
            for (LinearAcceleratorControllerBE.CoolantRecipe recipe : this.getCoolantRecipes()) {
                if (!recipe.getInputFluids()[0].test(coolant)) continue;
                this.coolantRecipe = recipe;
                return true;
            }
        } else if (!this.coolantRecipe.getInputFluids()[0].test(coolant)) {
            this.coolantRecipe = null;
            return false;
        }
        return this.coolantRecipe instanceof LinearAcceleratorControllerBE.CoolantRecipe;
    }

    protected void coolantCoolDown() {
        if (this.hasCoolant() && this.heat > 0) {
            double coolantNeededRatio = (double)this.coolingRate / this.coolantRecipe.getCoolingRate();
            int coolantPerOp = this.coolantRecipe.getInputFluids()[0].getAmount();
            int coolantNeeded = (int)Math.ceil(coolantNeededRatio * (double)coolantPerOp);
            int availableCoolant = ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).getFluidAmount();
            if (availableCoolant >= coolantNeeded) {
                int opsNeeded = Math.max(1, coolantNeeded / coolantPerOp);
                double actualCooling = Math.min(this.coolingRate, this.heat);
                this.heat -= (int)actualCooling;
                this.heat = Math.max(0, this.heat);
                this.extractCoolant(opsNeeded);
            } else if (availableCoolant >= coolantPerOp) {
                int possibleOps = availableCoolant / coolantPerOp;
                double partialCooling = (double)(possibleOps * coolantPerOp) * this.coolantRecipe.getCoolingRate() / (double)coolantPerOp;
                double actualCooling = Math.min(partialCooling, (double)this.heat);
                this.heat -= (int)actualCooling;
                this.heat = Math.max(0, this.heat);
                this.extractCoolant(possibleOps);
            }
        }
    }

    protected void extractCoolant(int ops) {
        if (this.coolantRecipe != null) {
            ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(2))).drain(this.coolantRecipe.getInputFluids()[0].getAmount() * ops, IFluidHandler.FluidAction.EXECUTE);
            FluidStack output = this.coolantRecipe.getOutputFluids().get(0).copy();
            output.setAmount(output.getAmount() * ops);
            ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(3))).fill(output, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler().fluidHandler.tanks.get(i);
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }
}

