/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.util.annotation.NothingNullByDefault;
import igentuman.nc.util.insitu_leaching.OreVeinProvider;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class AnalyzerBE
extends NCProcessorBE {
    public HashMap<Long, OreVeinRecipe> veinsCache = new HashMap();
    private BlockPos alreadySearched;

    public AnalyzerBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, "analyzer");
        this.particle1 = ParticleTypes.f_175829_;
    }

    @Override
    public void tickServer() {
        if (this.f_58858_.equals((Object)this.alreadySearched)) {
            return;
        }
        super.tickServer();
    }

    @Override
    public void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo.isCompleted()) {
            this.handleChunkAnalyzeWithPaper();
            this.handleMapAnalyze();
            if (this.recipe.handleOutputs(this.contentHandler)) {
                this.recipeInfo.clear();
            } else {
                this.recipeInfo.stuck = true;
            }
        }
    }

    private void handleMapAnalyze() {
        if (this.recipe.getInputIngredient(0).test(new ItemStack((ItemLike)Items.f_42573_))) {
            for (ItemStack output : this.recipe.getResultItems()) {
                output.m_41751_(this.contentHandler.itemHandler.holdedInputs.get(0).m_41784_());
                output.m_41784_().m_128379_("is_nc_analyzed", true);
            }
        }
    }

    private void handleChunkAnalyzeWithPaper() {
        if (this.recipe.getInputIngredient(0).test(new ItemStack((ItemLike)Items.f_42516_))) {
            OreVeinRecipe vein = this.getVein();
            this.alreadySearched = this.f_58858_;
            if (vein == null) {
                for (ItemStack output : this.recipe.getResultItems()) {
                    output.m_41784_().m_128359_("vein", "nc.ore_vein.none");
                }
            } else {
                for (ItemStack output : this.recipe.getResultItems()) {
                    output.m_41784_().m_128359_("vein", "nc.ore_vein." + vein.m_6423_().m_135815_().replace("nc_ore_veins/", ""));
                }
            }
            for (ItemStack output : this.recipe.getResultItems()) {
                output.m_41784_().m_128356_("pos", this.f_58858_.m_121878_());
                output.m_41784_().m_128379_("is_nc_analyzed", true);
            }
        }
    }

    protected OreVeinRecipe getVein() {
        long pos = ChunkPos.m_151388_((BlockPos)this.f_58858_);
        if (!this.veinsCache.containsKey(pos)) {
            this.veinsCache.put(pos, OreVeinProvider.get((ServerLevel)this.f_58857_).getVeinForChunk(ChunkPos.m_45592_((long)pos), ChunkPos.m_45602_((long)pos)));
        }
        return this.veinsCache.get(pos);
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return "analyzer";
        }
    }
}

