/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.entity.processor;

import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.annotation.NothingNullByDefault;
import igentuman.nc.util.capability.CustomEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class SteamTurbineBE
extends NCProcessorBE {
    @NBTField
    public double efficiency = 0.001;

    public SteamTurbineBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, "steam_turbine");
        this.particle1 = ParticleTypes.f_123806_;
    }

    @Override
    public void tickServer() {
        this.sendOutPower();
        this.efficiency = Math.max(1.0E-4, Math.min(10.0, this.efficiency));
        if (this.energyStorage().getEnergyStored() >= this.energyStorage().getMaxEnergyStored()) {
            return;
        }
        super.tickServer();
    }

    @Override
    public void processRecipe() {
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (!this.hasRecipe()) {
            return;
        }
        if (!this.recipeInfo().process(this.speedMultiplier() * this.efficiency)) {
            return;
        }
        this.efficiency += 4.0E-4;
        this.energyStorage().addEnergy((int)((double)this.getEnergyTransferPerTick() * this.recipe.getEnergy() * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get()));
    }

    @Override
    public double speedMultiplier() {
        return super.speedMultiplier();
    }

    @Override
    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(this.getEnergyMaxStorage(), 0, this.getEnergyMaxStorage()){

            @Override
            protected void onEnergyChanged() {
                SteamTurbineBE.this.m_6596_();
            }
        };
    }

    protected int getEnergyMaxStorage() {
        return this.getEnergyTransferPerTick() * 32;
    }

    protected int getEnergyTransferPerTick() {
        return (Integer)CommonConfig.ENERGY_GENERATION.STEAM_TURBINE.get();
    }

    @NothingNullByDefault
    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, 1.0);
        }

        @Override
        public String getCodeId() {
            return "steam_turbine";
        }
    }
}

