/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.kugelblitz.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.kugelblitz.ChamberPortBlock;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.KugelblitzPeripheral;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.compat.oc2.KugelblitzDevice;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.KugelblitzConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.kugelblitz.KugelblitzMultiblock;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.GameEvents;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class ChamberTerminalBE
extends MultiblockControllerBE {
    public static String NAME = "chamber_terminal";
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage;
    private LazyOptional<KugelblitzPeripheral> peripheralCap;
    protected final LazyOptional<IEnergyStorage> energy;
    @NBTField
    public long feeding = 0L;
    @NBTField
    public BlockPos blackholePos = BlockPos.f_121853_;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public double efficiency = 0.0;
    @NBTField
    public long mass = 0L;
    @NBTField
    public int evaporation = 0;
    @NBTField
    public byte frequency = 0;
    @NBTField
    public int energyConvertionRate = 7;
    @NBTField
    public boolean controllerEnabled = false;
    @NBTField
    public int transformers = 0;
    @NBTField
    public int fluxRegulators = 0;
    @NBTField
    public int blackholeStability = 100;
    @NBTField
    public int stabilizers = 0;
    public HashMap<Direction, Long> pulseEnergy = new HashMap();
    public int collectingEnergy = 2;
    protected Direction facing;
    public Recipe recipe;
    public HashMap<String, Recipe> cachedRecipes = new HashMap();
    private List<ItemStack> allowedInputs;
    private final List<ItemStack> orderedOutputs = new ArrayList<ItemStack>();
    private List<FluidStack> allowedInputFluids;
    public boolean gotLaserBurst = false;
    protected int reValidateCounter = 0;

    public ChamberTerminalBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)KugelblitzRegistration.KUGELBLITZ_BE.get(NAME).get(), pPos, pBlockState);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(0L).setOutputEnergyTier(this.getBaseGTEnergyTier()).setInputAmperage(0L).setOutputAmperage(16L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
        this.contentHandler = new SidedContentHandler(1, 1, 1, 0, 1000);
        this.contentHandler().itemHandler.setGlobalMode(0, SlotModePair.SlotMode.PULL);
        this.contentHandler().itemHandler.setGlobalMode(1, SlotModePair.SlotMode.PUSH);
        this.contentHandler.fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler().setAllowedInputItems(this::getAllowedInputItems);
        this.contentHandler.setBlockEntity(this);
        this.contentHandler.setAllowedInputFluids(0, this::getAllowedInputFluids);
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.KUGELBLITZ_ENERGY_TIER.get())).ordinal();
    }

    public List<ItemStack> getAllowedInputItems() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<ItemStack>();
            for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("kugelblitz_chamber", this.m_58904_())) {
                for (Ingredient ingredient : recipe.getItemIngredients()) {
                    this.allowedInputs.add(StackUtils.resolveStackByModPriority(ingredient.m_43908_()));
                }
            }
        }
        return this.allowedInputs;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 0, 100000000){

            @Override
            protected void onEnergyChanged() {
                ChamberTerminalBE.this.m_6596_();
            }
        };
    }

    @Override
    public Recipe getRecipe() {
        if (this.contentHandler().itemHandler.getStackInSlot(0).m_41619_()) {
            return null;
        }
        NcRecipe cachedRecipe = this.getCachedRecipe();
        if (cachedRecipe instanceof Recipe) {
            Recipe cRecipe = (Recipe)cachedRecipe;
            if (!this.hasResultItem(cRecipe)) {
                return null;
            }
            return cRecipe;
        }
        if (!NcRecipeType.ALL_RECIPES.containsKey("kugelblitz_chamber")) {
            return null;
        }
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("kugelblitz_chamber", this.m_58904_())) {
            if (!recipe.test(this.contentHandler())) continue;
            this.addToCache(recipe);
            if (!this.hasResultItem((Recipe)recipe)) {
                return null;
            }
            return (Recipe)recipe;
        }
        return null;
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new KugelblitzPeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler().getFluidCapability(null);
        }
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && ChamberTerminalBE.isGTEUCapEnabled()) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.getEnergy().cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        if (ModUtil.isOC2Loaded() && cap == KugelblitzDevice.DEVICE_CAPABILITY) {
            return this.getOCDevice(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void handleSliderUpdate(int buttonId, int ratio) {
        switch (buttonId) {
            case 0: {
                this.energyConvertionRate = ratio;
                break;
            }
            case 1: {
                this.frequency = (byte)(0.15 * (double)ratio);
            }
        }
        MultiblockHandler.get((ResourceKey<Level>)this.f_58857_.m_46472_()).addIgnoreToUpdate(this.m_58899_());
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ChamberPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)), 1);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ChamberPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)));
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
        }
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        this.changed = false;
        if (!this.getMultiblock().initialized) {
            return;
        }
        super.tickServer();
        boolean wasEnabled = this.controllerEnabled;
        this.handleValidation();
        if (this.isCasingValid && this.isInternalValid) {
            --this.collectingEnergy;
            if (this.collectingEnergy < 0) {
                this.collectingEnergy = 2;
                if (this.pulseEnergy.size() == 6) {
                    this.gotLaserBurst = true;
                }
                this.pulseEnergy.clear();
            }
            this.handleLaserBurst();
        }
        boolean bl = this.controllerEnabled = this.isCasingValid && this.isInternalValid && this.mass > 0L;
        if (this.controllerEnabled) {
            this.trackChanges(this.contentHandler().tick());
            long wasMass = this.mass;
            this.updateBlackhole();
            this.trackChanges(false, wasMass != this.mass);
            this.handleMeltdown();
            this.trackChanges(this.processRecipe());
            this.handleRecipeOutput();
            if (!this.isBlackHoleStable()) {
                this.m_58904_().m_142346_(null, (GameEvent)GameEvents.BLACKHOLE_VIBRATION.get(), this.getMultiblock().getCenter());
            }
        } else if (this.mass > 0L) {
            this.mass = 0L;
            this.feeding = 0L;
            this.evaporation = 0;
            this.energyPerTick = 0;
            this.changed = true;
        }
        if (wasEnabled != this.controllerEnabled) {
            this.m_6596_();
        }
        if (this.changed) {
            try {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)ChamberPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)), 2);
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ChamberPortBlock.POWERED, (Comparable)Boolean.valueOf(this.controllerEnabled)));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private boolean isBlackHoleStable() {
        return this.blackholeStability > 39;
    }

    public boolean hasBlackhole() {
        return this.getMultiblock().getBlackHole() instanceof BlackHoleBE;
    }

    private void updateBlackhole() {
        if (!this.hasBlackhole()) {
            this.mass = 0L;
            this.evaporation = 0;
            this.energyPerTick = 0;
            return;
        }
        this.feeding = (long)this.contentHandler().fluidHandler.getFluidInSlot(0).getAmount() * 10L;
        this.mass += this.feeding;
        this.contentHandler.fluidHandler.voidSlot(0);
        this.updateEnergyGeneration();
        this.updateEvaporation();
        this.mass -= (long)this.evaporation;
        if (this.mass < BlackHoleBE.MIN_MASS) {
            this.doEvaporation();
        }
        this.updateBlackholeStability();
    }

    private void updateBlackholeStability() {
        if (!this.hasBlackhole() || this.mass <= 0L) {
            this.blackholeStability = 100;
            return;
        }
        if (this.m_58904_().m_46467_() % 5L != 0L || this.m_58904_().f_46441_.m_188503_(96) < this.getMultiblock().stabilizers()) {
            return;
        }
        if (this.m_58904_().f_46441_.m_188500_() > 0.98) {
            ++this.blackholeStability;
            return;
        }
        double massRange = BlackHoleBE.MAX_MASS - BlackHoleBE.MIN_MASS * 5L;
        double normalizedMass = (double)(this.mass - BlackHoleBE.MIN_MASS) / massRange;
        double distanceFromOptimal = Math.abs(normalizedMass - 0.5) * 2.0;
        double decreaseChance = 0.05 + distanceFromOptimal * 0.1;
        if ((double)this.mass > (double)BlackHoleBE.MAX_MASS * 0.9) {
            decreaseChance += 0.1;
        }
        if (this.m_58904_().f_46441_.m_188500_() < decreaseChance) {
            this.blackholeStability = Math.max(0, this.blackholeStability - 1);
            this.m_6596_();
        }
        if (distanceFromOptimal < 0.3 && this.m_58904_().f_46441_.m_188500_() < 0.02) {
            this.blackholeStability = Math.min(100, this.blackholeStability + 1);
            this.m_6596_();
        }
    }

    private void updateEnergyGeneration() {
        int wasEnergy = this.energyPerTick;
        double massRatio = (double)BlackHoleBE.MAX_MASS / (double)Math.max(this.mass, BlackHoleBE.MIN_MASS);
        this.energyPerTick = (int)(massRatio * 5000.0 * Math.log((double)this.energyConvertionRate * Math.log(this.fluxRegulators * 4) + 1.0));
        this.energyPerTick = (int)((double)this.energyPerTick * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
        this.energyPerTick = (int)((double)this.energyPerTick * (Double)KugelblitzConfig.KUGELBLITZ_CONFIG.GENERATION_MULTIPLIER.get());
        this.energyStorage().addEnergy(this.energyPerTick);
        if (wasEnergy != this.energyPerTick) {
            this.m_6596_();
        }
    }

    private void updateEvaporation() {
        int fluctuation;
        int wasEvaporation = this.evaporation;
        int rate = (int)Math.max(1.0, (double)(this.energyConvertionRate * 100) / Math.log(this.fluxRegulators));
        if (this.recipeInfo().recipe() != null && !this.recipeInfo().isCompleted()) {
            rate += (int)((double)((100 - this.energyConvertionRate) * 100) / Math.log(this.transformers));
        }
        rate = (int)Math.pow(rate, 1.2);
        double massRatio = Math.log10((double)BlackHoleBE.MAX_MASS / (double)Math.max(this.mass, BlackHoleBE.MIN_MASS));
        this.evaporation = (int)((double)rate * (Double)KugelblitzConfig.KUGELBLITZ_CONFIG.EVAPORATION_MULTIPLIER.get() * massRatio);
        if (this.blackholeStability < 20 && this.m_58904_().f_46441_.m_188500_() < 0.1) {
            fluctuation = (int)((double)this.mass * 1.0E-4 * (this.m_58904_().f_46441_.m_188500_() - 0.5) * 2.0);
            this.evaporation += fluctuation;
        }
        if (this.blackholeStability < 10 && this.m_58904_().f_46441_.m_188500_() < 0.1) {
            fluctuation = (int)((double)this.mass * 5.0E-4 * this.m_58904_().f_46441_.m_188500_() * 20.0 / (double)this.blackholeStability);
            this.evaporation += fluctuation;
        }
        if (wasEvaporation != this.evaporation) {
            this.m_6596_();
        }
    }

    private void doEvaporation() {
        if (this.hasBlackhole()) {
            this.m_58904_().m_46597_(this.getMultiblock().getBlackHole().m_58899_(), Blocks.f_50016_.m_49966_());
            this.mass = 0L;
            this.feeding = 0L;
            this.energyPerTick = 0;
            this.evaporation = 0;
        }
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputFluids == null) {
            this.allowedInputFluids = new ArrayList<FluidStack>();
            this.allowedInputFluids.addAll(IngredientCreatorAccess.fluid().from("subliquid_matter", 1).getRepresentations());
        }
        return this.allowedInputFluids;
    }

    @Override
    public KugelblitzMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new KugelblitzMultiblock(this);
        }
        return (KugelblitzMultiblock)this.multiblock;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private void handleMeltdown() {
        if (this.mass > BlackHoleBE.MAX_MASS && this.getMultiblock().isFormed() && this.hasBlackhole()) {
            ((BlackHoleBE)this.getMultiblock().getBlackHole()).meltdown();
            this.mass = 0L;
            this.feeding = 0L;
            this.energyPerTick = 0;
            this.evaporation = 0;
        }
    }

    private boolean processRecipe() {
        if (this.recipeInfo().recipe != null && this.recipeInfo().isCompleted() && this.contentHandler().itemHandler.getStackInSlot(0).m_41619_()) {
            this.recipeInfo().clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    private boolean process() {
        double multiplier = Math.log10(this.transformers) * (double)(100 - this.energyConvertionRate) / 100.0;
        this.recipeInfo().process(multiplier);
        return true;
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo().isCompleted()) {
            ItemStack output;
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo().recipe();
            }
            if (!this.recipe.getResultItem().m_150930_(this.recipe.getInputItem().m_41720_())) {
                output = this.recipe.getResultItem();
            } else {
                int id = this.getIngredientId(this.recipe.getResultItem());
                output = this.orderedOutputs.get(id);
            }
            if (this.recipe.handleOutputs(this.contentHandler(), output)) {
                this.recipeInfo().clear();
            } else {
                this.recipeInfo.stuck = true;
            }
            this.m_6596_();
        }
    }

    private int getIngredientId(@NotNull ItemStack resultItem) {
        for (int i = 0; i < this.getAllowedRandomInputs().size(); ++i) {
            if (!this.getAllowedRandomInputs().get(i).m_150930_(resultItem.m_41720_())) continue;
            return i;
        }
        return 0;
    }

    private void updateRecipe() {
        if (this.recipe != null) {
            if (this.recipe.test(this.contentHandler())) {
                this.recipeInfo().ticksProcessed = 0.0;
                if (this.hasResultItem(this.recipe) && this.recipeInfo().consumeInputs(this.contentHandler())) {
                    return;
                }
                this.recipe = null;
                this.recipeInfo().clear();
            } else {
                this.recipeInfo().clear();
            }
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = ((Recipe)this.recipeInfo().recipe()).getBaseTime();
            this.recipeInfo().energy = this.recipeInfo().recipe.getEnergy();
            this.recipeInfo().be = this;
            if (this.hasResultItem(this.recipe) && !this.recipeInfo().consumeInputs(this.contentHandler())) {
                this.recipe = null;
                this.recipeInfo().clear();
            }
        } else {
            this.recipeInfo().clear();
        }
    }

    private int getTargetFrequencyForItem(ItemStack input, long seed) {
        Random rand = new Random(seed + (long)input.m_41720_().toString().hashCode());
        return rand.nextInt(15);
    }

    private boolean hasResultItem(Recipe recipe) {
        ServerLevel serverLevel = (ServerLevel)this.m_58904_();
        long seed = serverLevel.m_7328_();
        if (this.orderedOutputs.isEmpty()) {
            this.orderedOutputs.addAll(this.getAllowedRandomInputs());
            Random seededRandom = new Random(seed);
            Collections.shuffle(this.orderedOutputs, seededRandom);
        }
        return this.frequency == this.getTargetFrequencyForItem(recipe.getResultItem(), seed);
    }

    private List<ItemStack> getAllowedRandomInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (NcRecipe recipe : NcRecipeType.getAllRecipesFor("kugelblitz_chamber", this.m_58904_())) {
            for (Ingredient ingredient : recipe.getItemIngredients()) {
                ItemStack itemStack = StackUtils.resolveStackByModPriority(ingredient.m_43908_());
                if (!recipe.getResultItem().m_150930_(itemStack.m_41720_())) continue;
                inputs.add(itemStack);
            }
        }
        return inputs;
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo().isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo().recipe() != null && this.hasResultItem((Recipe)this.recipeInfo().recipe());
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo().ticksProcessed > 0.0 && !this.recipeInfo.isCompleted();
    }

    @Override
    public ItemCapabilityHandler getItemInventory() {
        return this.contentHandler().itemHandler;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    public <T> LazyOptional<T> getOCDevice(Capability<T> cap, Direction side) {
        return LazyOptional.of(() -> KugelblitzDevice.createDevice(this)).cast();
    }

    @Override
    public FluidTank getFluidTank(int i) {
        return (FluidTank)this.contentHandler().fluidHandler.tanks.get(i);
    }

    public void handleLaserBurst() {
        if (!this.gotLaserBurst) {
            return;
        }
        if (!this.hasBlackhole()) {
            this.handleBlackHole();
            return;
        }
        this.blackholeStability += 50 + this.m_58904_().f_46441_.m_188503_(50);
        if (this.blackholeStability > 100) {
            this.blackholeStability = 100;
        }
        this.mass += (long)(this.m_58904_().f_46441_.m_188503_(200) + 200) * 10000L;
        this.gotLaserBurst = false;
    }

    private void handleBlackHole() {
        BlockEntity be;
        if (this.getMultiblock().getCenter() == null) {
            if (this.getMultiblock().blackHole != null) {
                this.getMultiblock().blackHole = null;
                this.getMultiblock().blackHole.m_58904_().m_46597_(this.getMultiblock().blackHole.m_58899_(), Blocks.f_50016_.m_49966_());
            }
            return;
        }
        if (this.getMultiblock().blackHole == null && this.m_58904_() != null && (be = this.m_58904_().m_7702_(this.getMultiblock().getCenter())) instanceof BlackHoleBE) {
            this.getMultiblock().blackHole = (BlackHoleBE)be;
        }
        if (!this.getMultiblock().isFormed() && !this.isCasingValid && this.getMultiblock().blackHole != null) {
            BlockPos pos = this.getMultiblock().blackHole.m_58899_();
            this.getMultiblock().blackHole = null;
            this.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
            this.mass = 0L;
            this.feeding = 0L;
            this.energyPerTick = 0;
            this.evaporation = 0;
            this.m_6596_();
        }
        if (!this.hasBlackhole()) {
            this.m_58904_().m_46597_(this.getMultiblock().getCenter(), ((Block)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("black_hole").get()).m_49966_());
            this.getMultiblock().blackHole = (BlackHoleBE)this.m_58904_().m_7702_(this.getMultiblock().getCenter());
            this.mass = (long)((double)BlackHoleBE.MIN_MASS * (1.0 + this.m_58904_().f_46441_.m_188500_()));
            this.gotLaserBurst = false;
            this.m_6596_();
        }
    }

    public boolean gotLaserBurst() {
        return this.gotLaserBurst;
    }

    public void gotEnergy(Direction facing) {
        this.pulseEnergy.put(facing, 1L);
        this.collectingEnergy = 2;
    }

    public static class Recipe
    extends NcRecipe {
        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(NAME, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return "kugelblitz_chamber";
        }

        @Override
        @NotNull
        public String m_6076_() {
            return "kugelblitz_chamber";
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get(NAME).get());
        }

        public int getBaseTime() {
            return (int)(this.timeModifier * 50.0);
        }

        @Override
        public double getEnergy() {
            return this.powerModifier * 1000.0;
        }

        public ItemStack getInputItem() {
            return StackUtils.resolveStackByModPriority(((Ingredient)this.getItemIngredients().get(0)).m_43908_());
        }
    }
}

