/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.storage.entity;

import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.api.nc.SideModeToggleable;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.energy.NCEnergy;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.util.ModUtil;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class BatteryBE
extends NCEnergy {
    public static final ModelProperty<HashMap<Integer, SideModeToggleable.SideMode>> SIDE_CONFIG = new ModelProperty();
    private int chargeCooldown = 0;

    public BatteryBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, BatteryBE.getName(pBlockState));
        for (Direction direction : Direction.values()) {
            this.sideConfig.put(direction.ordinal(), SideModeToggleable.SideMode.DEFAULT);
        }
    }

    public static String getName(BlockState pBlockState) {
        return pBlockState.m_60734_().m_5456_().toString();
    }

    @Nonnull
    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIDE_CONFIG, (Object)this.sideConfig).build();
    }

    @Override
    public void tickServer() {
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        super.tickServer();
        this.transferEnergy();
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
    }

    protected void transferEnergy() {
        block4: for (Direction direction : Direction.values()) {
            switch ((SideModeToggleable.SideMode)((Object)this.sideConfig.get(direction.ordinal()))) {
                case OUT: {
                    this.transferEnergyToSide(direction);
                    continue block4;
                }
                case IN: {
                    this.pullEnergyFromSide(direction);
                }
            }
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (ModUtil.isGtLoaded() && cap == GTCapability.CAPABILITY_ENERGY_CONTAINER && BatteryBE.isGTEUCapEnabled() && side != null && this.sideConfig.get(side.ordinal()) != SideModeToggleable.SideMode.DISABLED) {
            return GTUtils.getGTEnergy(this, side).cast();
        }
        if (cap == ForgeCapabilities.ENERGY && side != null && this.sideConfig.get(side.ordinal()) != SideModeToggleable.SideMode.DISABLED) {
            if (!GTUtils.isOnlyGTCEUCapEnabled()) {
                return this.getEnergy().cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected int getEnergyTransferPerTick() {
        return Math.min(BatteryBlocks.all().get(this.getName()).getStorage(), this.energyStorage().getEnergyStored());
    }

    @Override
    public int getMaxTransfer() {
        return this.getEnergyMaxStorage();
    }

    @Override
    public long getInputEnergyTier() {
        return BatteryBlocks.all().get(this.m_58900_().m_60734_().m_5456_().toString()).getEnergyTier().ordinal();
    }

    @Override
    public long getOutputEnergyTier() {
        return BatteryBlocks.all().get(this.m_58900_().m_60734_().m_5456_().toString()).getEnergyTier().ordinal();
    }

    @Override
    protected int getEnergyMaxStorage() {
        return BatteryBlocks.all().get(this.m_58900_().m_60734_().m_5456_().toString()).getStorage();
    }

    @Override
    protected void saveClientData(CompoundTag tag) {
        super.saveClientData(tag);
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    @Override
    public void loadClientData(CompoundTag tag) {
        super.loadClientData(tag);
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (!tag.m_128441_("sideConfig")) {
            return;
        }
        this.loadSideConfig(tag.m_128465_("sideConfig"));
    }

    private void loadSideConfig(int[] tagData) {
        boolean changed = false;
        for (int i = 0; i < this.sideConfig.size(); ++i) {
            SideModeToggleable.SideMode newMode = SideModeToggleable.SideMode.values()[tagData[i]];
            if (this.sideConfig.get(i) == newMode) continue;
            changed = true;
            this.sideConfig.remove(i);
            this.sideConfig.put(i, newMode);
        }
        if (changed) {
            this.requestModelDataUpdate();
            this.m_6596_();
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128385_("sideConfig", this.sideConfig.values().stream().mapToInt(Enum::ordinal).toArray());
    }

    public SideModeToggleable.SideMode toggleSideConfig(int direction) {
        this.sideConfig.put(direction, SideModeToggleable.SideMode.values()[(((SideModeToggleable.SideMode)((Object)this.sideConfig.get(direction))).ordinal() + 1) % 4]);
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        return (SideModeToggleable.SideMode)((Object)this.sideConfig.get(direction));
    }

    public void onLightningStrike() {
        if (this.chargeCooldown > 0) {
            return;
        }
        this.chargeCooldown = 600;
        this.energyStorage.addEnergy((Integer)CommonConfig.ENERGY_STORAGE.LIGHTNING_ROD_CHARGE.get());
        this.m_6596_();
        BlockPos pos = this.f_58858_;
        Direction direction = Direction.UP;
        Direction.Axis direction$axis = direction.m_122434_();
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = pos.m_123342_();
        double d2 = (double)pos.m_123343_() + 0.5;
        double d3 = 0.52;
        double d4 = this.f_58857_.m_213780_().m_188500_() * 0.6 - 0.3;
        double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
        double d6 = this.f_58857_.m_213780_().m_188500_() * 6.0 / 16.0;
        double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
        this.f_58857_.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
    }
}

