/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine.entity;

import igentuman.nc.block.turbine.TurbineBearingBlock;
import igentuman.nc.block.turbine.entity.TurbineBE;
import igentuman.nc.multiblock.turbine.CoilDef;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.util.annotation.NBTField;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TurbineCoilBE
extends TurbineBE {
    public static String NAME = "turbine_coil";
    public CoilDef def;
    @NBTField
    public boolean isValid = false;
    public double efficiency;
    @NBTField
    public boolean hasBearingConnection = false;

    public TurbineCoilBE(BlockPos pPos, BlockState pBlockState) {
        super(pPos, pBlockState, NAME);
    }

    public boolean isValid(boolean forceCheck) {
        if (forceCheck) {
            try {
                this.isValid = this.def().getValidator().isValid(this);
            }
            catch (NullPointerException ignore) {
                this.isValid = false;
            }
        }
        return this.isValid;
    }

    private CoilDef def() {
        Item item = this.m_58900_().m_60734_().m_5456_();
        if (item.equals(Items.f_41852_)) {
            return null;
        }
        if (this.def == null) {
            this.setCoilDef(TurbineRegistration.coils().get(item.toString().replaceAll("turbine_|_coil", "")));
        }
        return this.def;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setCoilDef(CoilDef def) {
        this.def = def;
        this.efficiency = def.getEfficiency();
    }

    public double getEfficiency() {
        if (this.efficiency == 0.0) {
            this.efficiency = this.def().getEfficiency();
        }
        return this.efficiency;
    }

    public double getRealEfficiency() {
        if (!this.isValid()) {
            return 0.0;
        }
        return this.getEfficiency();
    }

    public void validatePlacement() {
        if (this.getMultiblock() != null && !this.isValid) {
            for (Direction dir : Direction.values()) {
                BlockEntity be = Objects.requireNonNull(this.m_58904_()).getExistingBlockEntity(this.m_58899_().m_121945_(dir));
                BlockState bs = this.m_58904_().m_8055_(this.m_58899_().m_121945_(dir));
                if (bs.m_60734_() instanceof TurbineBearingBlock) {
                    this.hasBearingConnection = this.getMultiblock().bearingPositions.contains(this.m_58899_().m_121945_(dir));
                    break;
                }
                if (!(be instanceof TurbineCoilBE)) continue;
                TurbineCoilBE sideCoil = (TurbineCoilBE)be;
                if (!sideCoil.hasBearingConnection) continue;
                this.hasBearingConnection = true;
                break;
            }
            this.isValid(true);
        }
    }
}

