/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.block.turbine.entity;

import dan200.computercraft.shared.Capabilities;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.fission.FissionControllerBlock;
import igentuman.nc.client.sound.SoundHandler;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.cc.TurbinePeripheral;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.handler.sided.SidedContentHandler;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.NcFluidTank;
import igentuman.nc.multiblock.turbine.TurbineMultiblock;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCSounds;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.annotation.NBTField;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class TurbineControllerBE
extends MultiblockControllerBE {
    public static String NAME = "turbine_controller";
    public final SidedContentHandler contentHandler;
    public final CustomEnergyStorage energyStorage;
    protected final LazyOptional<IEnergyStorage> energy;
    @NBTField
    public BlockPos bearingPos = BlockPos.f_121853_;
    @NBTField
    public Direction orientation = Direction.NORTH;
    @NBTField
    public int energyPerTick = 0;
    @NBTField
    public int maxFlow = 0;
    @NBTField
    public int maxEnergy = 0;
    @NBTField
    public int realFlow = 0;
    @NBTField
    public double coilsEfficiency = 0.0;
    @NBTField
    public boolean powered = false;
    @NBTField
    protected boolean forceShutdown = false;
    @NBTField
    public int activeCoils = 0;
    @NBTField
    public float flow = 0.0f;
    @NBTField
    public float rotationSpeed = 0.0f;
    @NBTField
    public int blades = 0;
    @NBTField
    public double efficiency = 0.0;
    protected Direction facing;
    public Recipe recipe;
    public HashMap<String, Recipe> cachedRecipes = new HashMap();
    private List<FluidStack> allowedInputs;
    private LazyOptional<TurbinePeripheral> peripheralCap;

    public TurbineControllerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)TurbineRegistration.TURBINE_BE.get(NAME).get(), pPos, pBlockState);
        this.contentHandler = new SidedContentHandler(0, 0, 1, 1, 1000, 10000);
        this.contentHandler().fluidHandler.setGlobalMode(0, SlotModePair.SlotMode.INPUT);
        this.contentHandler().fluidHandler.setGlobalMode(1, SlotModePair.SlotMode.OUTPUT);
        this.contentHandler().setBlockEntity(this);
        this.contentHandler().setAllowedInputFluids(0, this::getAllowedInputFluids);
        this.energyStorage = this.createEnergy();
        this.energyStorage.setInputEnergyTier(0L).setOutputEnergyTier(this.getBaseGTEnergyTier()).setInputAmperage(0L).setOutputAmperage(16L);
        this.energy = LazyOptional.of(() -> this.energyStorage);
    }

    @Override
    public int getBaseGTEnergyTier() {
        return ((CommonConfig.GTCEUCompatibilityConfig.GTCEUTier)((Object)CommonConfig.GTCEU_CONFIG.TURBINE_ENERGY_TIER.get())).ordinal();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SidedContentHandler contentHandler() {
        return this.contentHandler;
    }

    @Override
    public CustomEnergyStorage energyStorage() {
        return this.energyStorage;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergy() {
        return this.energy;
    }

    private CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(100000000, 0, 100000000){

            @Override
            protected void onEnergyChanged() {
                TurbineControllerBE.this.m_6596_();
            }
        };
    }

    public void calculateMaxEnergy() {
        this.maxEnergy = (int)(Math.sqrt((double)(((long)this.maxFlow + 1L) * ((long)this.maxFlow + 2L)) / 2.0) * (Double)TurbineConfig.TURBINE_CONFIG.ENERGY_GEN.get() * (double)this.getEfficiencyRate() * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get());
    }

    public BlockPos getBlockPosForSteam() {
        BlockPos start = this.bearingPos.m_5484_(this.orientation, 1);
        if (!this.m_58904_().m_8055_(start).m_60713_(Blocks.f_50016_)) {
            return start;
        }
        start = this.bearingPos.m_5484_(this.orientation.m_122424_(), this.width - 1);
        return start;
    }

    public void voidFluidSlot(int slotId) {
        if (this.contentHandler() != null) {
            this.contentHandler().voidFluidSlot(slotId);
            this.m_6596_();
        }
    }

    @Override
    public Recipe getRecipe() {
        if (((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).isEmpty()) {
            return null;
        }
        return (Recipe)super.getRecipe();
    }

    public <T> LazyOptional<T> getPeripheral(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.peripheralCap == null) {
            this.peripheralCap = LazyOptional.of(() -> new TurbinePeripheral(this));
        }
        return this.peripheralCap.cast();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.contentHandler().getFluidCapability(side);
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (ModUtil.isCcLoaded() && cap == Capabilities.CAPABILITY_PERIPHERAL) {
            return this.getPeripheral(cap, side);
        }
        return super.getCapability(cap, side);
    }

    protected void playRunningSound() {
        if (this.m_58901_() || this.currentSound != null && !this.currentSound.m_7904_().equals((Object)((SoundEvent)NCSounds.TURBINE.get()).m_11660_())) {
            SoundHandler.stopTileSound(this.m_58899_());
            this.currentSound = null;
        }
        this.playSound(NCSounds.TURBINE, 0.2f);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isCasingValid || !this.isInternalValid) {
            this.stopSound();
            return;
        }
        if (this.rotationSpeed > 0.0f) {
            this.spawnSteamParticles();
            this.playRunningSound();
        } else {
            this.stopSound();
        }
    }

    @Override
    public void tickServer() {
        this.rotationSpeed = 0.0f;
        if (NuclearCraft.instance.isNcBeStopped || this.m_58901_()) {
            return;
        }
        this.changed = false;
        super.tickServer();
        boolean wasPowered = this.powered;
        this.handleValidation();
        this.trackChanges(wasPowered, this.powered);
        this.controllerEnabled = (this.hasRedstoneSignal() || this.controllerEnabled) && this.getMultiblock().isFormed();
        boolean bl = this.controllerEnabled = !this.forceShutdown && this.controllerEnabled;
        if (this.getMultiblock().isFormed()) {
            this.trackChanges(this.contentHandler().tick());
            if (this.controllerEnabled) {
                this.powered = this.processRecipe();
                this.trackChanges(this.powered);
            } else {
                this.powered = false;
            }
            this.handleMeltdown();
        }
        boolean bl2 = this.refreshCacheFlag = !this.getMultiblock().isFormed() || this.f_58857_.m_46467_() % 100L == 0L;
        if (wasPowered != this.powered) {
            this.m_6596_();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)));
        }
        if (this.refreshCacheFlag || this.changed) {
            try {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), (BlockState)this.m_58900_().m_61124_((Property)FissionControllerBlock.POWERED, (Comparable)Boolean.valueOf(this.powered)), 3);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.controllerEnabled = false;
    }

    public List<FluidStack> getAllowedInputFluids() {
        if (this.allowedInputs == null) {
            this.allowedInputs = new ArrayList<FluidStack>();
            for (NcRecipe ncRecipe : NcRecipeType.ALL_RECIPES.get(this.getName()).getRecipeType().getRecipes(this.m_58904_())) {
                for (FluidStackIngredient ingredient : ncRecipe.getInputFluids()) {
                    this.allowedInputs.addAll(ingredient.getRepresentations());
                }
            }
        }
        return this.allowedInputs;
    }

    @Override
    public TurbineMultiblock getMultiblock() {
        if (this.m_58904_().m_5776_()) {
            NuclearCraft.debugLog("Trying to access multiblock from client");
            return null;
        }
        if (this.multiblock == null) {
            this.multiblock = new TurbineMultiblock(this);
        }
        return (TurbineMultiblock)this.multiblock;
    }

    public float bladesEfficiency() {
        if (this.blades == 0) {
            return 0.0f;
        }
        return this.flow / (float)this.blades;
    }

    public float getEfficiencyRate() {
        return (float)(Math.log10(this.activeCoils) * this.coilsEfficiency * (double)this.bladesEfficiency()) / 1000.0f;
    }

    @Override
    public boolean canInvalidateCache() {
        return false;
    }

    private void handleMeltdown() {
    }

    private boolean processRecipe() {
        if (this.recipeInfo().recipe != null && this.recipeInfo().isCompleted() && this.contentHandler().fluidHandler.getFluidInSlot(0).isEmpty()) {
            this.recipeInfo().clear();
        }
        if (!this.hasRecipe()) {
            this.updateRecipe();
        }
        if (this.hasRecipe()) {
            return this.process();
        }
        return false;
    }

    public List<BlockPos> getBlocks(BlockPos pos, Direction.Axis axis) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        switch (axis) {
            case X: {
                positions.add(pos.m_7918_(0, -1, -1));
                positions.add(pos.m_7918_(0, -1, 1));
                positions.add(pos.m_7918_(0, 1, 1));
                positions.add(pos.m_7918_(0, 1, -1));
                break;
            }
            case Y: {
                positions.add(pos.m_7918_(-1, 0, -1));
                positions.add(pos.m_7918_(-1, 0, 1));
                positions.add(pos.m_7918_(1, 0, 1));
                positions.add(pos.m_7918_(1, 0, -1));
                break;
            }
            case Z: {
                positions.add(pos.m_7918_(-1, -1, 0));
                positions.add(pos.m_7918_(1, -1, 0));
                positions.add(pos.m_7918_(1, 1, 0));
                positions.add(pos.m_7918_(-1, 1, 0));
            }
        }
        return positions;
    }

    private void spawnSteamParticles() {
        if ((double)this.f_58857_.m_46467_() % Math.ceil(Math.log(1.0 / ((double)this.getRotationSpeed() + 0.001)) + 1.0) == 0.0) {
            BlockPos pos = this.getBlockPosForSteam();
            for (BlockPos source : this.getBlocks(pos, this.orientation.m_122434_())) {
                for (int i = 0; i < 3; ++i) {
                    double x = (double)((float)source.m_123341_() + 0.4f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    double y = (double)((float)source.m_123342_() + 0.7f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    double z = (double)((float)source.m_123343_() + 0.4f) + this.f_58857_.f_46441_.m_188583_() * 0.2;
                    float ySpeed = 0.0f;
                    float zSpeed = 0.0f;
                    float xSpeed = 0.0f;
                    switch (this.orientation) {
                        case UP: {
                            ySpeed = 0.05f + (float)(this.height - 1) * 0.03f;
                            break;
                        }
                        case DOWN: {
                            ySpeed = -0.05f - (float)(this.height - 1) * 0.03f;
                            break;
                        }
                        case NORTH: {
                            zSpeed = -0.05f - (float)(this.depth - 1) * 0.03f;
                            z -= 0.5;
                            break;
                        }
                        case SOUTH: {
                            zSpeed = 0.05f + (float)(this.depth - 1) * 0.03f;
                            z -= 0.5;
                            break;
                        }
                        case EAST: {
                            xSpeed = 0.05f + (float)(this.width - 1) * 0.03f;
                            z -= 0.5;
                            break;
                        }
                        case WEST: {
                            xSpeed = -0.05f - (float)(this.width - 1) * 0.03f;
                            z -= 0.5;
                        }
                    }
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, x, y, z, (double)xSpeed, (double)ySpeed, (double)zSpeed);
                }
            }
        }
    }

    private boolean process() {
        this.recipeInfo().process(1.0);
        this.flow = Math.max(1.0f, this.flow);
        double realFlow = this.getRealFlow();
        if (realFlow > 0.0) {
            this.realFlow = (int)Math.min(realFlow, (double)this.maxFlow);
        }
        this.rotationSpeed = (float)(((double)(this.rotationSpeed * 4.0f) + realFlow / (double)(this.flow * (float)((Integer)TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()).intValue())) / 5.0);
        this.energyStorage().addEnergy(this.calculateEnergy());
        this.efficiency = this.calculateEfficiency();
        this.handleRecipeOutput();
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).drain(this.realFlow, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }

    public void calculateMaxFlow() {
        this.maxFlow = (int)((double)(this.flow * (float)((Integer)TurbineConfig.TURBINE_CONFIG.BLADE_FLOW.get()).intValue()) * Math.pow(Math.log10(this.flow), 2.8));
    }

    private void handleRecipeOutput() {
        if (this.hasRecipe() && this.recipeInfo().isCompleted()) {
            if (this.recipe == null) {
                this.recipe = (Recipe)this.recipeInfo().recipe();
            }
            if (this.recipe.handleOutputs(this.contentHandler())) {
                this.updateRecipe();
                if (this.contentHandler().fluidHandler.getFluidInSlot(0).isEmpty()) {
                    this.recipe = null;
                }
            } else {
                this.recipeInfo().stuck = true;
            }
            this.m_6596_();
        }
    }

    public float coilsDrag() {
        return (float)Math.max(1.0, 100.0 / this.coilsEfficiency * Math.log(Math.log10(this.activeCoils + 4) + 2.0));
    }

    public int getRealFlow() {
        int wasFlow = this.realFlow;
        double cleanFlow = Math.min(this.maxFlow, this.getFluidTank(0).getFluidAmount());
        this.realFlow = (int)(cleanFlow / (double)this.coilsDrag());
        if (wasFlow != this.realFlow) {
            this.changed = true;
        }
        return this.realFlow;
    }

    private int calculateEnergy() {
        int wasEnergy = this.energyPerTick;
        this.energyPerTick = (int)(Math.sqrt((double)(((long)this.getRealFlow() + 1L) * ((long)this.getRealFlow() + 2L)) / 2.0) * (Double)TurbineConfig.TURBINE_CONFIG.ENERGY_GEN.get() * (double)this.getEfficiencyRate() * (Double)CommonConfig.ENERGY_GENERATION.GENERATION_MULTIPLIER.get() * this.recipeInfo().energy / 2.0);
        if (wasEnergy != this.energyPerTick) {
            this.changed = true;
        }
        return this.energyPerTick;
    }

    private void updateRecipe() {
        if (this.recipe != null) {
            if (this.recipe.test(this.contentHandler())) {
                this.recipeInfo().ticksProcessed = 0.0;
                return;
            }
            this.recipeInfo().clear();
        }
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.recipeInfo().setRecipe(this.recipe);
            this.recipeInfo().ticks = ((Recipe)this.recipeInfo().recipe()).getBaseTime();
            this.recipeInfo().energy = this.recipeInfo().recipe.getEnergy();
            this.recipeInfo().be = this;
        } else {
            this.recipeInfo().clear();
        }
    }

    public boolean recipeIsStuck() {
        return this.recipeInfo().isStuck();
    }

    public boolean hasRecipe() {
        return this.recipeInfo().recipe() != null;
    }

    public Direction getFacing() {
        if (this.facing == null) {
            this.facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        }
        return this.facing;
    }

    public double calculateEfficiency() {
        return (double)this.energyPerTick / (this.recipeInfo.energy / 100.0);
    }

    public boolean hasRedstoneSignal() {
        return Objects.requireNonNull(this.m_58904_()).m_276867_(this.f_58858_);
    }

    public void forceShutdown() {
        this.forceShutdown = true;
    }

    public void disableForceShutdown() {
        this.forceShutdown = false;
    }

    public boolean isProcessing() {
        return this.hasRecipe() && this.recipeInfo().ticksProcessed > 0.0 && !this.recipeInfo().isCompleted();
    }

    public int getActiveCoils() {
        return this.activeCoils;
    }

    public int getFlow() {
        return (int)this.flow;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public int getFlowRatio() {
        return (int)((float)this.realFlow / (float)this.maxFlow * 100.0f);
    }

    public void refresh() {
        double multiplier = (double)Math.round(Math.log(this.height * this.width * this.depth) * 10.0) / 10.0 - 1.0;
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(0))).setCapacity((int)(Math.pow(multiplier, 2.0) * 1000000.0));
        ((NcFluidTank)((Object)this.contentHandler().fluidHandler.tanks.get(1))).setCapacity((int)(Math.pow(multiplier, 2.0) * 1000000.0));
        this.calculateMaxFlow();
        this.calculateMaxEnergy();
        this.m_6596_();
    }

    public static class Recipe
    extends NcRecipe {
        public double ratio = 1.0;

        public Recipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double heatModifier, double rarity) {
            super(id, input, output, inputFluids, outputFluids, timeModifier, powerModifier, heatModifier, rarity);
            GlobalVars.CATALYSTS.put(NAME, List.of(this.m_8042_()));
        }

        @Override
        public String getCodeId() {
            return NAME;
        }

        @Override
        @NotNull
        public String m_6076_() {
            return NAME;
        }

        @Override
        @NotNull
        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)TurbineRegistration.TURBINE_BLOCKS.get(this.getCodeId()).get());
        }

        public int getBaseTime() {
            return (int)Math.max(1.0, this.timeModifier);
        }

        @Override
        public double getEnergy() {
            return Math.max(1.0, this.powerModifier);
        }

        @Override
        public boolean consumeInputs(SidedContentHandler contentHandler, int parallelProcessing) {
            TurbineControllerBE be = (TurbineControllerBE)contentHandler.blockEntity;
            int flow = be.realFlow;
            this.ratio = (double)flow / (double)this.getInputFluids(0).get(0).getAmount();
            FluidStack holded = contentHandler.fluidHandler.getFluidInSlot(0).copy();
            holded.setAmount(flow);
            contentHandler.fluidHandler.holdedInputs.add(holded);
            ((NcFluidTank)((Object)contentHandler.fluidHandler.tanks.get(0))).drain(flow, IFluidHandler.FluidAction.EXECUTE);
            return false;
        }

        @Override
        public boolean handleOutputs(SidedContentHandler contentHandler) {
            FluidStack outputFluid = (FluidStack)this.outputFluids[0].getRepresentations().get(0);
            FluidStack toOutput = outputFluid.copy();
            TurbineControllerBE be = (TurbineControllerBE)contentHandler.blockEntity;
            int flow = be.realFlow;
            this.ratio = (double)flow / (double)this.getInputFluids(0).get(0).getAmount();
            int toPush = (int)((double)outputFluid.getAmount() * this.ratio);
            toOutput.setAmount(toPush);
            return contentHandler.fluidHandler.insertFluidInternal(1, toOutput, true).getAmount() != toPush;
        }
    }
}

