/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.accelerator;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.GuiParticle;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.fluid.FluidTankRenderer;
import igentuman.nc.container.RingAcceleratorContainer;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class RingAcceleratorControllerScreen
extends AbstractContainerScreen<RingAcceleratorContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = NuclearCraft.rl("textures/gui/accelerators/linear_controller.png");
    protected int relX;
    protected int relY;
    private int xCenter;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    private VerticalBar heatBar;
    private VerticalBar coolantBar;
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();
    public GuiParticle guiParticle;
    private Button.MultiblockAnalyze analyzeBtn;

    public RingAcceleratorContainer container() {
        return (RingAcceleratorContainer)this.f_97732_;
    }

    public RingAcceleratorControllerScreen(RingAcceleratorContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 196;
        this.f_97727_ = 109;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(this.f_97726_ - 19, 80, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(this.f_97726_ - 32, 80, this, this.isInteriorValid());
        this.energyBar = new VerticalBar.Energy(7, 20, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.heatBar = new VerticalBar.Heat(17, 20, (IVerticalBarScreen)this, this.container().getMaxHeat());
        this.coolantBar = new VerticalBar.Coolant(27, 20, (IVerticalBarScreen)this, this.container().maxCoolant());
        this.guiParticle = new GuiParticle(40, 21);
        this.analyzeBtn = new Button.MultiblockAnalyze(170, 60, this, ((RingAcceleratorContainer)this.f_97732_).getPosition());
        this.widgets.add(new Button.ReportIssue(180, 15, this, ((RingAcceleratorContainer)this.f_97732_).getPosition()));
        this.widgets.add(this.analyzeBtn);
        this.widgets.add(new FluidTankRenderer(this.getFluidTank(2), FluidTankRenderer.TooltipMode.SHOW_AMOUNT_AND_CAPACITY, 6, 73, 28, 21));
    }

    protected void addWidget(NCGuiElement widget) {
        widget.setScreen(this);
        this.widgets.add(widget);
    }

    protected FluidTank getFluidTank(int i) {
        return ((RingAcceleratorContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.xCenter = this.getGuiLeft() - this.f_97726_ / 2;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid() && this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid() && this.isCasingValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid() && this.isCasingValid()) {
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.focus", TextUtils.numberFormat(this.container().getFocus())));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.quadroupoles", this.container().getQuadroupoles()));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.dipoles", this.container().getDipoles()));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.voltage", this.container().getVoltage()));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.amplifiers", this.container().getAmplifiers()));
            this.checkboxInterior.addTooltip((Component)TextUtils.__("tooltip.nc.accelerator.coolers", this.container().getCoolers()));
        }
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
        this.heatBar.draw(graphics, mouseX, mouseY, partialTicks);
        this.coolantBar.draw(graphics, mouseX, mouseY, partialTicks);
        if (this.hasParticle()) {
            this.guiParticle.drawParticleStack(graphics, this.getParticleStack());
        }
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((RingAcceleratorContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        this.casingTootip = this.isCasingValid() ? TextUtils.applyFormat((Component)TextUtils.__("tooltip.nc.accelerator.beam", this.getBeamLength()), ChatFormatting.GOLD) : TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("tooltip.nc.accelerator.voltage", this.container().getVoltage()), 37, 50, 0xFFFFFF);
                graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("tooltip.nc.accelerator.efficiency", TextUtils.numberFormat(this.container().getEfficiency()) + "%"), 37, 60, 0xFFFFFF);
                graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("tooltip.nc.accelerator.strength", TextUtils.numberFormat(this.container().getStrength())), 37, 70, 0xFFFFFF);
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private int getBeamLength() {
        return this.container().getBeamLength();
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    private int getMultiblockHeight() {
        return this.container().getHeight();
    }

    private int getMultiblockWidth() {
        return this.container().getWidth();
    }

    private int getMultiblockDepth() {
        return this.container().getDepth();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    private boolean hasParticle() {
        return this.container().hasParticle();
    }

    private ParticleStack getParticleStack() {
        return this.container().getParticleStack();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_6375_(pMouseX, pMouseY, pButton)) continue;
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.guiParticle.m_5953_(pMouseX, pMouseY) && this.hasParticle()) {
            this.guiParticle.renderTooltip(graphics, this.getParticleStack(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.heatBar.m_5953_(pMouseX, pMouseY)) {
            this.heatBar.clearTooltips();
            this.heatBar.addTooltip((Component)TextUtils.__("reactor.cooling", this.container().getCooling()).m_130940_(ChatFormatting.AQUA));
            this.heatBar.addTooltip((Component)TextUtils.__("reactor.heating", this.container().getHeating()).m_130940_(ChatFormatting.RED));
            this.heatBar.addTooltip((Component)TextUtils.__("reactor.net_heat", this.container().getNetHeat()).m_130940_(ChatFormatting.GOLD));
            graphics.m_280677_(this.f_96547_, this.heatBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.energyBar.m_5953_(pMouseX, pMouseY)) {
            this.energyBar.clearTooltips();
            if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
                this.energyBar.addTooltip((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.eu.per_tick", TextUtils.scaledFormat(((RingAcceleratorContainer)this.f_97732_).getEnergyRequired())), ChatFormatting.YELLOW));
                this.energyBar.addTooltip((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.eu.tier", ((RingAcceleratorContainer)this.f_97732_).getTier()), ChatFormatting.YELLOW));
            } else {
                this.energyBar.addTooltip((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.nc.energy.per_tick", TextUtils.scaledFormat(this.container().getEnergyRequired())).m_130940_(ChatFormatting.AQUA), new ChatFormatting[0]));
            }
            graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return this.container().getHeat();
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }

    @Override
    public double getProgress() {
        return 0.0;
    }
}

