/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.Units;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiParticle
extends NCGuiElement {
    public int x;
    public int y;

    public GuiParticle(int pX, int pY) {
        super(pX, pY, 16, 16, (Component)Component.m_237119_());
        this.x = pX;
        this.y = pY;
        this.width = 16;
        this.height = 16;
    }

    public void drawParticleStack(@NotNull GuiGraphics graphics, ParticleStack particleStack) {
        if (particleStack == null || particleStack.getParticle() == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)particleStack.getParticle().getTexture());
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)RELATIVE_X, (float)RELATIVE_Y, 0.0f);
        graphics.m_280163_(particleStack.getParticle().getTexture(), this.x, this.y, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280168_().m_85849_();
    }

    public void renderTooltip(GuiGraphics graphics, ParticleStack particleStack, int pMouseX, int pMouseY) {
        if (particleStack == null || particleStack.getParticle() == null) {
            return;
        }
        ArrayList<Object> text = new ArrayList<Object>();
        text.add(particleStack.getParticle().getLocalizedName());
        text.add(TextUtils.__("tooltip.nuclearcraft.particlestack.amount", Units.getSIFormat(particleStack.getAmount(), "pu")).m_130940_(ChatFormatting.GRAY));
        text.add(TextUtils.__("tooltip.nuclearcraft.particlestack.mean_energy", Units.getParticleEnergy(particleStack.getMeanEnergy())).m_130940_(ChatFormatting.GRAY));
        DecimalFormat df = new DecimalFormat("#.####");
        text.add(TextUtils.__("tooltip.nuclearcraft.particlestack.focus", df.format(particleStack.getFocus())).m_130940_(ChatFormatting.GRAY));
        graphics.m_280677_(Minecraft.m_91087_().f_91062_, text, Optional.empty(), pMouseX, pMouseY);
    }

    @Override
    public boolean m_5953_(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }
}

