/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.element.button;

import igentuman.nc.NuclearCraft;
import igentuman.nc.client.NcClient;
import igentuman.nc.client.gui.MultiblockAnalyzeReportScreen;
import igentuman.nc.client.gui.MultiblockBuilderScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.processor.side.SideConfigSlotSelectionScreen;
import igentuman.nc.compat.emi.EMIPlugin;
import igentuman.nc.container.MultiblockControllerContailer;
import igentuman.nc.network.toServer.PacketBuildMultiblock;
import igentuman.nc.network.toServer.PacketGuiButtonPress;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.builder.ReactorDesignParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class Button<T extends AbstractContainerScreen<?>>
extends NCGuiElement {
    protected AbstractContainerMenu container;
    protected AbstractContainerScreen<?> screen;
    protected int bId;
    protected net.minecraft.client.gui.components.Button btn;
    protected Component tooltipKey = Component.m_237119_();

    public Button(int xPos, int yPos, T screen, int id) {
        super(xPos, yPos, 18, 18, (Component)Component.m_237119_());
        this.x = xPos;
        this.y = yPos;
        this.container = screen.m_6262_();
        this.screen = screen;
        this.bId = id;
    }

    public Button(int xPos, int yPos, AbstractContainerScreen<?> explScreen, int id, MutableComponent label, Button.OnPress o) {
        super(xPos, yPos, 18, 18, (Component)label);
        this.x = xPos;
        this.y = yPos;
        this.container = explScreen.m_6262_();
        this.screen = explScreen;
        this.bId = id;
        this.height = 20;
        this.width = 80;
        this.btn = new Button.Builder((Component)label, o).m_252794_(this.X(), this.Y()).m_253046_(80, 20).m_253136_();
    }

    @Override
    public List<Component> getTooltips() {
        return List.of(this.tooltipKey);
    }

    @Override
    public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
        super.draw(transform, mX, mY, pTicks);
        this.btn.m_88315_(transform, mX, mY, pTicks);
    }

    @Override
    public boolean onPress() {
        this.btn.m_5691_();
        return true;
    }

    public void setEnabled(boolean b) {
        this.btn.f_93623_ = b;
    }

    @Override
    public boolean m_5953_(double pMouseX, double pMouseY) {
        return this.active && this.visible && pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if ((double)this.X() <= pMouseX && pMouseX < (double)(this.X() + this.width) && (double)this.Y() <= pMouseY && pMouseY < (double)(this.Y() + this.height)) {
            return this.onPress();
        }
        return false;
    }

    public static class Kugelblitz
    extends Button {
        public final BlockPos pos;
        public static final int BTN_ID = 75;
        public byte mode = (byte)2;
        public byte strength = 0;

        public Kugelblitz(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 75);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 202, 256, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, this.bId)));
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(TextUtils.__("gui.nc.kugelblits_port.tooltip_" + this.mode, new Object[0]), TextUtils.__("gui.nc.kugelblits_port.tooltip_strength", this.strength));
        }

        public void setMode(byte redstoneMode) {
            this.mode = redstoneMode;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 202, 256 - (redstoneMode + 1) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 75)));
        }
    }

    public static class TurbinePortRedstoneModeButton
    extends Button {
        public final BlockPos pos;
        public static final int BTN_ID = 74;
        public byte mode = (byte)2;
        public byte strength = 0;

        public TurbinePortRedstoneModeButton(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 74);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, this.bId)));
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(TextUtils.__("gui.nc.turbine_comparator_config.tooltip_" + this.mode, new Object[0]), TextUtils.__("gui.nc.reactor_comparator_strength.tooltip", this.strength));
        }

        public void setMode(byte redstoneMode) {
            this.mode = redstoneMode;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256 - (redstoneMode + 1) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 74)));
        }
    }

    public static class ReactorPortRedstoneModeButton
    extends Button {
        public final BlockPos pos;
        public static final int BTN_ID = 71;
        public byte mode = (byte)2;
        public byte strength = 0;

        public ReactorPortRedstoneModeButton(int btId, int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, btId);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, this.bId)));
        }

        public ReactorPortRedstoneModeButton(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 71);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, this.bId)));
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(TextUtils.__("gui.nc.reactor_comparator_config.tooltip_" + this.mode, new Object[0]), TextUtils.__("gui.nc.reactor_comparator_strength.tooltip", this.strength));
        }

        public void setMode(byte redstoneMode) {
            this.mode = redstoneMode;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256 - (redstoneMode + 1) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 71)));
        }
    }

    public static class FusionReactorRedstoneModeButton
    extends ReactorPortRedstoneModeButton {
        public static final int BTN_ID = 73;

        public FusionReactorRedstoneModeButton(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(73, xPos, yPos, screen, pos);
        }

        @Override
        public void setMode(byte redstoneMode) {
            this.mode = redstoneMode;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 256 - (redstoneMode - 10) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 73)));
        }
    }

    public static class Link
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 890;
        public byte strength = 0;
        public AbstractContainerScreen<?> screen;
        public String link = "";
        public List<Component> tooltips = new ArrayList<Component>();

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            super.draw(transform, mX, mY, pTicks);
        }

        public Link(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos, String link, List<Component> tooltips) {
            super(xPos, yPos, screen, 890);
            this.screen = screen;
            this.link = link;
            this.pos = pos;
            this.tooltips = tooltips;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 126, 220, 18, TEXTURE, pButton -> {
                try {
                    Util.m_137581_().m_137646_(link);
                }
                catch (Exception e) {
                    NuclearCraft.debugLog("Failed to open link: " + link);
                }
            });
        }

        @Override
        public List<Component> getTooltips() {
            return this.tooltips;
        }
    }

    public static class Build
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 889;
        public byte strength = 0;
        public int timer = 2000;
        public MultiblockBuilderScreen screen;

        @Override
        public void draw(GuiGraphics transform, int mX, int mY, float pTicks) {
            if (this.screen.blockMap.isEmpty()) {
                return;
            }
            super.draw(transform, mX, mY, pTicks);
        }

        public Build(int xPos, int yPos, MultiblockBuilderScreen screen, BlockPos pos) {
            super(xPos, yPos, screen, 889);
            this.screen = screen;
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 162, 220, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketBuildMultiblock(pos, screen.blockMap)));
        }

        @Override
        public List<Component> getTooltips() {
            List<MutableComponent> list = List.of(TextUtils.__("tooltip.nc.build", new Object[0]));
            if (this.visible && this.active) {
                return list;
            }
            return List.of();
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class InsertJson
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 888;
        public byte strength = 0;
        public int timer = 2000;

        public InsertJson(int xPos, int yPos, MultiblockBuilderScreen screen, BlockPos pos) {
            super(xPos, yPos, screen, 888);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 144, 220, 18, TEXTURE, pButton -> {
                try {
                    String jsonText = Minecraft.m_91087_().f_91068_.m_90876_();
                    if (jsonText != null && !jsonText.isEmpty()) {
                        screen.jsonText = jsonText;
                        screen.blockMap = ReactorDesignParser.parseStructure(jsonText);
                    }
                }
                catch (Exception e) {
                    NuclearCraft.debugLog("Error getting clipboard data");
                }
            });
        }

        @Override
        public List<Component> getTooltips() {
            List<MutableComponent> list = List.of(TextUtils.__("tooltip.nc.paste_json", new Object[0]), TextUtils.__("tooltip.nc.paste_json.descr", new Object[0]));
            return list;
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class ReportIssue
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 889;
        public byte strength = 0;
        public int timer = 2000;
        private final ResourceLocation BTN_TEXTURE = NuclearCraft.rl("textures/gui/buttons/bug.png");

        public ReportIssue(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 889);
            this.pos = pos;
            this.height = 8;
            this.width = 8;
            String link = "https://github.com/igentuman/NuclearCraft-Neoteric/issues/new?template=bug_report.md";
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 0, 0, 8, this.BTN_TEXTURE, 8, 16, pButton -> {
                try {
                    Util.m_137581_().m_137646_(link);
                }
                catch (Exception e) {
                    NuclearCraft.debugLog("Failed to open link: " + link);
                }
            });
        }

        @Override
        public List<Component> getTooltips() {
            List<MutableComponent> list = List.of(TextUtils.__("tooltip.nc.report_issue", new Object[0]));
            return list;
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class MultiblockAnalyze
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 777;
        public byte strength = 0;
        public int timer = 2000;

        public MultiblockAnalyze(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 777);
            MultiblockControllerContailer container = new MultiblockControllerContailer(pos);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 112, 18, TEXTURE, pButton -> {
                NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, 777));
                Minecraft.m_91087_().m_91346_(new MultiblockAnalyzeReportScreen<MultiblockControllerContailer>(screen, container));
            });
        }

        @Override
        public List<Component> getTooltips() {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(TextUtils.__("tooltip.nc.analyze", new Object[0])));
            if (this.timer < 2000) {
                list.add(TextUtils.__("gui.nc.reactor_mode.timer", this.timer / 20));
            } else {
                list.add(TextUtils.__("tooltip.nc.analyze.descr", new Object[0]));
            }
            return list;
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class ReactorMode
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 72;
        public boolean mode = false;
        public byte strength = 0;
        public int timer = 2000;

        public ReactorMode(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 72);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 220, 184, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(pos, 72)));
        }

        @Override
        public List<Component> getTooltips() {
            String code = "energy";
            if (this.mode) {
                code = "steam";
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(TextUtils.__("gui.nc.reactor_mode.tooltip_" + code, new Object[0])));
            if (this.timer < 2000) {
                list.add(TextUtils.__("gui.nc.reactor_mode.timer", this.timer / 20));
            }
            return list;
        }

        public void setMode(boolean reactorMode) {
            this.mode = reactorMode;
            int y = reactorMode ? 1 : 0;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 220, 184 - (y + 1) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 72)));
        }

        public void setTimer(int modeTimer) {
            this.timer = modeTimer;
        }
    }

    public static class Magnet
    extends Button {
        public static final int BTN_ID = 184;
        public boolean enabled = false;
        public byte strength = 0;

        public Magnet(int xPos, int yPos, AbstractContainerScreen<?> screen) {
            super(xPos, yPos, screen, 184);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 112, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(NcClient.tryGetClientPlayer(), 184)));
        }

        @Override
        public List<Component> getTooltips() {
            String mode = "enable";
            if (this.enabled) {
                mode = "disable";
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(List.of(TextUtils.__("tooltip.nc.magnet." + mode, new Object[0])));
            return list;
        }

        @Override
        public void setEnabled(boolean flag) {
            this.enabled = flag;
            int y = flag ? 1 : 0;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 112 - (y + 1) * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(NcClient.tryGetClientPlayer(), 184)));
        }

        public void refreshPosition() {
            this.setEnabled(this.enabled);
        }
    }

    public static class CloseConfig
    extends Button {
        public <T extends AbstractContainerMenu> CloseConfig(int xPos, int yPos, AbstractContainerScreen<T> screen) {
            super(xPos, yPos, screen, 71);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 202, 220, 18, TEXTURE, pButton -> this.screen.m_7379_());
        }
    }

    public static class ShowRecipes
    extends Button {
        public int mode = 0;

        public ShowRecipes(int xPos, int yPos, AbstractContainerScreen<?> screen) {
            super(xPos, yPos, screen, 70);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 238, 76, 18, TEXTURE, pButton -> {
                if (ModUtil.isEMILoaded()) {
                    EMIPlugin.displayRecipes(screen);
                }
            });
        }

        @Override
        public List<Component> getTooltips() {
            return List.of();
        }
    }

    public static class RedstoneConfig
    extends Button {
        private final BlockPos pos;
        public static final int BTN_ID = 70;
        public int mode = 0;

        public RedstoneConfig(int xPos, int yPos, AbstractContainerScreen<?> screen, BlockPos pos) {
            super(xPos, yPos, screen, 70);
            this.pos = pos;
            this.height = 18;
            this.width = 18;
        }

        @Override
        public List<Component> getTooltips() {
            return List.of(TextUtils.__("gui.nc.redstone_config.tooltip_" + this.mode, new Object[0]));
        }

        public void setMode(int redstoneMode) {
            this.mode = redstoneMode;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 184, 220 - redstoneMode * 36, 18, TEXTURE, pButton -> NuclearCraft.packetHandler().sendToServer(new PacketGuiButtonPress(this.pos, 70)));
        }
    }

    public static class SideConfig
    extends Button {
        public SideConfig(int xPos, int yPos, AbstractContainerScreen<?> screen) {
            super(xPos, yPos, screen, 69);
            this.height = 18;
            this.width = 18;
            this.btn = new ImageButton(this.X(), this.Y(), this.width, this.height, 220, 220, 18, TEXTURE, pButton -> Minecraft.m_91087_().m_91346_(new SideConfigSlotSelectionScreen(screen)));
            this.tooltipKey = TextUtils.__("gui.nc.side_config.tooltip", new Object[0]);
        }
    }
}

