/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.gui.kugelblitz;

import com.mojang.blaze3d.systems.RenderSystem;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.kugelblitz.entity.BlackHoleBE;
import igentuman.nc.client.gui.IProgressScreen;
import igentuman.nc.client.gui.IVerticalBarScreen;
import igentuman.nc.client.gui.element.NCGuiElement;
import igentuman.nc.client.gui.element.TooltipArea;
import igentuman.nc.client.gui.element.bar.ProgressBar;
import igentuman.nc.client.gui.element.bar.VerticalBar;
import igentuman.nc.client.gui.element.button.Button;
import igentuman.nc.client.gui.element.button.Checkbox;
import igentuman.nc.client.gui.element.button.SliderHorizontal;
import igentuman.nc.container.ChamberTerminalContainer;
import igentuman.nc.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ChamberTerminalScreen
extends AbstractContainerScreen<ChamberTerminalContainer>
implements IProgressScreen,
IVerticalBarScreen {
    protected final ResourceLocation GUI = NuclearCraft.rl("textures/gui/kugelblitz/controller.png");
    protected int relX;
    protected int relY;
    private SliderHorizontal energyTransferRateSlider;
    private SliderHorizontal frequencySlider;
    public List<NCGuiElement> widgets = new ArrayList<NCGuiElement>();
    public Checkbox checkboxCasing;
    public Checkbox checkboxInterior;
    private VerticalBar energyBar;
    public Component casingTootip = Component.m_237119_();
    public Component interiorTootip = Component.m_237119_();

    public ChamberTerminalContainer container() {
        return (ChamberTerminalContainer)this.f_97732_;
    }

    public ChamberTerminalScreen(ChamberTerminalContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.f_97726_ = 214;
        this.f_97727_ = 186;
    }

    protected void updateRelativeCords() {
        this.relX = (this.f_96543_ - this.f_97726_) / 2;
        this.relY = (this.f_96544_ - this.f_97727_) / 2;
        NCGuiElement.RELATIVE_X = this.relX;
        NCGuiElement.RELATIVE_Y = this.relY;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            widget.m_6375_(pMouseX, pMouseY, pButton);
        }
        this.f_97738_ = false;
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        for (NCGuiElement widget : this.widgets) {
            widget.m_6348_(pMouseX, pMouseY, pButton);
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        for (NCGuiElement widget : this.widgets) {
            widget.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    protected void m_7856_() {
        super.m_7856_();
        Minecraft mc = Minecraft.m_91087_();
        this.updateRelativeCords();
        this.widgets.clear();
        this.checkboxCasing = new Checkbox(6, 104, this, this.isCasingValid());
        this.checkboxInterior = new Checkbox(6, 122, this, this.isInteriorValid());
        this.energyBar = new VerticalBar.Energy(200, 104, (IVerticalBarScreen)this, this.container().getMaxEnergy());
        this.energyTransferRateSlider = new SliderHorizontal(6, 70, 119, this, ((ChamberTerminalContainer)this.f_97732_).getBlockPos());
        this.frequencySlider = new SliderHorizontal(6, 90, 119, this, ((ChamberTerminalContainer)this.f_97732_).getBlockPos(), 1);
        this.frequencySlider.slideTo((int)((double)this.container().getFrequency() / 0.15));
        this.energyTransferRateSlider.slideTo(this.container().getEnergyRate());
        this.widgets.add(this.energyTransferRateSlider);
        this.widgets.add(new Button.ReportIssue(6, 150, this, ((ChamberTerminalContainer)this.f_97732_).getBlockPos()));
        this.widgets.add(this.frequencySlider);
        this.widgets.add(new ProgressBar(152, 81, this, 2));
        this.widgets.add(new TooltipArea(6, 48, 30, 10).setTooltipKey("tooltip.kugelblitz.stability_info"));
    }

    protected FluidTank getFluidTank(int i) {
        return ((ChamberTerminalContainer)this.f_97732_).getFluidTank(i);
    }

    private boolean isInteriorValid() {
        return this.container().isInteriorValid();
    }

    private boolean isCasingValid() {
        return this.container().isCasingValid();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    private void renderWidgets(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        for (NCGuiElement widget : this.widgets) {
            widget.draw(graphics, mouseX, mouseY, partialTicks);
        }
        this.checkboxCasing.setChecked(this.isCasingValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isCasingValid()) {
            this.checkboxCasing.setTooltipKey("multiblock.casing.complete");
            if (!this.container().hasBlackhole()) {
                this.checkboxCasing.addTooltip((Component)TextUtils.__("tooltip.kugelblitz.ready_for_burst", new Object[0]).m_130940_(ChatFormatting.AQUA));
            }
        } else {
            this.checkboxCasing.setTooltipKey("multiblock.casing.incomplete");
        }
        this.checkboxCasing.addTooltip(this.casingTootip);
        this.checkboxInterior.setChecked(this.isInteriorValid()).draw(graphics, mouseX, mouseY, partialTicks);
        if (this.isInteriorValid()) {
            this.checkboxInterior.setTooltipKey("multiblock.interior.complete");
        } else {
            this.checkboxInterior.setTooltipKey("multiblock.interior.incomplete");
        }
        this.checkboxInterior.addTooltip(this.interiorTootip);
        if (this.isInteriorValid()) {
            // empty if block
        }
        this.energyBar.draw(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280653_(this.f_96547_, ((ChamberTerminalContainer)this.f_97732_).getTitle(), this.f_97726_ / 2, this.f_97729_, 0xFFFFFF);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.frequency", this.container().getFrequency()), 12, 164, 0x8AFF8A);
        graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.transformation", new Object[0]), 12, 128, 0x8AFF8A);
        int w = this.f_96547_.m_92852_((FormattedText)TextUtils.__("label.kugelblitz.energy_gen", new Object[0]));
        graphics.m_280653_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.energy_gen", new Object[0]), 248 - w / 2, 128, 0x8AFF8A);
        graphics.m_280168_().m_85849_();
        if (!this.isCasingValid()) {
            this.casingTootip = TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
        }
        if (this.isCasingValid()) {
            if (this.isInteriorValid()) {
                if (this.container().hasBlackhole()) {
                    int color = 0x8AFF8A;
                    if ((double)this.container().getMass() < (double)BlackHoleBE.MIN_MASS * 1.1 || (double)this.container().getMass() > (double)BlackHoleBE.MAX_MASS * 0.9) {
                        color = 0xFF0000;
                    }
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.blackhole_mass", TextUtils.formatMass(this.container().getMass())), 6, 16, color);
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.evaporation", TextUtils.formatMass(this.container().getEvaporation())), 6, 27, 0x8AFF8A);
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.feeding", TextUtils.formatMass(this.container().getFeeding())), 6, 38, 0x8AFF8A);
                    color = 0x8AFF8A;
                    if (this.container().getStability() < 40) {
                        color = 0xFF0000;
                    }
                    graphics.m_280430_(this.f_96547_, (Component)TextUtils.__("label.kugelblitz.stability", this.container().getStability()), 6, 48, color);
                }
                this.checkboxCasing.addTooltip((Component)TextUtils.__("tooltip.kugelblitz.flux_regulators", this.container().getFluxRegulators()));
                this.checkboxCasing.addTooltip((Component)TextUtils.__("tooltip.kugelblitz.transformers", this.container().getTransformers()));
                this.checkboxCasing.addTooltip((Component)TextUtils.__("tooltip.kugelblitz.stabilizers", this.container().getStabilizers()));
            } else {
                this.interiorTootip = TextUtils.applyFormat((Component)TextUtils.__(this.getValidationResultKey(), this.getValidationResultData()), ChatFormatting.RED);
            }
        }
        this.renderTooltips(graphics, mouseX - this.relX, mouseY - this.relY);
    }

    private Object getValidationResultData() {
        return this.container().getValidationResultData().m_123344_();
    }

    private String getValidationResultKey() {
        return this.container().getValidationResultKey();
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        this.updateRelativeCords();
        graphics.m_280218_(this.GUI, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        this.renderWidgets(graphics, partialTicks, mouseX, mouseY);
    }

    private void renderTooltips(GuiGraphics graphics, int pMouseX, int pMouseY) {
        for (NCGuiElement widget : this.widgets) {
            if (!widget.m_5953_(pMouseX, pMouseY)) continue;
            graphics.m_280677_(this.f_96547_, widget.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxCasing.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxCasing.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        if (this.checkboxInterior.m_5953_(pMouseX, pMouseY)) {
            graphics.m_280677_(this.f_96547_, this.checkboxInterior.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
        this.energyBar.clearTooltips();
        this.energyBar.addTooltip((Component)TextUtils.__(TextUtils.energyGenLine(), this.container().energyPerTick()));
        if (this.energyBar.m_5953_(pMouseX, pMouseY + 10)) {
            graphics.m_280677_(this.f_96547_, this.energyBar.getTooltips(), Optional.empty(), pMouseX, pMouseY);
        }
    }

    @Override
    public double getProgress() {
        return this.container().getProgress();
    }

    @Override
    public double getEnergy() {
        return this.container().getEnergy();
    }

    @Override
    public double getHeat() {
        return 0.0;
    }

    @Override
    public double getCoolant() {
        return 0.0;
    }

    @Override
    public double getHotCoolant() {
        return 0.0;
    }
}

