/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import igentuman.nc.NuclearCraft;
import igentuman.nc.client.model.ModelWastelandBoss;
import igentuman.nc.entity.EntityWastelandBoss;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;

public class WastelandBossRenderer
extends MobRenderer<EntityWastelandBoss, ModelWastelandBoss<EntityWastelandBoss>> {
    private static final ResourceLocation TEXTURE = NuclearCraft.rl("textures/entity/wasteland_boss.png");
    private static final ResourceLocation BOSS_GLOW_TEXTURE = NuclearCraft.rl("textures/entity/wasteland_boss_glow.png");
    private final RandomSource random = RandomSource.m_216327_();

    public WastelandBossRenderer(EntityRendererProvider.Context context) {
        super(context, new ModelWastelandBoss(context.m_174023_(ModelWastelandBoss.LAYER_LOCATION)), 0.8f);
        this.m_115326_(new WastelandBossGlowLayer(this));
    }

    public ResourceLocation getTextureLocation(EntityWastelandBoss entity) {
        return TEXTURE;
    }

    public void render(EntityWastelandBoss entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    private static class WastelandBossGlowLayer
    extends RenderLayer<EntityWastelandBoss, ModelWastelandBoss<EntityWastelandBoss>> {
        public WastelandBossGlowLayer(WastelandBossRenderer renderer) {
            super((RenderLayerParent)renderer);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, EntityWastelandBoss entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.m_20145_()) {
                ModelWastelandBoss model = (ModelWastelandBoss)this.m_117386_();
                float glowIntensity = 0.5f + 0.5f * (float)Math.sin(((float)entitylivingbaseIn.f_19797_ + partialTicks) * 0.1f);
                int glowLight = 0xF000F0;
                model.m_7695_(matrixStackIn, bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)BOSS_GLOW_TEXTURE)), glowLight, packedLightIn, 1.0f, glowIntensity, glowIntensity, 1.0f);
            }
        }
    }
}

