/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.cc;

import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import java.util.HashMap;
import javax.annotation.Nonnull;

public class LinearAcceleratorPeripheral
implements IPeripheral {
    private final LinearAcceleratorControllerBE controller;

    public LinearAcceleratorPeripheral(LinearAcceleratorControllerBE controller) {
        this.controller = controller;
    }

    @Nonnull
    public String getType() {
        return "nc_accelerator";
    }

    public boolean equals(IPeripheral other) {
        return this == other || other instanceof LinearAcceleratorPeripheral && ((LinearAcceleratorPeripheral)other).controller == this.controller;
    }

    @LuaFunction
    public final boolean isFormed() {
        return this.controller.isCasingValid && this.controller.isInternalValid;
    }

    @LuaFunction
    public final String getName() {
        return this.controller.getName();
    }

    @LuaFunction
    public final boolean hasParticle() {
        return this.controller.hasParticle;
    }

    @LuaFunction
    public final int getEnergyStored() {
        return this.controller.energyStorage().getEnergyStored();
    }

    @LuaFunction
    public final int getTemperature() {
        return this.controller.heat;
    }

    @LuaFunction
    public final int getMaxTemperature() {
        return this.controller.maxTemperature;
    }

    @LuaFunction
    public final Object getHeatBufferInfo() {
        HashMap<String, Integer> statsData = new HashMap<String, Integer>();
        statsData.put("heat_stored", this.isMultiblockAssembled() ? this.controller.heat : 0);
        statsData.put("heat_capacity", this.isMultiblockAssembled() ? this.controller.heatMax : 0);
        return statsData;
    }

    @LuaFunction
    public final Object getCoolingInfo() {
        HashMap<String, Object> statsData = new HashMap<String, Object>();
        statsData.put("cooling_fluid", this.isMultiblockAssembled() ? this.controller.getFluidTank(2).getFluid().getTranslationKey() : "");
        statsData.put("cooling", this.isMultiblockAssembled() ? this.controller.coolingRate : 0);
        return statsData;
    }

    @LuaFunction
    public Object getStats() {
        HashMap<String, Number> statsData = new HashMap<String, Number>();
        statsData.put("accelerating_voltage", this.isMultiblockAssembled() ? this.controller.acceleratingVoltage : 0L);
        statsData.put("dipole_strength", this.isMultiblockAssembled() ? this.controller.dipoleStrength : 0.0);
        statsData.put("quadrupole_strength", this.isMultiblockAssembled() ? this.controller.quadStrength : 0.0);
        statsData.put("input_particle_min_energy", this.isMultiblockAssembled() ? this.controller.getMinEnergy() : 0);
        return statsData;
    }

    private boolean isMultiblockAssembled() {
        return this.controller.isCasingValid && this.controller.isInternalValid;
    }

    @LuaFunction
    public final int getHeatRate() {
        return this.controller.heatRate;
    }

    @LuaFunction
    public final Object getParticleInfo() {
        return this.controller.getParticleStack();
    }

    @LuaFunction
    public final boolean isAcceleratorOn() {
        return this.controller.controllerEnabled;
    }

    public final String getAcceleratorType() {
        return "linear_accelerator";
    }

    public void setEnergyPercentage(double percentage) {
        if (percentage < 5.0) {
            percentage = 0.0;
        }
        if (percentage > 100.0) {
            percentage = 100.0;
        }
        this.controller.redstoneLevel = percentage * 0.15;
    }
}

