/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import igentuman.nc.NuclearCraft;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.TextUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class KugelblitzInfoEmiCategory
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(NuclearCraft.rl("kugelblitz_info"), (EmiRenderable)EmiStack.of((ItemStack)new ItemStack((ItemLike)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get())));
    private final ItemStack itemStack;
    private final boolean isUnknownIngredient;

    public KugelblitzInfoEmiCategory(ResourceLocation id, ItemStack itemStack) {
        super(CATEGORY, id, 160, 160);
        this.itemStack = itemStack;
        this.isUnknownIngredient = itemStack.m_41720_() == NCItems.UNKNOWN_INGREDIENT.get();
        EmiStack emiStack = EmiStack.of((ItemStack)itemStack);
        this.inputs.add(emiStack);
        this.outputs.add(emiStack);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 2, 2).recipeContext((EmiRecipe)this);
        String itemName = this.isUnknownIngredient ? "Unknown Ingredient" : this.itemStack.m_41786_().getString();
        widgets.addText((Component)Component.m_237113_((String)itemName), 25, 2, Color.WHITE.getRGB(), false);
        int yOffset = 20;
        int lineHeight = 10;
        String description = TextUtils.__("jei.info.nuclearcraft.kugelblitz.description", new Object[0]).getString();
        List<String> descriptionLines = this.wrapText(description, 30);
        for (String line : descriptionLines) {
            widgets.addText((Component)Component.m_237113_((String)line), 0, yOffset, Color.DARK_GRAY.getRGB(), false);
            yOffset += lineHeight;
        }
        yOffset += 5;
        String problem = TextUtils.__("jei.info.nuclearcraft.kugelblitz.problem", new Object[0]).getString();
        List<String> problemLines = this.wrapText(problem, 30);
        for (String line : problemLines) {
            widgets.addText((Component)Component.m_237113_((String)line), 0, yOffset, Color.DARK_GRAY.getRGB(), false);
            yOffset += lineHeight;
        }
        yOffset += 5;
        String inputOutput = TextUtils.__("jei.info.nuclearcraft.kugelblitz.input_output", new Object[0]).getString();
        List<String> inputOutputLines = this.wrapText(inputOutput, 30);
        for (String line : inputOutputLines) {
            widgets.addText((Component)Component.m_237113_((String)line), 0, yOffset, Color.DARK_GRAY.getRGB(), false);
            yOffset += lineHeight;
        }
    }

    private List<String> wrapText(String text, int maxCharsPerLine) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxCharsPerLine) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                if (word.length() > maxCharsPerLine) {
                    while (word.length() > maxCharsPerLine) {
                        lines.add(word.substring(0, maxCharsPerLine));
                        word = word.substring(maxCharsPerLine);
                    }
                    if (word.isEmpty()) continue;
                    currentLine.append(word);
                    continue;
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static Component getTitle() {
        return Component.m_237115_((String)"emi.category.nuclearcraft.kugelblitz_info");
    }
}

