/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi;

import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.emi.ingredient.ParticleEmiStack;
import igentuman.nc.compat.jei.ParticleRecipe;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.Units;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ParticleInfoEmiCategory
extends BasicEmiRecipe {
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(NuclearCraft.rl("particle_info"), (EmiRenderable)ParticleEmiStack.of(new ParticleStack(Particles.proton)));
    private final ParticleRecipe recipe;

    public ParticleInfoEmiCategory(ParticleRecipe recipe) {
        super(CATEGORY, recipe.getId(), 160, 180);
        this.recipe = recipe;
        ParticleEmiStack particleStack = ParticleEmiStack.of(recipe.getIngredient());
        this.inputs.add(particleStack);
        this.outputs.add(particleStack);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 2, 2).recipeContext((EmiRecipe)this);
        DecimalFormat df = new DecimalFormat("#.##");
        widgets.addText((Component)TextUtils.__(this.recipe.getName(), new Object[0]), 25, 2, Color.WHITE.getRGB(), false);
        int yOffset = 20;
        int lineHeight = 10;
        widgets.addText((Component)TextUtils.__("gui.nuclearcraft.jei.particle.mass", Units.getSIFormat(this.recipe.getMass(), 6, "eV/c^2")), 0, yOffset, Color.DARK_GRAY.getRGB(), false);
        widgets.addText((Component)TextUtils.__("gui.nuclearcraft.jei.particle.charge", df.format(this.recipe.getCharge())), 0, yOffset += lineHeight, Color.DARK_GRAY.getRGB(), false);
        widgets.addText((Component)TextUtils.__("gui.nuclearcraft.jei.particle.spin", this.recipe.getSpin()), 0, yOffset += lineHeight, Color.DARK_GRAY.getRGB(), false);
        yOffset += lineHeight;
        String description = TextUtils.__("nuclearcraft.particle." + this.recipe.output.getParticle().getName() + ".desc", new Object[0]).getString();
        List<String> wrappedLines = this.wrapText(description, 22);
        for (String line : wrappedLines) {
            widgets.addText((Component)Component.m_237113_((String)line), 0, yOffset, Color.DARK_GRAY.getRGB(), false);
            yOffset += lineHeight;
        }
    }

    private List<String> wrapText(String text, int maxCharsPerLine) {
        ArrayList<String> lines = new ArrayList<String>();
        if (text == null || text.isEmpty()) {
            return lines;
        }
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > maxCharsPerLine) {
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                    currentLine = new StringBuilder();
                }
                if (word.length() > maxCharsPerLine) {
                    while (word.length() > maxCharsPerLine) {
                        lines.add(word.substring(0, maxCharsPerLine));
                        word = word.substring(maxCharsPerLine);
                    }
                    if (word.isEmpty()) continue;
                    currentLine.append(word);
                    continue;
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static Component getTitle() {
        return Component.m_237115_((String)"jei.category.nuclearcraft.particle_info");
    }
}

