/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.emi.ingredient;

import dev.emi.emi.api.stack.EmiStack;
import igentuman.nc.NuclearCraft;
import igentuman.nc.compat.emi.ingredient.ParticleEmiStackRenderer;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.Units;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ParticleEmiStack
extends EmiStack {
    private final ParticleStack particleStack;

    public ParticleEmiStack(ParticleStack particleStack) {
        this.particleStack = particleStack.copy();
        this.amount = particleStack.getAmount();
    }

    public ParticleEmiStack(ParticleStack particleStack, long amount) {
        this.particleStack = particleStack.copy();
        this.particleStack.setAmount((int)amount);
        this.amount = amount;
    }

    public ParticleStack getParticleStack() {
        return this.particleStack;
    }

    public EmiStack copy() {
        return new ParticleEmiStack(this.particleStack, this.amount);
    }

    public boolean isEmpty() {
        return this.particleStack == null || this.particleStack.getParticle() == null || this.particleStack.getAmount() <= 0;
    }

    public Object getKey() {
        return this.particleStack.getParticle();
    }

    public ResourceLocation getId() {
        if (this.particleStack.getParticle() != null) {
            return NuclearCraft.rl("particle/" + this.particleStack.getParticle().getName());
        }
        return NuclearCraft.rl("empty");
    }

    public CompoundTag getNbt() {
        return null;
    }

    public void render(GuiGraphics graphics, int x, int y, float delta, int flags) {
        ParticleEmiStackRenderer.render(this, graphics, x, y, delta, flags);
    }

    public List<Component> getTooltipText() {
        if (this.isEmpty()) {
            return List.of();
        }
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)TextUtils.__(this.particleStack.getParticle().getUnlocalizedName(), new Object[0]));
        tooltip.add((Component)Component.m_237113_((String)("nuclearcraft:particle/" + this.particleStack.getParticle().getName())).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)TextUtils.__("tooltip.nuclearcraft.particlestack.amount", Units.getSIFormat(this.particleStack.getAmount(), "pu")).m_130940_(ChatFormatting.GRAY));
        if (this.particleStack.getMeanEnergy() > 0L) {
            tooltip.add((Component)TextUtils.__("tooltip.nuclearcraft.particlestack.mean_energy", Units.getParticleEnergy(this.particleStack.getMeanEnergy())).m_130940_(ChatFormatting.GRAY));
        }
        if (this.particleStack.getFocus() > 0.0) {
            tooltip.add((Component)TextUtils.__("tooltip.nuclearcraft.particlestack.focus", Units.getSIFormat(this.particleStack.getFocus(), "")).m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>();
        tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextUtils.__(this.particleStack.getParticle().getUnlocalizedName(), new Object[0]).m_7532_()));
        tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)Component.m_237113_((String)("nuclearcraft:particle/" + this.particleStack.getParticle().getName())).m_130940_(ChatFormatting.DARK_GRAY).m_7532_()));
        tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextUtils.__("tooltip.nuclearcraft.particlestack.amount", Units.getSIFormat(this.particleStack.getAmount(), "pu")).m_130940_(ChatFormatting.GRAY).m_7532_()));
        if (this.particleStack.getMeanEnergy() > 0L) {
            tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextUtils.__("tooltip.nuclearcraft.particlestack.mean_energy", Units.getParticleEnergy(this.particleStack.getMeanEnergy())).m_130940_(ChatFormatting.GRAY).m_7532_()));
        }
        if (this.particleStack.getFocus() > 0.0) {
            tooltip.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)TextUtils.__("tooltip.nuclearcraft.particlestack.focus", Units.getSIFormat(this.particleStack.getFocus(), "")).m_130940_(ChatFormatting.GRAY).m_7532_()));
        }
        return tooltip;
    }

    public Component getName() {
        if (this.isEmpty()) {
            return Component.m_237113_((String)"Empty");
        }
        return TextUtils.__(this.particleStack.getParticle().getUnlocalizedName(), new Object[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParticleEmiStack)) {
            return false;
        }
        ParticleEmiStack other = (ParticleEmiStack)((Object)obj);
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return this.particleStack.getParticle().equals(other.particleStack.getParticle()) && this.particleStack.getAmount() == other.particleStack.getAmount() && this.particleStack.getMeanEnergy() == other.particleStack.getMeanEnergy() && Double.compare(this.particleStack.getFocus(), other.particleStack.getFocus()) == 0;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.particleStack.getParticle().hashCode();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty ParticleStack";
        }
        return this.particleStack.getParticle().getName();
    }

    public static ParticleEmiStack of(ParticleStack particleStack) {
        return new ParticleEmiStack(particleStack);
    }

    public static ParticleEmiStack of(ParticleStack particleStack, long amount) {
        return new ParticleEmiStack(particleStack, amount);
    }
}

