/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.gregtech;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.gregtech.GTEnergyContainer;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.capability.CustomEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;

public class GTUtils {
    public static boolean isOnlyGTCEUCapEnabled() {
        return CommonConfig.GTCEU_CONFIG.COMPATIBILITY.get() == CommonConfig.GTCEUCompatibilityConfig.GTCEUCompatibility.ONLY_GTCEU;
    }

    public static String formatEUTier(int capacity) {
        long tier = GTUtils.tierByFe(capacity);
        return CommonConfig.GTCEUCompatibilityConfig.GTCEUTier.values()[(int)tier].name();
    }

    public static String formatEUEnergy(int energy) {
        if ((energy /= GTUtils.FE2EURatio()) >= 1000000) {
            return TextUtils.numberFormat((double)energy / 1000000.0) + " MEU";
        }
        if (energy >= 1000) {
            return TextUtils.numberFormat((double)energy / 1000.0) + " kEU";
        }
        return TextUtils.numberFormat(energy) + " EU";
    }

    public static long tierByFe(int fe) {
        long tier = 3L;
        return tier;
    }

    public static LazyOptional<IEnergyContainer> getGTEnergy(NuclearCraftBE energyHolder, @Nullable Direction side) {
        return GTEnergyContainer.wrapped(energyHolder.energyStorage(), side, energyHolder).cast();
    }

    public static int convert2FE(long eu) {
        long converted = eu * (long)GTUtils.FE2EURatio();
        if (converted > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (converted < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)converted;
    }

    public static int convert2EU(int fe) {
        return fe / GTUtils.FE2EURatio();
    }

    public static int FE2EURatio() {
        return FeCompat.ratio((boolean)true);
    }

    public static int EU2FERatio() {
        return FeCompat.ratio((boolean)false);
    }

    public static void transferEU(NuclearCraftBE nuclearCraftBE, BlockEntity be, CustomEnergyStorage energyStorage, Direction direction) {
        IEnergyContainer gtEnergyContainer;
        int amps = (int)((long)energyStorage.getEnergyStored() / (energyStorage.getGTOuputVoltage() * (long)GTUtils.EU2FERatio()));
        if ((amps = (int)Math.min((long)amps, energyStorage.getGTOutputAmperage())) < 1) {
            return;
        }
        if (be.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, direction.m_122424_()).isPresent() && (gtEnergyContainer = (IEnergyContainer)be.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, direction.m_122424_()).orElse(null)) != null) {
            long outAmps = gtEnergyContainer.acceptEnergyFromNetwork(direction.m_122424_(), energyStorage.getGTOuputVoltage(), (long)amps);
            long received = outAmps * energyStorage.getGTOuputVoltage();
            energyStorage.consumeEnergy((int)received * GTUtils.EU2FERatio());
            nuclearCraftBE.m_6596_();
        }
    }

    public static int getMaxOutputFE(CommonConfig.GTCEUCompatibilityConfig.GTCEUTier gtceuTier) {
        long voltage = CustomEnergyStorage.V[gtceuTier.ordinal()];
        long amperage = 16L;
        return GTUtils.convert2FE(voltage * amperage);
    }
}

