/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.accelerator.entity.LinearAcceleratorControllerBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.client.NcClient;
import igentuman.nc.client.gui.fission.FissionControllerScreen;
import igentuman.nc.client.gui.processor.NCProcessorScreen;
import igentuman.nc.compat.GlobalVars;
import igentuman.nc.compat.jei.AcceleratorCoolantCategoryWrapper;
import igentuman.nc.compat.jei.FissionBoilingCategoryWrapper;
import igentuman.nc.compat.jei.FissionCategoryWrapper;
import igentuman.nc.compat.jei.FusionCategoryWrapper;
import igentuman.nc.compat.jei.FusionCoolantCategoryWrapper;
import igentuman.nc.compat.jei.KugelblitzCategoryWrapper;
import igentuman.nc.compat.jei.MekChemicalConversionCategoryWrapper;
import igentuman.nc.compat.jei.MultiblockStructureCategory;
import igentuman.nc.compat.jei.MultiblockStructureRecipe;
import igentuman.nc.compat.jei.OreVeinCategoryWrapper;
import igentuman.nc.compat.jei.ParticleInfoCategory;
import igentuman.nc.compat.jei.ParticleRecipe;
import igentuman.nc.compat.jei.ParticleSourceCategory;
import igentuman.nc.compat.jei.ParticleSourceRecipe;
import igentuman.nc.compat.jei.ProcessorCategoryWrapper;
import igentuman.nc.compat.jei.ProcessorRecipeTransferHandler;
import igentuman.nc.compat.jei.TargetChamberCategoryWrapper;
import igentuman.nc.compat.jei.TurbineControllerCategoryWrapper;
import igentuman.nc.compat.jei.ingredient.ParticleStackHelper;
import igentuman.nc.compat.jei.ingredient.ParticleStackListFactory;
import igentuman.nc.compat.jei.ingredient.ParticleStackRenderer;
import igentuman.nc.compat.jei.ingredient.ParticleType;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleSources;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.handler.config.ClientConfig;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.kugelblitz.KugelblitzRegistration;
import igentuman.nc.recipes.AbstractRecipe;
import igentuman.nc.recipes.NcRecipeType;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.type.MekChemicalConversionRecipe;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.recipes.type.OreVeinRecipe;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static HashMap<String, RecipeType<? extends NcRecipe>> recipeTypes;
    public static final RecipeType<TargetChamberControllerBE.Recipe> TARGET_CHAMBER;
    public static final RecipeType<ChamberTerminalBE.Recipe> KUGELBLITZ;
    public static final RecipeType<FissionControllerBE.Recipe> FISSION;
    public static final RecipeType<FusionCoreBE.Recipe> FUSION;
    public static final RecipeType<FusionCoreBE.FusionCoolantRecipe> FUSION_COOLANT;
    public static final RecipeType<LinearAcceleratorControllerBE.CoolantRecipe> ACCELERATOR_COOLANT;
    public static final RecipeType<FissionControllerBE.FissionBoilingRecipe> FISSION_BOILING;
    public static final RecipeType<TurbineControllerBE.Recipe> TURBINE_CONTROLLER;
    public static final RecipeType<MekChemicalConversionRecipe> CHEMICAL_TO_FLUID;
    public static final RecipeType<OreVeinRecipe> ORE_VEINS;

    private static HashMap<String, RecipeType<? extends NcRecipe>> getRecipeTypes() {
        if (recipeTypes == null) {
            recipeTypes = new HashMap();
            for (String name : GlobalVars.RECIPE_CLASSES.keySet()) {
                if (Processors.all().containsKey(name) && !Processors.all().get(name).isRegistered()) continue;
                recipeTypes.put(name, (RecipeType<? extends NcRecipe>)new RecipeType(NuclearCraft.rl(name), GlobalVars.RECIPE_CLASSES.get(name)));
            }
        }
        return recipeTypes;
    }

    public ResourceLocation getPluginUid() {
        return NuclearCraft.rl("jei_plugin");
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        List<ParticleStack> particleStacks = ParticleStackListFactory.create();
        ParticleStackHelper particleStackHelper = new ParticleStackHelper();
        ParticleStackRenderer particleStackRenderer = new ParticleStackRenderer();
        registration.register(ParticleType.Particle, particleStacks, (IIngredientHelper)particleStackHelper, (IIngredientRenderer)particleStackRenderer);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager recipeManager = jeiRuntime.getRecipeManager();
        for (String name : Processors.all().keySet()) {
            ResourceLocation categoryToHide;
            if (Processors.registered().containsKey(name) || !recipeManager.getRecipeType(categoryToHide = NuclearCraft.rl(name)).isPresent()) continue;
            recipeManager.hideRecipeCategory((RecipeType)recipeManager.getRecipeType(categoryToHide).get());
        }
        if (((Boolean)ClientConfig.MISC_CONFIG.HIDE_PARTICLES.get()).booleanValue()) {
            List<ParticleStack> particleStacks = ParticleStackListFactory.create();
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(ParticleType.Particle, particleStacks);
        }
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!Processors.all().containsKey(name)) continue;
            registration.addRecipeCategories(new IRecipeCategory[]{new ProcessorCategoryWrapper(registration.getJeiHelpers().getGuiHelper(), this.getRecipeType(name))});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new OreVeinCategoryWrapper<OreVeinRecipe>(registration.getJeiHelpers().getGuiHelper(), ORE_VEINS)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionCategoryWrapper<FusionCoreBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), FUSION)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FusionCoolantCategoryWrapper<FusionCoreBE.FusionCoolantRecipe>(registration.getJeiHelpers().getGuiHelper(), FUSION_COOLANT)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AcceleratorCoolantCategoryWrapper<LinearAcceleratorControllerBE.CoolantRecipe>(registration.getJeiHelpers().getGuiHelper(), ACCELERATOR_COOLANT)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionBoilingCategoryWrapper<FissionControllerBE.FissionBoilingRecipe>(registration.getJeiHelpers().getGuiHelper(), FISSION_BOILING)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TurbineControllerCategoryWrapper<TurbineControllerBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), TURBINE_CONTROLLER)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FissionCategoryWrapper<FissionControllerBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), FISSION)});
        registration.addRecipeCategories(new IRecipeCategory[]{new KugelblitzCategoryWrapper<ChamberTerminalBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), KUGELBLITZ)});
        registration.addRecipeCategories(new IRecipeCategory[]{new TargetChamberCategoryWrapper<TargetChamberControllerBE.Recipe>(registration.getJeiHelpers().getGuiHelper(), TARGET_CHAMBER)});
        if (ModUtil.isMekanismLoaded()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new MekChemicalConversionCategoryWrapper<MekChemicalConversionRecipe>(registration.getJeiHelpers().getGuiHelper(), CHEMICAL_TO_FLUID)});
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new MultiblockStructureCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleInfoCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ParticleSourceCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public <TYPE> RecipeType<TYPE> getRecipeType(String name) {
        return recipeTypes.get(name);
    }

    public <TYPE> RecipeType<TYPE> getRecipeType(RecipeType<? extends AbstractRecipe> in) {
        return in;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        try {
            for (String name : JEIPlugin.getRecipeTypes().keySet()) {
                if (List.of("fusion_core", "fusion_coolant", "fission_reactor_controller", "fission_boiling", "target_chamber", "nc_ore_veins", "turbine_controller", "kugelblitz_chamber").contains(name)) continue;
                registration.addRecipes(this.getRecipeType(name), NcRecipeType.ALL_RECIPES.get(name).getRecipes(NcClient.tryGetClientWorld()));
            }
            registration.addRecipes(this.getRecipeType(TARGET_CHAMBER), NcRecipeType.ALL_RECIPES.get("target_chamber").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(KUGELBLITZ), NcRecipeType.ALL_RECIPES.get("kugelblitz_chamber").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FUSION), NcRecipeType.ALL_RECIPES.get("fusion_core").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FUSION_COOLANT), NcRecipeType.ALL_RECIPES.get("fusion_coolant").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(ACCELERATOR_COOLANT), NcRecipeType.ALL_RECIPES.get("accelerator_coolant").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FISSION), NcRecipeType.ALL_RECIPES.get("fission_reactor_controller").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(FISSION_BOILING), NcRecipeType.ALL_RECIPES.get("fission_boiling").getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(TURBINE_CONTROLLER), NcRecipeType.ALL_RECIPES.get(TurbineControllerBE.NAME).getRecipes(NcClient.tryGetClientWorld()));
            registration.addRecipes(this.getRecipeType(ORE_VEINS), NcRecipeType.ALL_RECIPES.get("nc_ore_veins").getRecipes(NcClient.tryGetClientWorld()));
            if (ModUtil.isMekanismLoaded()) {
                registration.addRecipes(this.getRecipeType(CHEMICAL_TO_FLUID), MekChemicalConversionRecipe.getRecipes());
            }
            List<MultiblockStructureRecipe> multiblockRecipes = this.loadMultiblockStructures();
            registration.addRecipes(MultiblockStructureCategory.TYPE, multiblockRecipes);
            registration.addRecipes(ParticleInfoCategory.TYPE, this.particleRecipes());
            registration.addRecipes(ParticleSourceCategory.TYPE, this.particleSourceRecipes());
            registration.addIngredientInfo(List.of(new ItemStack((ItemLike)KugelblitzRegistration.KUGELBLITZ_BLOCKS.get("chamber_terminal").get()), new ItemStack((ItemLike)NCItems.UNKNOWN_INGREDIENT.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.__("jei.info.nuclearcraft.kugelblitz.description", new Object[0]), Component.m_237113_((String)""), TextUtils.__("jei.info.nuclearcraft.kugelblitz.problem", new Object[0]), Component.m_237113_((String)""), TextUtils.__("jei.info.nuclearcraft.kugelblitz.input_output", new Object[0])});
        }
        catch (IllegalArgumentException ex) {
            NuclearCraft.LOGGER.error("Error registering recipes for JEI: " + ex.getMessage());
        }
    }

    private List<ParticleSourceRecipe> particleSourceRecipes() {
        ArrayList<ParticleSourceRecipe> recipes = new ArrayList<ParticleSourceRecipe>();
        for (String item : ParticleSources.sources.keySet()) {
            if (ParticleSources.sources.get(item).getParticle() == null) continue;
            recipes.add(new ParticleSourceRecipe(NuclearCraft.rl(item), new ItemStack((ItemLike)NCItems.ION_SOURCES.get(item).get()), null, ParticleSources.sources.get(item).getParticle()));
        }
        for (String fluid : ParticleSources.fluidSources.keySet()) {
            recipes.add(new ParticleSourceRecipe(NuclearCraft.rl(fluid), null, (FluidStack)IngredientCreatorAccess.fluid().from(fluid, 1).getRepresentations().get(0), ParticleSources.fluidSources.get(fluid).getParticle()));
        }
        return recipes;
    }

    private List<ParticleRecipe> particleRecipes() {
        ArrayList<ParticleRecipe> recipes = new ArrayList<ParticleRecipe>();
        for (Particle particle : Particles.particles.values()) {
            recipes.add(new ParticleRecipe(NuclearCraft.rl(particle.getName()), particle));
        }
        return recipes;
    }

    private List<MultiblockStructureRecipe> loadMultiblockStructures() {
        ArrayList<MultiblockStructureRecipe> recipes = new ArrayList<MultiblockStructureRecipe>();
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        List<String> structures = List.of("fission_reactor.nbt", "fusion_reactor.nbt", "kugelblitz_chamber.nbt", "linear_accelerator.nbt", "target_chamber.nbt", "leacher.nbt", "turbine.nbt");
        for (String file : structures) {
            Optional structure = resourceManager.m_213713_(NuclearCraft.rl("structures/" + file));
            CompoundTag nbt = null;
            try {
                nbt = NbtIo.m_128939_((InputStream)((Resource)structure.get()).m_215507_());
            }
            catch (IOException e) {
                continue;
            }
            recipes.add(new MultiblockStructureRecipe(NuclearCraft.rl(file), nbt, file));
        }
        return recipes;
    }

    private <T extends AbstractContainerScreen<?>> void addRecipeClickArea(IGuiHandlerRegistration registration, Class<? extends T> containerScreenClass, final int xPos, final int yPos, final int width, final int height, RecipeType<?> ... recipeTypes) {
        if (recipeTypes == null) {
            return;
        }
        registration.addGuiContainerHandler(containerScreenClass, new IGuiContainerHandler<T>(){

            @NotNull
            public Collection<IGuiClickableArea> getGuiClickableAreas(@NotNull T containerScreen, double mouseX, double mouseY) {
                NCProcessorScreen screen = (NCProcessorScreen)containerScreen;
                String name = screen.getRecipeTypeName();
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)xPos, (int)yPos, (int)width, (int)height, (RecipeType[])new RecipeType[]{JEIPlugin.getRecipeTypes().get(name)});
                return List.of(clickableArea);
            }
        });
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!Processors.registered().containsKey(name)) continue;
            this.addRecipeClickArea(registration, NCProcessorScreen.class, 67, 74, 18, 18, this.getRecipeType(name));
        }
        registration.addRecipeClickArea(FissionControllerScreen.class, 72, 38, 36, 26, new RecipeType[]{FISSION});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!Processors.all().containsKey(name)) continue;
            registration.addRecipeTransferHandler(new ProcessorRecipeTransferHandler(this.getRecipeType(name)), this.getRecipeType(name));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (String name : JEIPlugin.getRecipeTypes().keySet()) {
            if (!GlobalVars.CATALYSTS.containsKey(name)) continue;
            for (ItemStack stack : GlobalVars.CATALYSTS.get(name)) {
                registry.addRecipeCatalyst(stack, new RecipeType[]{this.getRecipeType(name)});
            }
        }
        if (GlobalVars.CATALYSTS.containsKey("fission_reactor_controller")) {
            registry.addRecipeCatalyst(GlobalVars.CATALYSTS.get("fission_reactor_controller").get(0), new RecipeType[]{FISSION});
        }
        registry.addRecipeCatalyst((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("linear_accelerator_controller").get(), new RecipeType[]{ACCELERATOR_COOLANT});
        registry.addRecipeCatalyst((ItemLike)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("ring_accelerator_controller").get(), new RecipeType[]{ACCELERATOR_COOLANT});
        if (GlobalVars.CATALYSTS.containsKey("nc_ore_veins")) {
            registry.addRecipeCatalyst(GlobalVars.CATALYSTS.get("nc_ore_veins").get(0), new RecipeType[]{ORE_VEINS});
        }
    }

    static {
        TARGET_CHAMBER = new RecipeType(NuclearCraft.rl("target_chamber"), TargetChamberControllerBE.Recipe.class);
        KUGELBLITZ = new RecipeType(NuclearCraft.rl("kugelblitz_chamber"), ChamberTerminalBE.Recipe.class);
        FISSION = new RecipeType(NuclearCraft.rl("fission_reactor_controller"), FissionControllerBE.Recipe.class);
        FUSION = new RecipeType(NuclearCraft.rl("fusion_core"), FusionCoreBE.Recipe.class);
        FUSION_COOLANT = new RecipeType(NuclearCraft.rl("fusion_coolant"), FusionCoreBE.FusionCoolantRecipe.class);
        ACCELERATOR_COOLANT = new RecipeType(NuclearCraft.rl("accelerator_coolant"), LinearAcceleratorControllerBE.CoolantRecipe.class);
        FISSION_BOILING = new RecipeType(NuclearCraft.rl("fission_boiling"), FissionControllerBE.FissionBoilingRecipe.class);
        TURBINE_CONTROLLER = new RecipeType(NuclearCraft.rl(TurbineControllerBE.NAME), TurbineControllerBE.Recipe.class);
        CHEMICAL_TO_FLUID = new RecipeType(NuclearCraft.rl("mek_chemical_to_fluid"), MekChemicalConversionRecipe.class);
        ORE_VEINS = new RecipeType(NuclearCraft.rl("nc_ore_veins"), OreVeinRecipe.class);
    }
}

