/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.jei;

import igentuman.nc.compat.jei.MultiblockStructure;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class MultiblockStructureRecipe {
    private final ResourceLocation id;
    private final CompoundTag structureNbt;
    private final String name;
    private final MultiblockStructure structure;
    public int currentLayer = 0;
    public List<ItemStack> outputs = new ArrayList<ItemStack>();

    public MultiblockStructureRecipe(ResourceLocation id, CompoundTag structureNbt, String name) {
        this.id = id;
        this.structureNbt = structureNbt;
        this.name = "jei.recipe.nc." + name.replace(".nbt", "");
        this.structure = new MultiblockStructure(structureNbt);
        this.currentLayer = this.structure.getMaxY();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (BlockPos pos : this.structure.getBlocks().keySet()) {
            Block block = this.structure.getBlocks().get(pos).m_60734_();
            if (blocks.contains(block)) continue;
            blocks.add(block);
            this.outputs.add(new ItemStack((ItemLike)block));
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public CompoundTag getStructureNbt() {
        return this.structureNbt;
    }

    public String getName() {
        return this.name;
    }

    public MultiblockStructure getStructure() {
        return this.structure;
    }

    public void slice() {
        --this.currentLayer;
        if (this.currentLayer < this.structure.getMinY()) {
            this.currentLayer = this.structure.getMaxY();
        }
    }

    public Ingredient getIngredients() {
        Ingredient ingredient = Ingredient.m_43927_((ItemStack[])this.outputs.toArray(new ItemStack[0]));
        return ingredient;
    }
}

