/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.core.IngredientSupplierKJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.InputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.util.RemapForJS;
import igentuman.nc.compat.kubejs.OutputParticle;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.Particles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class InputParticle
implements IngredientSupplierKJS,
InputReplacement,
JsonSerializable {
    public static final InputParticle EMPTY = new InputParticle(Ingredient.f_43901_, 0);
    public static final Map<String, InputParticle> PARSE_CACHE = new HashMap<String, InputParticle>();
    public final Ingredient ingredient;
    public final int count;

    public static InputParticle of(Ingredient ingredient, int count) {
        return count <= 0 || ingredient == Ingredient.f_43901_ ? EMPTY : new InputParticle(ingredient, count);
    }

    private static Ingredient createIngredientFromParticle(ParticleStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42127_});
    }

    public static InputParticle of(Object o) {
        if (o instanceof InputParticle) {
            InputParticle in = (InputParticle)o;
            return in;
        }
        if (o instanceof ParticleStack) {
            ParticleStack stack = (ParticleStack)o;
            return stack.isEmpty() ? EMPTY : InputParticle.of(InputParticle.createIngredientFromParticle(stack), stack.getAmount());
        }
        if (o instanceof OutputParticle) {
            OutputParticle out = (OutputParticle)o;
            return out.isEmpty() ? EMPTY : InputParticle.of(InputParticle.createIngredientFromParticle(out.item), out.getCount());
        }
        if (o instanceof CharSequence) {
            String str = o.toString();
            if (str.isEmpty() || str.equals("air")) {
                return EMPTY;
            }
            InputParticle cached = PARSE_CACHE.get(str);
            if (cached != null) {
                return cached;
            }
            int x = str.indexOf(120);
            if (x > 0 && x < str.length() - 2 && str.charAt(x + 1) == ' ') {
                try {
                    Ingredient ingredient = IngredientJS.of((Object)str.substring(x + 2));
                    if (ingredient == Ingredient.f_43901_) {
                        return EMPTY;
                    }
                    int count = Integer.parseInt(str.substring(0, x));
                    cached = InputParticle.of(IngredientJS.of((Object)str.substring(x + 2)), count);
                }
                catch (Exception ignore) {
                    throw new RecipeExceptionJS("Invalid particle input: " + str);
                }
            }
            if (cached == null) {
                cached = InputParticle.of(IngredientJS.of((Object)str), 1);
            }
            PARSE_CACHE.put(str, cached);
            return cached;
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return InputParticle.ofJson(json);
        }
        if (o instanceof JsonObject) {
            JsonObject json = (JsonObject)o;
            return InputParticle.ofJson((JsonElement)json);
        }
        return InputParticle.of(IngredientJS.of((Object)o), 1);
    }

    static InputParticle ofJson(JsonElement json) {
        if (json == null || json.isJsonNull() || json.isJsonArray() && json.getAsJsonArray().isEmpty()) {
            return EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return InputParticle.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            int count;
            JsonObject o = json.getAsJsonObject();
            boolean val = o.has("value");
            int n = o.has("amount") ? o.get("amount").getAsInt() : (count = o.has("count") ? o.get("count").getAsInt() : 1);
            if (o.has("particle")) {
                Particle particle = Particles.getParticleFromName(o.get("particle").getAsString());
                if (particle != null) {
                    long energy = o.has("meanEnergy") ? o.get("meanEnergy").getAsLong() : 0L;
                    double focus = o.has("focus") ? o.get("focus").getAsDouble() : 0.0;
                    ParticleStack particleStack = new ParticleStack(particle, count, energy, focus);
                    return InputParticle.of(InputParticle.createIngredientFromParticle(particleStack), count);
                }
            } else {
                if (o.has("type")) {
                    try {
                        return InputParticle.of(RecipePlatformHelper.get().getCustomIngredient(o), count);
                    }
                    catch (Exception ex) {
                        throw new RecipeExceptionJS("Failed to parse custom ingredient (" + o.get("type") + ") from " + o + ": " + ex);
                    }
                }
                if (val || o.has("ingredient")) {
                    return InputParticle.of(IngredientJS.ofJson((JsonElement)(val ? o.get("value") : o.get("ingredient"))), count);
                }
                if (o.has("tag")) {
                    return InputParticle.of(IngredientPlatformHelper.get().tag(o.get("tag").getAsString()), count);
                }
                if (o.has("item")) {
                    return InputParticle.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ItemStackJS.of((Object)o.get("item").getAsString())}), count);
                }
            }
            return EMPTY;
        }
        return InputParticle.of(Ingredient.m_43917_((JsonElement)json), 1);
    }

    protected InputParticle(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    public Ingredient kjs$asIngredient() {
        return this.ingredient;
    }

    public InputParticle withCount(int count) {
        return count == this.count ? this : new InputParticle(this.ingredient, count);
    }

    public boolean isEmpty() {
        return this == EMPTY || this.ingredient.m_43947_() || this.count <= 0;
    }

    public boolean validForMatching() {
        return !this.isEmpty() && !this.ingredient.m_43947_();
    }

    public List<InputParticle> unwrap() {
        if (this.count > 1) {
            ArrayList<InputParticle> list = new ArrayList<InputParticle>(this.count);
            InputParticle single = this.withCount(1);
            for (int i = 0; i < this.count; ++i) {
                list.add(single);
            }
            return list;
        }
        return List.of(this);
    }

    public String toString() {
        if (this.count > 1) {
            return this.count + "x " + this.ingredient;
        }
        return this.ingredient.toString();
    }

    public JsonElement toJsonJS() {
        return this.toJsonJS(true);
    }

    @RemapForJS(value="toJson")
    public JsonElement toJsonJS(boolean alwaysNest) {
        if (!alwaysNest && this.count == 1) {
            return this.ingredient.m_43942_();
        }
        JsonObject o = new JsonObject();
        o.addProperty("count", (Number)this.count);
        o.add("ingredient", this.ingredient.m_43942_());
        return o;
    }

    public Object replaceInput(RecipeJS recipe, ReplacementMatch match, InputReplacement original) {
        if (original instanceof InputParticle) {
            InputParticle o = (InputParticle)original;
            return this.withCount(o.count);
        }
        return this;
    }
}

