/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.compat.oc2;

import dan200.computercraft.api.lua.LuaException;
import igentuman.nc.block.kugelblitz.entity.ChamberTerminalBE;
import java.util.Collection;
import java.util.Collections;
import li.cil.oc2.api.bus.device.Device;
import li.cil.oc2.api.bus.device.object.Callback;
import li.cil.oc2.api.bus.device.object.NamedDevice;
import li.cil.oc2.api.bus.device.object.ObjectDevice;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.NotNull;

public class KugelblitzDevice {
    public static final Capability<Device> DEVICE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<Device>(){});

    public static RPCDevice createDevice(ChamberTerminalBE blockEntity) {
        return new ObjectDevice((Object)new NCFChamberTerminalRecord(blockEntity));
    }

    public record NCFChamberTerminalRecord(ChamberTerminalBE terminal) implements NamedDevice
    {
        @Callback
        public final boolean isFormed() {
            return this.terminal.isCasingValid && this.terminal.isInternalValid;
        }

        @Callback
        public final String getName() {
            return "nc_kugelblitz";
        }

        @Callback
        public final boolean hasRecipe() {
            return this.terminal.hasRecipe();
        }

        @Callback
        public final int getEnergyPerTick() {
            return this.terminal.energyPerTick;
        }

        @Callback
        public final int getEnergyStored() {
            return this.terminal.energyStorage().getEnergyStored();
        }

        @Callback
        public final int getRecipeProgress() {
            return (int)(this.terminal.recipeInfo().getProgress() * 100.0);
        }

        @Callback
        public final int getEvaporationRate() {
            return this.terminal.evaporation;
        }

        @Callback
        public final int getFeedingRate() {
            return (int)this.terminal.feeding;
        }

        @Callback
        public final int getBlackholeMass() {
            return (int)(this.terminal.mass / 1000L);
        }

        @Callback
        public final int getBlackholeStability() {
            return this.terminal.blackholeStability;
        }

        @Callback
        public final int getQuantumFrequency() {
            return this.terminal.frequency;
        }

        @Callback
        public final int setQuantumFrequency(int frequency) throws LuaException {
            if (frequency < 0 || frequency > 15) {
                throw new LuaException("Frequency must be between 0 and 15");
            }
            this.terminal.frequency = (byte)frequency;
            this.terminal.m_6596_();
            return this.terminal.frequency;
        }

        @Callback
        public final int getFluxRegulators() {
            return this.terminal.fluxRegulators;
        }

        @Callback
        public final int getTransformers() {
            return this.terminal.transformers;
        }

        @Callback
        public final int getStabilizers() {
            return this.terminal.stabilizers;
        }

        @Callback
        public final int getTransformationEnergyRate() {
            return this.terminal.energyConvertionRate;
        }

        @Callback
        public final int setTransformationEnergyRate(int rate) throws LuaException {
            if (rate < 0 || rate > 100) {
                throw new LuaException("Rate must be between 0 and 100");
            }
            this.terminal.energyConvertionRate = rate;
            this.terminal.m_6596_();
            return this.terminal.energyConvertionRate;
        }

        @NotNull
        public Collection<String> getDeviceTypeNames() {
            return Collections.singletonList(this.getName());
        }
    }
}

