/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.content.particles.creator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.content.particles.IParticleIngredient;
import igentuman.nc.content.particles.Particle;
import igentuman.nc.content.particles.ParticleIngredient;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.content.particles.creator.IParticleIngredientCreator;
import igentuman.nc.network.BasePacketHandler;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ParticleIngredientCreator
implements IParticleIngredientCreator {
    public static final ParticleIngredientCreator INSTANCE = new ParticleIngredientCreator();

    private ParticleIngredientCreator() {
    }

    @Override
    public ParticleIngredient from(Particle particle, int amount, long meanEnergy, double focus) {
        Objects.requireNonNull(particle, "ParticleIngredients cannot be created from a null particle.");
        if (amount <= 0) {
            throw new IllegalArgumentException("ParticleIngredients must have an amount of at least one. Received size was: " + amount);
        }
        return new SingleParticleIngredient(particle, amount, meanEnergy, focus);
    }

    @Override
    public ParticleIngredient from(JsonElement instance) {
        return this.deserialize(instance);
    }

    @Override
    public ParticleIngredient read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "ParticleIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.m_130066_(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> {
                String particleName = buffer.m_130277_();
                int amount = buffer.m_130242_();
                long meanEnergy = buffer.readLong();
                double focus = buffer.readDouble();
                Particle particle = this.getParticleFromName(particleName);
                yield this.from(particle, amount, meanEnergy, focus);
            }
            case IngredientType.MULTI -> this.createMulti(BasePacketHandler.readArray(buffer, ParticleIngredient[]::new, this::read));
        };
    }

    private Particle getParticleFromName(String name) {
        return null;
    }

    @Override
    public ParticleIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null.");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined.");
            }
            if (size > 1) {
                ParticleIngredient[] ingredients = new ParticleIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = this.deserialize(jsonArray.get(i));
                }
                return this.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected particle to be object or array of objects.");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (!jsonObject.has("particle")) {
            throw new JsonSyntaxException("Particle ingredient requires a 'particle' field.");
        }
        String particleName = jsonObject.get("particle").getAsString();
        Particle particle = this.getParticleFromName(particleName);
        if (particle == null) {
            throw new JsonSyntaxException("Unknown particle: " + particleName);
        }
        int amount = 1;
        if (jsonObject.has("amount")) {
            JsonElement count = jsonObject.get("amount");
            if (!GsonHelper.m_13872_((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number that is one or larger.");
            }
            amount = count.getAsJsonPrimitive().getAsInt();
            if (amount < 1) {
                throw new JsonSyntaxException("Expected amount to larger than or equal to one.");
            }
        }
        long meanEnergy = 0L;
        if (jsonObject.has("meanEnergy")) {
            JsonElement energy = jsonObject.get("meanEnergy");
            if (!GsonHelper.m_13872_((JsonElement)energy)) {
                throw new JsonSyntaxException("Expected meanEnergy to be a number.");
            }
            meanEnergy = energy.getAsJsonPrimitive().getAsLong();
        }
        double focus = 0.0;
        if (jsonObject.has("focus")) {
            JsonElement focusElement = jsonObject.get("focus");
            if (!GsonHelper.m_13872_((JsonElement)focusElement)) {
                throw new JsonSyntaxException("Expected focus to be a number.");
            }
            focus = focusElement.getAsJsonPrimitive().getAsDouble();
        }
        return this.from(particle, amount, meanEnergy, focus);
    }

    public ParticleIngredient createMulti(ParticleIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<ParticleIngredient> cleanedIngredients = new ArrayList<ParticleIngredient>();
        for (ParticleIngredient ingredient : ingredients) {
            if (ingredient instanceof MultiParticleIngredient) {
                MultiParticleIngredient multi = (MultiParticleIngredient)ingredient;
                Collections.addAll(cleanedIngredients, multi.ingredients);
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new MultiParticleIngredient(cleanedIngredients.toArray(new ParticleIngredient[0]));
    }

    @Override
    public ParticleIngredient from(Stream<ParticleIngredient> ingredients) {
        return this.createMulti((ParticleIngredient[])ingredients.toArray(ParticleIngredient[]::new));
    }

    @Override
    public ParticleIngredient from(Particle particle, int amount) {
        return this.from(particle, amount, 0L, 0.0);
    }

    @NothingNullByDefault
    public static class SingleParticleIngredient
    extends ParticleIngredient {
        private final Particle particle;
        private final long meanEnergy;
        private final double focus;

        private SingleParticleIngredient(Particle particle, int amount, long meanEnergy, double focus) {
            this.particle = Objects.requireNonNull(particle);
            this.amount = amount;
            this.meanEnergy = meanEnergy;
            this.focus = focus;
        }

        @Override
        public boolean test(ParticleStack stack) {
            return this.testType(stack) && stack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(@NotNull ParticleStack stack) {
            if (stack.getParticle() != this.particle) {
                return false;
            }
            if (this.meanEnergy > 0L && stack.getMeanEnergy() < this.meanEnergy) {
                return false;
            }
            return !(this.focus > 0.0) || !(stack.getFocus() < this.focus);
        }

        @Override
        public ParticleStack getMatchingInstance(ParticleStack stack) {
            return this.test(stack) ? new ParticleStack(stack.getParticle(), this.amount, stack.getMeanEnergy(), stack.getFocus()) : new ParticleStack();
        }

        @Override
        public long getNeededAmount(ParticleStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return this.particle == null;
        }

        @Override
        public List<@NotNull ParticleStack> getRepresentations() {
            return List.of(new ParticleStack(this.particle, this.amount, this.meanEnergy, this.focus));
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.SINGLE);
            buffer.m_130070_(this.particle.getName());
            buffer.m_130130_(this.amount);
            buffer.writeLong(this.meanEnergy);
            buffer.writeDouble(this.focus);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("particle", this.particle.getName());
            if (this.amount > 1) {
                json.addProperty("amount", (Number)this.amount);
            }
            if (this.meanEnergy > 0L) {
                json.addProperty("meanEnergy", (Number)this.meanEnergy);
            }
            if (this.focus > 0.0) {
                json.addProperty("focus", (Number)this.focus);
            }
            return json;
        }

        @Override
        public String getName() {
            return this.particle.getName();
        }

        @Override
        public int getAmount() {
            return this.amount;
        }

        public Particle getParticle() {
            return this.particle;
        }

        public long getMeanEnergy() {
            return this.meanEnergy;
        }

        public double getFocus() {
            return this.focus;
        }
    }

    private static enum IngredientType {
        SINGLE,
        MULTI;

    }

    @NothingNullByDefault
    public static class MultiParticleIngredient
    extends ParticleIngredient {
        private final ParticleIngredient[] ingredients;

        private MultiParticleIngredient(ParticleIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(ParticleStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(@NotNull ParticleStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public ParticleStack getMatchingInstance(ParticleStack stack) {
            for (ParticleIngredient ingredient : this.ingredients) {
                ParticleStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.getParticle() == null) continue;
                return matchingInstance;
            }
            return new ParticleStack();
        }

        @Override
        public long getNeededAmount(ParticleStack stack) {
            for (ParticleIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return Arrays.stream(this.ingredients).allMatch(IParticleIngredient::hasNoMatchingInstances);
        }

        @Override
        public List<@NotNull ParticleStack> getRepresentations() {
            ArrayList<@NotNull ParticleStack> representations = new ArrayList<ParticleStack>();
            for (ParticleIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.MULTI);
            BasePacketHandler.writeArray(buffer, this.ingredients, IParticleIngredient::write);
        }

        @Override
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (ParticleIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        @Override
        public String getName() {
            return this.getRepresentations().get(0).getParticle().getName();
        }

        @Override
        public int getAmount() {
            return this.getRepresentations().get(0).getAmount();
        }

        public List<ParticleIngredient> getIngredients() {
            return List.of(this.ingredients);
        }

        public boolean forEachIngredient(Predicate<ParticleIngredient> checker) {
            boolean result = false;
            for (ParticleIngredient ingredient : this.ingredients) {
                result |= checker.test(ingredient);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.ingredients, ((MultiParticleIngredient)o).ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }
}

