/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.datagen.recipes.builder.RecipeBuilder;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class TConstructRecipeBuilder
extends RecipeBuilder<TConstructRecipeBuilder> {
    private List<NcIngredient> inputItems = List.of();
    private List<NcIngredient> outputItems = List.of();
    private List<FluidStackIngredient> inputFluids = List.of();
    private List<FluidStackIngredient> outputFluids = List.of();
    private static TConstructRecipeBuilder instance;
    public String ID;
    private int temperature = 0;
    private List<String> outputItemsText = List.of();
    private int coolingTime = 0;
    private boolean cast = false;
    private int time = 0;
    private boolean useInputForId = false;

    protected static ResourceLocation ncSerializer(String name) {
        return ResourceLocation.m_214293_((String)"tconstruct", (String)name);
    }

    protected TConstructRecipeBuilder(String id) {
        super(TConstructRecipeBuilder.ncSerializer(id));
        this.ID = id;
    }

    public static TConstructRecipeBuilder get(String id) {
        instance = new TConstructRecipeBuilder(id);
        return instance;
    }

    public TConstructRecipeBuilder items(List<NcIngredient> input, List<NcIngredient> output) {
        TConstructRecipeBuilder.instance.inputItems = input;
        TConstructRecipeBuilder.instance.outputItems = output;
        return instance;
    }

    public TConstructRecipeBuilder itemsString(List<NcIngredient> input, List<String> output) {
        TConstructRecipeBuilder.instance.inputItems = input;
        TConstructRecipeBuilder.instance.outputItemsText = output;
        return instance;
    }

    public TConstructRecipeBuilder fluids(List<FluidStackIngredient> input, List<FluidStackIngredient> output) {
        TConstructRecipeBuilder.instance.inputFluids = input;
        TConstructRecipeBuilder.instance.outputFluids = output;
        return instance;
    }

    @Override
    protected NcRecipeResult getResult(ResourceLocation id) {
        return new NcRecipeResult(id);
    }

    public ResourceLocation getRecipeId() {
        StringBuilder name = new StringBuilder();
        for (NcIngredient ncIngredient : this.inputItems) {
            name.append(ncIngredient.getName()).append("-");
        }
        for (FluidStackIngredient fluidStackIngredient : this.inputFluids) {
            name.append(fluidStackIngredient.getName()).append("-");
        }
        if (this.useInputForId) {
            for (FluidStackIngredient fluidStackIngredient : this.outputFluids) {
                name.append(fluidStackIngredient.getName()).append("-");
            }
        }
        name.replace(name.length() - 1, name.length(), "");
        return ResourceLocation.m_214293_((String)"tconstruct", (String)(this.ID + "/" + this.recipeIdReplacements(name.toString())));
    }

    protected String recipeIdReplacements(String val) {
        val = val.replace("nuclearcraft_", "");
        val = val.replace("depleted_fuel", "d_f");
        return val;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this.getRecipeId());
    }

    public TConstructRecipeBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public TConstructRecipeBuilder useInputForId(boolean b) {
        this.useInputForId = b;
        return this;
    }

    public TConstructRecipeBuilder coolingTime(int coolingTime) {
        this.coolingTime = coolingTime;
        return this;
    }

    public TConstructRecipeBuilder cast() {
        this.cast = true;
        return this;
    }

    public TConstructRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public class NcRecipeResult
    extends RecipeBuilder.RecipeResult {
        protected NcRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@NotNull JsonObject json) {
            Object out;
            Object in;
            Iterator<Object> iterator;
            JsonArray inputJson = new JsonArray();
            JsonObject value = new JsonObject();
            value.addProperty("type", "forge:mod_loaded");
            value.addProperty("modid", "tconstruct");
            JsonArray conditions = new JsonArray();
            conditions.add((JsonElement)value);
            json.add("conditions", (JsonElement)conditions);
            if (TConstructRecipeBuilder.this.cast) {
                JsonObject castTag = new JsonObject();
                castTag.addProperty("tag", "tconstruct:casts/multi_use/ingot");
                json.add("cast", (JsonElement)castTag);
            }
            if (!TConstructRecipeBuilder.this.inputItems.isEmpty() && (iterator = TConstructRecipeBuilder.this.inputItems.iterator()).hasNext()) {
                in = iterator.next();
                json.add("ingredient", RecipeBuilder.serializeIngredient((Ingredient)in));
            }
            if (!TConstructRecipeBuilder.this.outputItems.isEmpty() && (iterator = TConstructRecipeBuilder.this.outputItems.iterator()).hasNext()) {
                out = iterator.next();
                json.add("result", RecipeBuilder.serializeIngredient((Ingredient)out));
            }
            inputJson = new JsonArray();
            iterator = TConstructRecipeBuilder.this.inputFluids.iterator();
            while (iterator.hasNext()) {
                in = (FluidStackIngredient)iterator.next();
                if (!TConstructRecipeBuilder.this.cast) {
                    inputJson.add(in.serialize());
                    continue;
                }
                json.add("fluid", in.serialize());
                break;
            }
            if (!TConstructRecipeBuilder.this.inputFluids.isEmpty() && !TConstructRecipeBuilder.this.cast) {
                json.add("inputs", (JsonElement)inputJson);
            }
            if (!TConstructRecipeBuilder.this.outputFluids.isEmpty() && (iterator = TConstructRecipeBuilder.this.outputFluids.iterator()).hasNext()) {
                out = (FluidStackIngredient)iterator.next();
                json.add("result", out.serialize());
            }
            if (TConstructRecipeBuilder.this.coolingTime != 0) {
                json.addProperty("cooling_time", (Number)TConstructRecipeBuilder.this.coolingTime);
            }
            if (TConstructRecipeBuilder.this.temperature != 0) {
                json.addProperty("temperature", (Number)TConstructRecipeBuilder.this.temperature);
            }
            if (TConstructRecipeBuilder.this.time != 0) {
                json.addProperty("time", (Number)TConstructRecipeBuilder.this.time);
            }
        }
    }
}

