/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.recipes;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.content.materials.NCMaterial;
import igentuman.nc.datagen.recipes.recipes.AbstractRecipeProvider;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.FluidStack;

public class IngotFormerRecipes
extends AbstractRecipeProvider {
    public static void generate(Consumer<FinishedRecipe> consumer) {
        IngotFormerRecipes.consumer = consumer;
        ID = "ingot_former";
        for (String name : Materials.all().keySet()) {
            NCMaterial material = Materials.all().get(name);
            if (!material.fluid || material.isGas || !material.ingot) continue;
            IngotFormerRecipes.add(IngotFormerRecipes.ingotIngredient(name, new int[0]), IngotFormerRecipes.fluidIngredient("molten_" + name, 90), new double[0]);
        }
        for (String name : Materials.isotopes()) {
            for (String type : new String[]{"", "_ox", "_ni", "_za"}) {
                String key = name + type;
                if (!FissionFuel.NC_ISOTOPES.containsKey(key)) continue;
                IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)FissionFuel.NC_ISOTOPES.get(key).get(), new int[0]), IngotFormerRecipes.fluidIngredient(key, 90), new double[0]);
            }
        }
        for (String name : FuelManager.all().keySet()) {
            block4: for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : new String[]{"", "za", "ox", "ni"}) {
                    List<String> key = List.of("fuel", name, subType, type);
                    String keyStr = "fuel_" + name + "_" + subType;
                    if (!type.isEmpty()) {
                        keyStr = keyStr + "_";
                    }
                    keyStr = keyStr + type;
                    IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)FissionFuel.NC_FUEL.get(key).get(), new int[0]), IngotFormerRecipes.fluidStackIngredient(keyStr, 90), new double[0]);
                    if (name.matches("xenorium.*|quantite.*")) continue block4;
                }
            }
        }
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient(Items.f_151052_, new int[0]), IngotFormerRecipes.fluidIngredient("molten_copper", 90), new double[0]);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient(Items.f_42416_, new int[0]), IngotFormerRecipes.fluidIngredient("molten_iron", 90), new double[0]);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient(Items.f_42417_, new int[0]), IngotFormerRecipes.fluidIngredient("molten_gold", 90), new double[0]);
        IngotFormerRecipes.add(IngotFormerRecipes.gemStack("boron_arsenide", new int[0]), IngotFormerRecipes.fluidStack("boron_arsenide", 90), new double[0]);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient(Items.f_41999_, new int[0]), IngotFormerRecipes.fluidStack("obsidian", 180), 2.0, 2.0);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_ITEMS.get("ground_cocoa_nibs").get(), new int[0]), IngotFormerRecipes.fluidIngredient("chocolate_liquor", 90), 0.25, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_ITEMS.get("cocoa_butter").get(), new int[0]), IngotFormerRecipes.fluidIngredient("cocoa_butter", 90), 0.25, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_ITEMS.get("unsweetened_chocolate").get(), new int[0]), IngotFormerRecipes.fluidIngredient("unsweetened_chocolate", 90), 0.25, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_FOOD.get("dark_chocolate").get(), new int[0]), IngotFormerRecipes.fluidIngredient("dark_chocolate", 90), 0.25, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_FOOD.get("milk_chocolate").get(), new int[0]), IngotFormerRecipes.fluidIngredient("milk_chocolate", 90), 0.25, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_ITEMS.get("gelatin").get(), new int[0]), IngotFormerRecipes.fluidIngredient("gelatin", 90), 0.5, 0.5);
        IngotFormerRecipes.add(IngotFormerRecipes.ingredient((Item)NCItems.NC_FOOD.get("marshmallow").get(), new int[0]), IngotFormerRecipes.fluidIngredient("marshmallow", 90), 0.5, 0.5);
    }

    protected static void add(NcIngredient outputItem, FluidStack inputFluid, double ... modifiers) {
        IngotFormerRecipes.itemsAndFluids(new ArrayList<NcIngredient>(), List.of(outputItem), List.of((FluidStackIngredient)IngredientCreatorAccess.fluid().from(inputFluid)), new ArrayList<FluidStackIngredient>(), modifiers);
    }

    protected static void add(NcIngredient outputItem, FluidStackIngredient inputFluid, double ... modifiers) {
        IngotFormerRecipes.itemsAndFluids(new ArrayList<NcIngredient>(), List.of(outputItem), List.of(inputFluid), new ArrayList<FluidStackIngredient>(), modifiers);
    }
}

