/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.datagen.recipes.recipes;

import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.content.materials.Materials;
import igentuman.nc.datagen.recipes.recipes.AbstractRecipeProvider;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.NcIngredient;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.NCItems;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class TConstructMeltingRecipes
extends AbstractRecipeProvider {
    public static void generate(Consumer<FinishedRecipe> consumer) {
        TConstructMeltingRecipes.consumer = consumer;
        ID = "melting";
        for (String name : List.of("tough_alloy")) {
            TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient(name, new int[0]), TConstructMeltingRecipes.fluidIngredient("molten_" + name, 90), 800, 40);
            TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingotIngredient(name, new int[0]), TConstructMeltingRecipes.fluidIngredient("molten_" + name, 90), 800, 40);
        }
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient("polonium", new int[0]), TConstructMeltingRecipes.fluidIngredient("polonium", 90), 700, 40);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient("sulfur", new int[0]), TConstructMeltingRecipes.fluidIngredient("sulfur", 90), 500, 40);
        for (String name : Materials.isotopes()) {
            if (name.contains("xen")) continue;
            for (String type : new String[]{"", "_ox", "_ni", "_za"}) {
                String key = name + type;
                if (!FissionFuel.NC_ISOTOPES.containsKey(key)) continue;
                TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)FissionFuel.NC_ISOTOPES.get(key).get(), new int[0]), TConstructMeltingRecipes.fluidIngredient(key, 90), 700, 30);
            }
        }
        for (String name : FuelManager.all().keySet()) {
            block4: for (String subType : FuelManager.all().get(name).keySet()) {
                for (String type : new String[]{"", "za", "ox", "ni"}) {
                    List<String> key = List.of("fuel", name, subType, type);
                    String keyStr = "fuel_" + name + "_" + subType;
                    if (!type.isEmpty()) {
                        keyStr = keyStr + "_";
                    }
                    keyStr = keyStr + type;
                    TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)FissionFuel.NC_FUEL.get(key).get(), new int[0]), TConstructMeltingRecipes.fluidStackIngredient(keyStr, 90), 700, 40);
                    key = List.of("depleted", name, subType, type);
                    keyStr = "depleted_" + keyStr;
                    TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)FissionFuel.NC_DEPLETED_FUEL.get(key).get(), new int[0]), TConstructMeltingRecipes.fluidStackIngredient(keyStr, 90), 700, 40);
                    if (name.matches("xenorium.*|quantite.*")) continue block4;
                }
            }
        }
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient("sodium_hydroxide", new int[0]), TConstructMeltingRecipes.fluidIngredient("sodium_hydroxide", 90), 500, 20);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient("potassium_hydroxide", new int[0]), TConstructMeltingRecipes.fluidIngredient("potassium_hydroxide", 90), 500, 20);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.dustIngredient("arsenic", new int[0]), TConstructMeltingRecipes.fluidIngredient("arsenic", 90), 700, 20);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.gemIngredient("boron_arsenide", new int[0]), TConstructMeltingRecipes.fluidIngredient("boron_arsenide", 90), 700, 20);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_ITEMS.get("ground_cocoa_nibs").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("chocolate_liquor", 90), 100, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_ITEMS.get("cocoa_butter").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("cocoa_butter", 90), 100, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_ITEMS.get("unsweetened_chocolate").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("unsweetened_chocolate", 90), 200, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_FOOD.get("dark_chocolate").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("dark_chocolate", 90), 100, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_FOOD.get("milk_chocolate").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("milk_chocolate", 90), 100, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient(Items.f_42501_, new int[0]), TConstructMeltingRecipes.fluidIngredient("sugar", 90), 150, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_ITEMS.get("gelatin").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("gelatin", 90), 150, 10);
        TConstructMeltingRecipes.add(TConstructMeltingRecipes.ingredient((Item)NCItems.NC_FOOD.get("marshmallow").get(), new int[0]), TConstructMeltingRecipes.fluidIngredient("marshmallow", 90), 100, 10);
    }

    protected static void add(NcIngredient input, FluidStackIngredient output, int temperature, int time) {
        TConstructMeltingRecipes.tconstructMelt(List.of(input), List.of(output), false, temperature, time);
    }
}

