/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.content.energy.RTGs;
import igentuman.nc.content.energy.SolarPanels;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.content.storage.ContainerBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final EnergyGenerationConfig ENERGY_GENERATION = new EnergyGenerationConfig(BUILDER);
    public static final EnergyStorageConfig ENERGY_STORAGE = new EnergyStorageConfig(BUILDER);
    public static final MiscConfig MISC_CONFIG = new MiscConfig(BUILDER);
    public static final GTCEUCompatibilityConfig GTCEU_CONFIG = new GTCEUCompatibilityConfig(BUILDER);
    public static final StorageBlocksConfig STORAGE_BLOCKS = new StorageBlocksConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class EnergyGenerationConfig {
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_SOLAR_PANELS;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> SOLAR_PANELS_GENERATION;
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_RTG;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> RTG_GENERATION;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> RTG_RADIATION;
        public final ForgeConfigSpec.ConfigValue<Integer> STEAM_TURBINE;
        public final ForgeConfigSpec.ConfigValue<Integer> DECAY_GENERATOR;
        public final ForgeConfigSpec.ConfigValue<Double> GENERATION_MULTIPLIER;

        public EnergyGenerationConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Energy");
            this.GENERATION_MULTIPLIER = builder.comment("Multiplier for all power generation in the mod").defineInRange("generation_multiplier", 1.0, 0.001, 1000.0);
            this.REGISTER_SOLAR_PANELS = builder.comment("Allow solar panel registration: " + String.join((CharSequence)", ", SolarPanels.all().keySet())).define("register_panel", SolarPanels.initialRegistered(), o -> o instanceof ArrayList);
            this.SOLAR_PANELS_GENERATION = builder.comment("Solar panel power generation: " + String.join((CharSequence)", ", SolarPanels.all().keySet())).define("panel_power", SolarPanels.initialPower(), o -> o instanceof ArrayList);
            this.REGISTER_RTG = builder.comment("Allow rtg registration: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("register_rtg", RTGs.initialRegistered(), o -> o instanceof ArrayList);
            this.RTG_GENERATION = builder.comment("rtg generation: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("rtg_power", RTGs.initialPower(), o -> o instanceof ArrayList);
            this.RTG_RADIATION = builder.comment("rtg radiation: " + String.join((CharSequence)", ", RTGs.all().keySet())).define("rtg_radiation", RTGs.initialRadiation(), o -> o instanceof ArrayList);
            this.STEAM_TURBINE = builder.comment("Steam turbine (one block) base power gen").define("steam_turbine_power_gen", (Object)80);
            this.DECAY_GENERATOR = builder.comment("Decay Generator base power gen").define("decay_generator_power_gen", (Object)128);
            builder.pop();
        }
    }

    public static class EnergyStorageConfig {
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_ENERGY_BLOCK;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> ENERGY_BLOCK_STORAGE;
        public final ForgeConfigSpec.ConfigValue<Integer> LITHIUM_ION_BATTERY_STORAGE;
        public final ForgeConfigSpec.ConfigValue<Integer> QNP_ENERGY_STORAGE;
        public final ForgeConfigSpec.ConfigValue<Integer> LIGHTNING_ROD_CHARGE;
        public final ForgeConfigSpec.ConfigValue<Integer> QNP_ENERGY_PER_BLOCK;

        public EnergyStorageConfig(ForgeConfigSpec.Builder builder) {
            builder.push("energy_storage");
            this.LIGHTNING_ROD_CHARGE = builder.define("ligtning_rod_charge", (Object)0x100000);
            this.REGISTER_ENERGY_BLOCK = builder.comment("Allow block registration: " + String.join((CharSequence)", ", BatteryBlocks.all().keySet())).define("energy_block_registration", BatteryBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.ENERGY_BLOCK_STORAGE = builder.comment("Storage: " + String.join((CharSequence)", ", BatteryBlocks.all().keySet())).define("energy_block_storage", BatteryBlocks.initialPower(), o -> o instanceof ArrayList);
            this.LITHIUM_ION_BATTERY_STORAGE = builder.define("lithium_ion_battery_storage", (Object)0x100000);
            this.QNP_ENERGY_STORAGE = builder.define("qnp_energy_storage", (Object)0x200000);
            this.QNP_ENERGY_PER_BLOCK = builder.define("qnp_energy_per_block", (Object)200);
            builder.pop();
        }

        public int getCapacityFor(String code) {
            if (code.equals("lithium_ion_cell")) {
                return (Integer)this.LITHIUM_ION_BATTERY_STORAGE.get();
            }
            return BatteryBlocks.all().get(code).config().getStorage();
        }
    }

    public static class MiscConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> DEBUG_LOG;
        public final ForgeConfigSpec.ConfigValue<Boolean> EXPERIMENTAL_BLOCK_INDEXING;

        public MiscConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Misc");
            this.DEBUG_LOG = builder.comment("Debug logging. Enable in case of issues to collect more data").define("debug_logging", false);
            this.EXPERIMENTAL_BLOCK_INDEXING = builder.comment("Speeds up blocks indexing of multiblocks").comment("Gives big performance boost for large multiblocks").comment("Disable in case of issues").define("experimental_block_indexing", true);
            builder.pop();
        }
    }

    public static class GTCEUCompatibilityConfig {
        public final ForgeConfigSpec.ConfigValue<GTCEUCompatibility> COMPATIBILITY;
        public final ForgeConfigSpec.ConfigValue<Boolean> OVERCHARGE_EXPLOSIONS;
        public final ForgeConfigSpec.ConfigValue<Boolean> LIMIT_FE_OUTPUT;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> FISSION_REACTOR_TIER;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> TURBINE_ENERGY_TIER;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> FUSION_REACTOR_ENERGY_TIER;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> KUGELBLITZ_ENERGY_TIER;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> ACCELERATORS_ENERGY_TIER;
        public final ForgeConfigSpec.ConfigValue<GTCEUTier> PROCESSOR_ENERGY_TIER;
        public final ForgeConfigSpec.ConfigValue<Integer> ENERGY_UPGRADES_NEEDED_TO_NEXT_TIER;

        public GTCEUCompatibilityConfig(ForgeConfigSpec.Builder builder) {
            builder.push("GregTech Energy Compatibility");
            List<String> tiers = Arrays.stream(GTCEUTier.values()).map(Enum::name).toList();
            builder.comment("Tiers: " + String.join((CharSequence)", ", tiers));
            this.COMPATIBILITY = builder.comment("ONLY_FE - Only FE energy system is used").comment("ONLY_GTCEU - Only GregTech Energy system is used").comment("GTCEU_AND_FE - Both systems are used, but GTCEU is preferred").defineEnum("gregtech_energy_compatibility", (Enum)GTCEUCompatibility.GTCEU_AND_FE);
            this.FISSION_REACTOR_TIER = builder.comment("This only counts if GTCEU is supported").define("fission_reactor_energy_tier", (Object)GTCEUTier.EV);
            this.OVERCHARGE_EXPLOSIONS = builder.comment("This only counts if GTCEU is supported").comment("Explode machines when input energy is more than max input").comment("This doesn't count FE energy input").define("gregtech_energy_overcharge_explosions", true);
            this.LIMIT_FE_OUTPUT = builder.comment("This only counts if GTCEU_AND_FE compatibility used").comment("Output FE/t will be limited to max GTCEU output").comment("Formula: FE/t = voltage * amperage * (EU to FE convertion rate, usually 4)").define("limit_fe_output", false);
            this.TURBINE_ENERGY_TIER = builder.comment("This only counts if GTCEU is supported").define("turbine_energy_tier", (Object)GTCEUTier.EV);
            this.FUSION_REACTOR_ENERGY_TIER = builder.comment("This only counts if GTCEU is supported").define("fusion_reactor_energy_tier", (Object)GTCEUTier.IV);
            this.KUGELBLITZ_ENERGY_TIER = builder.comment("This only counts if GTCEU is supported").define("kugelblitz_energy_tier", (Object)GTCEUTier.LuV);
            this.ACCELERATORS_ENERGY_TIER = builder.comment("This only counts if GTCEU is supported").define("accelerators_energy_tier", (Object)GTCEUTier.LuV);
            this.PROCESSOR_ENERGY_TIER = builder.comment("This only counts if GTCEU is supported").define("processor_energy_tier", (Object)GTCEUTier.MV);
            this.ENERGY_UPGRADES_NEEDED_TO_NEXT_TIER = builder.comment("This only counts if GTCEU is supported").comment("How many energy upgrades are needed for processor to reach next energy tier").defineInRange("energy_upgrades_for_next_tier", 16, 8, 64);
            builder.pop();
        }

        public static enum GTCEUTier {
            ULV,
            LV,
            MV,
            HV,
            EV,
            IV,
            LuV,
            ZPM,
            UV,
            UHV,
            UEV,
            UIV,
            UXV,
            OpV,
            MAX;


            public static GTCEUTier byId(int energyTier) {
                if (energyTier < 0 || energyTier >= GTCEUTier.values().length) {
                    return MAX;
                }
                return GTCEUTier.values()[energyTier];
            }
        }

        public static enum GTCEUCompatibility {
            ONLY_FE,
            ONLY_GTCEU,
            GTCEU_AND_FE;

        }
    }

    public static class StorageBlocksConfig {
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_BARREL;
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTER_CONTAINER;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> BARREL_CAPACITY;

        public StorageBlocksConfig(ForgeConfigSpec.Builder builder) {
            builder.push("storage_blocks").comment("Blocks to store items, fluids, etc...");
            this.REGISTER_CONTAINER = builder.comment("Allow container registration: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("container_block_registration", ContainerBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.REGISTER_BARREL = builder.comment("Allow barrel registration: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("barrel_block_registration", BarrelBlocks.initialRegistered(), o -> o instanceof ArrayList);
            this.BARREL_CAPACITY = builder.comment("Barrel capacity in Buckets: " + String.join((CharSequence)", ", BarrelBlocks.all().keySet())).define("barrel_capacity", BarrelBlocks.initialCapacity(), o -> o instanceof ArrayList);
            builder.pop();
        }
    }
}

