/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import igentuman.nc.content.Electromagnets;
import igentuman.nc.content.RFAmplifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class FusionConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final FusionReactorConfig FUSION_CONFIG = new FusionReactorConfig(BUILDER);
    public static final ElectromagnetsConfig ELECTROMAGNETS_CONFIG = new ElectromagnetsConfig(BUILDER);
    public static final RFAmplifierConfig RF_AMPLIFIERS_CONFIG = new RFAmplifierConfig(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class FusionReactorConfig {
        public final ForgeConfigSpec.ConfigValue<Integer> MIN_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> MAX_SIZE;
        public final ForgeConfigSpec.ConfigValue<Double> MINIMAL_MAGNETIC_FIELD;
        public final ForgeConfigSpec.ConfigValue<Double> RF_AMPLIFICATION_MULTIPLIER;
        public final ForgeConfigSpec.ConfigValue<Double> PLASMA_TO_ENERGY_CONVERTION;
        public final ForgeConfigSpec.ConfigValue<Double> EXPLOSION_RADIUS;

        public FusionReactorConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for Fusion Reactor").push("fusion_reactor");
            this.MIN_SIZE = builder.comment("Min reactor size.").defineInRange("min_size", 1, 1, 24);
            this.MAX_SIZE = builder.comment("Max reactor size.").defineInRange("max_size", 32, 3, 48);
            this.EXPLOSION_RADIUS = builder.comment("Explosion size if reactor overheats. 4 - TNT size. Set to 0 to disable explosion.").defineInRange("reactor_explosion_radius", 2.0, 0.0, 10.0);
            this.MINIMAL_MAGNETIC_FIELD = builder.comment("Minimal magnetic field required to operate reactor. (Depends on reactor size).").defineInRange("minimal_magnetic_field", 8.0, 1.0, 100.0);
            this.RF_AMPLIFICATION_MULTIPLIER = builder.comment("Affects heating rate for plasma by rf amplifiers.").defineInRange("rf_amplification_multiplier", 5.0, 0.01, 100.0);
            this.PLASMA_TO_ENERGY_CONVERTION = builder.comment("Affects plasma energy to FE converion rate.").defineInRange("plasma_to_energy_convertion", 1.0, 0.01, 10.0);
            builder.pop();
        }
    }

    public static class ElectromagnetsConfig {
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTERED;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> POWER;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> HEAT;
        public final ForgeConfigSpec.ConfigValue<List<Double>> MAGNETIC_FIELD;

        public ElectromagnetsConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for Electromagnets").push("electromagnets");
            this.REGISTERED = builder.comment("If Electromagnets are registered.").define("registered", Electromagnets.initialRegistered(), o -> o instanceof ArrayList);
            this.POWER = builder.comment("Power consumption (FE/t): " + String.join((CharSequence)", ", Electromagnets.all().keySet())).define("power", FusionConfig.toList(Electromagnets.initialPower()), o -> o instanceof ArrayList);
            this.HEAT = builder.comment("Heat generation: " + String.join((CharSequence)", ", Electromagnets.all().keySet())).define("heat", FusionConfig.toList(Electromagnets.initialHeat()), o -> o instanceof ArrayList);
            this.MAGNETIC_FIELD = builder.comment("Magnetic field strength: " + String.join((CharSequence)", ", Electromagnets.all().keySet())).define("heat", FusionConfig.toList(Electromagnets.initialMagneticField()), o -> o instanceof ArrayList);
            builder.pop();
        }
    }

    public static class RFAmplifierConfig {
        public final ForgeConfigSpec.ConfigValue<List<Boolean>> REGISTERED;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> POWER;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> HEAT;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> VOLTAGE;

        public RFAmplifierConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for RF Amplifiers").push("rf_amplifiers");
            this.REGISTERED = builder.comment("If RF Amplifier are registered.").define("registered", RFAmplifier.initialRegistered(), o -> o instanceof ArrayList);
            this.POWER = builder.comment("Power consumption (FE/t): " + String.join((CharSequence)", ", RFAmplifier.all().keySet())).define("power", FusionConfig.toList(RFAmplifier.initialPower()), o -> o instanceof ArrayList);
            this.HEAT = builder.comment("Heat generation: " + String.join((CharSequence)", ", RFAmplifier.all().keySet())).define("heat", FusionConfig.toList(RFAmplifier.initialHeat()), o -> o instanceof ArrayList);
            this.VOLTAGE = builder.comment("Amplification Voltage: " + String.join((CharSequence)", ", RFAmplifier.all().keySet())).define("voltage", FusionConfig.toList(RFAmplifier.initialVoltage()), o -> o instanceof ArrayList);
            builder.pop();
        }
    }
}

