/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class RadiationConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final RadiationConf RADIATION_CONFIG = new RadiationConf(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static <T> List<T> toList(Collection<T> vals) {
        return new ArrayList<T>(vals);
    }

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class RadiationConf {
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLED;
        public final ForgeConfigSpec.ConfigValue<Integer> NATURAL_RADIATION;
        public final ForgeConfigSpec.ConfigValue<Integer> DECAY_SPEED;
        public final ForgeConfigSpec.ConfigValue<Integer> DECAY_SPEED_FOR_PLAYER;
        public final ForgeConfigSpec.ConfigValue<Double> GAIN_SPEED_FOR_PLAYER;
        public final ForgeConfigSpec.ConfigValue<List<String>> ITEM_RADIATION;
        public final ForgeConfigSpec.ConfigValue<List<String>> RADIATION_REMOVAL_ITEMS;
        public final ForgeConfigSpec.ConfigValue<List<String>> ARMOR_PROTECTION;
        public final ForgeConfigSpec.ConfigValue<List<String>> BIOME_RADIATION;
        public final ForgeConfigSpec.ConfigValue<List<String>> DIMENSION_RADIATION;
        public final ForgeConfigSpec.ConfigValue<Integer> RADIATION_UPDATE_INTERVAL;
        public final ForgeConfigSpec.ConfigValue<Boolean> MEKANISM_RADIATION_INTEGRATION;
        protected HashMap<String, Integer> biomeRadiationMap;
        protected HashMap<String, Integer> dimensionRadiationMap;

        public int biomeRadiation(String id) {
            if (this.biomeRadiationMap == null) {
                this.biomeRadiationMap = new HashMap();
                for (String line : (List)this.BIOME_RADIATION.get()) {
                    String[] split = line.split("\\|");
                    if (split.length != 2) continue;
                    this.biomeRadiationMap.put(split[0].trim(), Integer.parseInt(split[1].trim()));
                }
            }
            if (this.biomeRadiationMap.containsKey(id)) {
                return this.biomeRadiationMap.get(id);
            }
            return 0;
        }

        public int dimensionRadiation(String id) {
            if (this.dimensionRadiationMap == null) {
                this.dimensionRadiationMap = new HashMap();
                for (String line : (List)this.DIMENSION_RADIATION.get()) {
                    String[] split = line.split("\\|");
                    if (split.length != 2) continue;
                    this.dimensionRadiationMap.put(split[0].trim(), Integer.parseInt(split[1].trim()));
                }
            }
            if (this.dimensionRadiationMap.containsKey(id)) {
                return this.dimensionRadiationMap.get(id);
            }
            return 0;
        }

        public RadiationConf(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings for Radiation").push("radiation");
            this.ENABLED = builder.comment("If radiation is enabled.").define("enabled", true);
            this.NATURAL_RADIATION = builder.comment(new String[]{"General background radiation everywhere (pRad).", "Total radiation = background_radiation + dimension_radiation + chunk_radiation + in-game exposure"}).defineInRange("background_radiation", 20, 0, 10000);
            this.DECAY_SPEED = builder.comment("How fast contamination decays (pRad/s).").defineInRange("decay_speed", 2000, 1000, 10000);
            this.DECAY_SPEED_FOR_PLAYER = builder.comment("How fast contamination decays in player's body (uRad/s).").defineInRange("decay_speed_for_player", 50, 1, 5000);
            this.GAIN_SPEED_FOR_PLAYER = builder.comment("Rate at which player gets radiation dose.").defineInRange("gain_speed_for_player", 0.1, 0.0, 5.0);
            this.RADIATION_REMOVAL_ITEMS = builder.comment("List of items what cleans player radiation when used (pRad). Format: item_id|radiation").define("radiation_removal_items", List.of("minecraft:golden_carrot|10000000", "minecraft:golden_apple|100000000", "minecraft:enchanted_golden_apple|2500000000", "nuclearcraft:dominos|250000000", "nuclearcraft:moresmore|2500000000", "nuclearcraft:evenmoresmore|1000000000", "nuclearcraft:radaway|5000000000"), o -> o instanceof ArrayList);
            this.ITEM_RADIATION = builder.comment("List of items what have radiation (pRad). Format: item_id|radiation").define("items_radiation", List.of("nuclearcraft:spaxelhoe_thorium|50000", "mekanism:pellet_polonium|4000000", "mekanism:pellet_plutonium|2500000", "mekanism:reprocessed_fissile_fragment|1800000"), o -> o instanceof ArrayList);
            this.ARMOR_PROTECTION = builder.comment("List of armor items and default shielding lvl. Format: item_id|radiation").define("armor_shielding", List.of("mekanism:hazmat_mask|3", "mekanism:hazmat_gown|5", "mekanism:hazmat_pants|4", "mekanism:hazmat_boots|3", "mekanism:mekasuit_helmet|5", "mekanism:mekasuit_bodyarmor|5", "mekanism:mekasuit_pants|5", "mekanism:mekasuit_boots|5", "nuclearcraft:hazmat_mask|3", "nuclearcraft:hazmat_chest|5", "nuclearcraft:hazmat_pants|4", "nuclearcraft:hazmat_boots|3", "nuclearcraft:hev_helmet|5", "nuclearcraft:hev_chest|7", "nuclearcraft:hev_pants|6", "nuclearcraft:hev_boots|5"), o -> o instanceof ArrayList);
            this.BIOME_RADIATION = builder.comment(new String[]{"Natural radiation per biome: uRad", "Format: biome_id|radiation"}).define("biome_radiation", List.of("nuclearcraft:wasteland|40000", "minecraft:nether_wastes|10000"), o -> o instanceof ArrayList);
            this.DIMENSION_RADIATION = builder.comment(new String[]{"Natural radiation per dimension: uRad", "Format: dim_id|radiation"}).define("dimension_radiation", List.of("nuclearcraft:wasteland|50000", "minecraft:the_nether|5000"), o -> o instanceof ArrayList);
            this.RADIATION_UPDATE_INTERVAL = builder.comment(new String[]{"Interval between radiation updates in ticks. 20 ticks = 1 second.", "Bigger interval - less lag, but less accurate radiation decay."}).defineInRange("update_interval", 40, 2, 1000);
            this.MEKANISM_RADIATION_INTEGRATION = builder.comment(new String[]{"NC radiation sources will generate mekanism radiation and wise-versa.", "You can disable mekanism radiation, but radiation sources in mekanism still will generate NC radiation.", "You can disable NC radiation, but NC radiation sources still will generate mekanism radiation."}).define("mekanism_radiation_integration", true);
            builder.pop();
        }
    }
}

