/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.client;

import igentuman.nc.setup.registration.NCFluids;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.model.DynamicFluidContainerModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="nuclearcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ColorHandler {
    private static final ItemColor BUCKET_ITEM_COLOR = new DynamicFluidContainerModel.Colors();

    public static void register(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(ColorHandler::registerItemColorHandlers);
        MinecraftForge.EVENT_BUS.addListener(ColorHandler::registerBlockColorHandlers);
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        ColorHandler.registerBucketColorHandler(event);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        for (String gas : NCFluids.NC_GASES.keySet()) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)NCFluids.ALL_FLUID_ENTRIES.get(gas).getFlowing(), (RenderType)RenderType.m_110466_());
        }
        for (String fluid : NCFluids.NC_MATERIALS.keySet()) {
            if (fluid.contains("molten")) {
                return;
            }
            ItemBlockRenderTypes.setRenderLayer((Fluid)NCFluids.NC_MATERIALS.get(fluid).getStill(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)NCFluids.NC_MATERIALS.get(fluid).getFlowing(), (RenderType)RenderType.m_110466_());
        }
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (String string : NCFluids.NC_GASES.keySet()) {
        }
    }

    public static void registerBucketColorHandler(RegisterColorHandlersEvent.Item event) {
        for (String name : NCFluids.NC_MATERIALS.keySet()) {
            event.register(BUCKET_ITEM_COLOR, new ItemLike[]{NCFluids.NC_MATERIALS.get(name).getBucket()});
        }
        for (String name : NCFluids.NC_GASES.keySet()) {
            event.register(BUCKET_ITEM_COLOR, new ItemLike[]{NCFluids.NC_GASES.get(name).getBucket()});
        }
    }
}

