/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.event.server;

import igentuman.nc.block.turbine.TurbineBladeBlock;
import igentuman.nc.multiblock.MultiblockExecutorManager;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.radiation.data.RadiationEvents;
import igentuman.nc.setup.registration.FissionFuel;
import igentuman.nc.setup.registration.Villager;
import igentuman.nc.util.RadiationExecutorManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nuclearcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    public static final List<Block> trackingBlocks = new ArrayList<Block>();

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        Villager.addVillagerTrades(event);
    }

    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 8), new ItemStack((ItemLike)FissionFuel.NC_ISOTOPES.get("plutonium/239").get(), 1), 8, 2, 0.2f));
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer().m_9236_().m_5776_()) {
            return;
        }
        BlockState state = event.getState();
        if (state == null) {
            return;
        }
        if (trackingBlocks.contains(state.m_60734_())) {
            MultiblockHandler.get((ResourceKey<Level>)event.getPlayer().m_9236_().m_46472_()).trackBlockChange(event.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        boolean placed = true;
        BlockState state = event.getState();
        if (state == null) {
            return;
        }
        if (trackingBlocks.contains(state.m_60734_())) {
            MultiblockHandler.get((ResourceKey<Level>)event.getEntity().m_9236_().m_46472_()).trackBlockChange(event.getPos());
        }
        if (state.m_60734_() instanceof TurbineBladeBlock) {
            placed = TurbineBladeBlock.processBlockPlace(event.getLevel(), event.getPos(), event.getPlacedBlock(), state, event.getPlacedAgainst());
        }
        if (!placed) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void chunkUnloadEvent(ChunkEvent.Unload event) {
    }

    @SubscribeEvent
    public void worldUnloadEvent(LevelEvent.Unload event) {
    }

    @SubscribeEvent
    public void worldLoadEvent(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            MultiblockExecutorManager.getExecutor();
            RadiationExecutorManager.getExecutor();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (!event.side.isServer() || event.phase == TickEvent.Phase.END) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.LevelTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.START) {
            if (event.level.m_46467_() % 5L != 0L || event.level.m_7726_().m_8482_() < 1) {
                return;
            }
            ServerLevel level = (ServerLevel)event.level;
            RadiationEvents.tickAsync(event);
            MultiblockHandler.tickAsync(level);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MultiblockExecutorManager.shutdown();
        RadiationExecutorManager.shutdown();
    }
}

