/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.handler.sided;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.handler.sided.SlotModePair;
import igentuman.nc.handler.sided.capability.FluidCapabilityHandler;
import igentuman.nc.handler.sided.capability.Gas2FluidConverter;
import igentuman.nc.handler.sided.capability.ItemCapabilityHandler;
import igentuman.nc.handler.sided.capability.Slurry2FluidConverter;
import igentuman.nc.recipes.AbstractRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;

public class SidedContentHandler
implements INBTSerializable<Tag> {
    public final int inputItemSlots;
    public final int outputItemSlots;
    public final int inputFluidSlots;
    public final int outputFluidSlots;
    public final ItemCapabilityHandler itemHandler;
    public final LazyOptional<ItemCapabilityHandler> itemCapability;
    public final FluidCapabilityHandler fluidHandler;
    public NuclearCraftBE blockEntity;
    public boolean hasPush = false;
    public boolean hasPull = false;
    private boolean updated = false;
    private Gas2FluidConverter gasConverter;
    private Slurry2FluidConverter slurryConverter;
    private Direction lastPushSide = Direction.UP;
    private Direction lastPullSide = Direction.UP;
    protected String cacheKey = "";

    public SidedContentHandler(int inputItemSlots, int outputItemSlots, int inputFluidSlots, int outputFluidSlots, int ... tankCapacities) {
        this.inputItemSlots = inputItemSlots;
        this.outputItemSlots = outputItemSlots;
        this.inputFluidSlots = inputFluidSlots;
        this.outputFluidSlots = outputFluidSlots;
        if (inputItemSlots + outputItemSlots > 0) {
            this.itemHandler = new ItemCapabilityHandler(inputItemSlots, outputItemSlots);
            this.itemHandler.tile = this.blockEntity;
            this.itemHandler.sidedContentHandler = this;
            this.itemCapability = LazyOptional.of(() -> this.itemHandler);
        } else {
            this.itemHandler = null;
            this.itemCapability = LazyOptional.empty();
        }
        if (inputFluidSlots + outputFluidSlots > 0) {
            int inputTankSize = 10;
            int outputTankSize = 10;
            if (tankCapacities.length > 0) {
                inputTankSize = tankCapacities[0];
                if (tankCapacities.length > 1) {
                    outputTankSize = tankCapacities[1];
                }
            }
            this.fluidHandler = new FluidCapabilityHandler(inputFluidSlots, outputFluidSlots, inputTankSize, outputTankSize);
            this.fluidHandler.tile = this.blockEntity;
            this.fluidHandler.sidedContentHandler = this;
        } else {
            this.fluidHandler = null;
        }
    }

    public static Tag serializeSideMap(HashMap<Integer, SlotModePair[]> sideMap) {
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < 6; ++i) {
            nbt.m_128365_("side" + i, SlotModePair.serializeArray(sideMap.get(i)));
        }
        return nbt;
    }

    public static HashMap<Integer, SlotModePair[]> deserializeSideMap(CompoundTag sideMap) {
        HashMap<Integer, SlotModePair[]> map = new HashMap<Integer, SlotModePair[]>();
        for (int i = 0; i < 6; ++i) {
            map.put(i, SlotModePair.deserializeArray(sideMap.m_128469_("side" + i)));
        }
        return map;
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.itemHandler != null) {
            nbt.m_128365_("itemHandler", (Tag)this.itemHandler.serializeNBT());
        }
        if (this.fluidHandler != null) {
            nbt.m_128365_("fluidHandler", (Tag)this.fluidHandler.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        if (this.itemHandler != null) {
            this.itemHandler.deserializeNBT(((CompoundTag)nbt).m_128469_("itemHandler"));
        }
        if (this.fluidHandler != null) {
            this.fluidHandler.deserializeNBT(((CompoundTag)nbt).m_128469_("fluidHandler"));
        }
    }

    public <T> LazyOptional<T> getItemCapability(Direction side) {
        if (this.hasItemCapability(side)) {
            return this.itemHandler.getCapability(side).cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getFluidCapability(Direction side) {
        if (this.hasFluidCapability(side)) {
            return this.fluidHandler.getCapability(side).cast();
        }
        return LazyOptional.empty();
    }

    public boolean hasFluidCapability(Direction side) {
        if (this.inputFluidSlots + this.outputFluidSlots == 0) {
            return false;
        }
        return side == null || ((SlotModePair[])this.fluidHandler.sideMap.get(side.ordinal())).length > 0;
    }

    public boolean hasItemCapability(Direction side) {
        if (this.inputItemSlots + this.outputItemSlots == 0) {
            return false;
        }
        return side == null || ((SlotModePair[])this.itemHandler.sideMap.get(side.ordinal())).length > 0;
    }

    public void invalidate() {
        this.itemCapability.invalidate();
    }

    public int toggleSideConfig(int slotId, int direction) {
        try {
            if (slotId < this.inputFluidSlots) {
                return this.fluidHandler.toggleMode(this.getSlotIdFromGlobalId(slotId), direction);
            }
            if (slotId < this.inputFluidSlots + this.inputItemSlots) {
                return this.itemHandler.toggleMode(this.getSlotIdFromGlobalId(slotId), direction);
            }
            if (slotId < this.inputFluidSlots + this.inputItemSlots + this.outputFluidSlots) {
                return this.fluidHandler.toggleMode(this.getSlotIdFromGlobalId(slotId) + this.inputFluidSlots, direction);
            }
            if (slotId < this.inputFluidSlots + this.outputFluidSlots + this.inputItemSlots + this.outputItemSlots) {
                return this.itemHandler.toggleMode(this.getSlotIdFromGlobalId(slotId) + this.inputItemSlots, direction);
            }
            return -1;
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return -1;
        }
    }

    public <RECIPE extends AbstractRecipe> void setBlockEntity(NuclearCraftBE blockEntity) {
        this.blockEntity = blockEntity;
        if (this.fluidHandler != null) {
            this.fluidHandler.tile = blockEntity;
        }
        if (this.itemHandler != null) {
            this.itemHandler.tile = blockEntity;
        }
    }

    public int getSlotIdFromGlobalId(int id) {
        if (id < this.inputFluidSlots) {
            return id;
        }
        if (id - this.inputFluidSlots >= 0 && id - this.inputFluidSlots < this.inputItemSlots) {
            return id - this.inputFluidSlots;
        }
        if (id - this.inputFluidSlots - this.inputItemSlots >= 0 && id - this.inputFluidSlots - this.inputItemSlots < this.outputFluidSlots) {
            return id - this.inputFluidSlots - this.inputItemSlots;
        }
        if (id - this.inputFluidSlots - this.inputItemSlots - this.outputFluidSlots >= 0 && id - this.inputFluidSlots - this.inputItemSlots - this.outputFluidSlots < this.outputItemSlots) {
            return id - this.inputFluidSlots - this.inputItemSlots - this.outputFluidSlots;
        }
        return -1;
    }

    public SlotModePair.SlotMode getSlotMode(int direction, int slotId) {
        try {
            if (this.getSlotType(slotId) == SlotModePair.SlotMode.INPUT) {
                if (slotId < this.inputFluidSlots) {
                    return this.fluidHandler.getMode(this.getSlotIdFromGlobalId(slotId), direction);
                }
                return this.itemHandler.getMode(this.getSlotIdFromGlobalId(slotId), direction);
            }
            if (slotId < this.inputFluidSlots + this.inputItemSlots + this.outputFluidSlots) {
                return this.fluidHandler.getMode(this.getSlotIdFromGlobalId(slotId) + this.inputFluidSlots, direction);
            }
            return this.itemHandler.getMode(this.getSlotIdFromGlobalId(slotId) + this.inputItemSlots, direction);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return SlotModePair.SlotMode.UNKNOWN;
        }
    }

    public SlotModePair.SlotMode getSlotType(int id) {
        return id > this.inputFluidSlots + this.inputItemSlots - 1 ? SlotModePair.SlotMode.OUTPUT : SlotModePair.SlotMode.INPUT;
    }

    public boolean tick() {
        this.updated = false;
        if (!this.canPush() && !this.canPull()) {
            return this.updated;
        }
        this.push(this.lastPushSide);
        this.pull(this.lastPullSide);
        for (Direction dir : Direction.values()) {
            this.push(dir);
            this.pull(dir);
        }
        return this.updated;
    }

    private boolean hasPush() {
        boolean result = false;
        if (this.fluidHandler != null) {
            result = this.fluidHandler.hasPush();
        }
        if (this.itemHandler != null) {
            result = result || this.itemHandler.hasPush();
        }
        return result;
    }

    private boolean hasPull() {
        boolean result = false;
        if (this.fluidHandler != null) {
            result = this.fluidHandler.hasPull();
        }
        if (this.itemHandler != null) {
            result = result || this.itemHandler.hasPull();
        }
        return result;
    }

    private boolean canPush() {
        return this.hasPush && (this.itemHandler != null && this.itemHandler.canPush() || this.fluidHandler != null && this.fluidHandler.canPush());
    }

    private boolean canPull() {
        return this.hasPull && (this.itemHandler != null && this.itemHandler.canPull() || this.fluidHandler != null && this.fluidHandler.canPull());
    }

    public void push(Direction side) {
        if (!this.canPush()) {
            return;
        }
        if (this.itemHandler != null) {
            boolean bl = this.updated = this.itemHandler.pushItems(side) || this.updated;
        }
        if (this.fluidHandler != null) {
            boolean bl = this.updated = this.fluidHandler.pushFluids(side) || this.updated;
        }
        if (this.updated) {
            this.lastPushSide = side;
        }
    }

    public void pull(Direction side) {
        if (!this.canPull()) {
            return;
        }
        if (this.itemHandler != null) {
            boolean bl = this.updated = this.itemHandler.pullItems(side) || this.updated;
        }
        if (this.fluidHandler != null) {
            boolean bl = this.updated = this.fluidHandler.pullFluids(side) || this.updated;
        }
        if (this.updated) {
            this.lastPullSide = side;
        }
    }

    public void clearHolded() {
        if (this.hasItemCapability(null)) {
            this.itemHandler.holdedInputs.clear();
        }
        if (this.hasFluidCapability(null)) {
            this.fluidHandler.holdedInputs.clear();
        }
    }

    public String getCacheKey() {
        this.cacheKey = "";
        if (this.itemHandler != null) {
            this.cacheKey = this.cacheKey + this.itemHandler.getCacheKey();
        }
        if (this.fluidHandler != null) {
            this.cacheKey = this.cacheKey + this.fluidHandler.getCacheKey();
        }
        return this.cacheKey;
    }

    public void saveSideMap() {
        if (this.itemHandler != null) {
            this.itemHandler.sideMapUpdated = true;
        }
        if (this.fluidHandler != null) {
            this.fluidHandler.sideMapUpdated = true;
        }
    }

    public void setAllowedInputItems(Supplier<List<ItemStack>> allowedInputItems) {
        if (this.itemHandler != null) {
            this.itemHandler.allowedInputItems = allowedInputItems;
        }
    }

    public void setAllowedInputFluids(int slotId, Supplier<List<FluidStack>> allowedInputFluids) {
        if (this.fluidHandler != null) {
            if (this.fluidHandler.allowedFluids == null) {
                this.fluidHandler.allowedFluids = new HashMap();
            }
            this.fluidHandler.allowedFluids.remove(slotId);
            this.fluidHandler.allowedFluids.put(slotId, allowedInputFluids);
        }
    }

    public void voidSlot(int slotId) {
        try {
            if (this.getSlotType(slotId) == SlotModePair.SlotMode.INPUT) {
                if (slotId < this.inputFluidSlots) {
                    this.fluidHandler.voidSlot(this.getSlotIdFromGlobalId(slotId));
                }
                this.itemHandler.voidSlot(this.getSlotIdFromGlobalId(slotId));
            }
            if (slotId < this.inputFluidSlots + this.inputItemSlots + this.outputFluidSlots) {
                this.fluidHandler.voidSlot(this.getSlotIdFromGlobalId(slotId) + this.inputFluidSlots);
            }
            this.itemHandler.voidSlot(this.getSlotIdFromGlobalId(slotId) + this.inputItemSlots);
        }
        catch (IndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public Object[] getSlotContent(int slotId) {
        try {
            if (this.getSlotType(slotId) == SlotModePair.SlotMode.INPUT) {
                if (slotId < this.inputFluidSlots) {
                    return this.fluidHandler.getSlotContent(this.getSlotIdFromGlobalId(slotId));
                }
                return this.itemHandler.getSlotContent(this.getSlotIdFromGlobalId(slotId));
            }
            if (slotId < this.inputFluidSlots + this.inputItemSlots + this.outputFluidSlots) {
                return this.fluidHandler.getSlotContent(this.getSlotIdFromGlobalId(slotId) + this.inputFluidSlots);
            }
            return this.itemHandler.getSlotContent(this.getSlotIdFromGlobalId(slotId) + this.inputItemSlots);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            return new Object[0];
        }
    }

    public <T> T gasConverter(Direction side) {
        if (this.gasConverter == null) {
            this.gasConverter = new Gas2FluidConverter();
            this.gasConverter.setFluidHandler(this.fluidHandler);
        }
        return (T)this.gasConverter.forSide(side);
    }

    public <T> T getSlurryConverter(Direction side) {
        if (this.slurryConverter == null) {
            this.slurryConverter = new Slurry2FluidConverter();
            this.slurryConverter.setFluidHandler(this.fluidHandler);
        }
        return (T)this.slurryConverter.forSide(side);
    }

    public void voidFluidSlot(int slotId) {
        if (this.fluidHandler != null) {
            this.fluidHandler.voidSlot(slotId);
        }
    }

    public void handleFluidItemClick(int slotId, ItemStack stack, ServerPlayer player) {
        if (this.fluidHandler != null) {
            this.fluidHandler.handleFluidItemClick(slotId, stack, player);
        }
    }

    public boolean isInputEmpty() {
        int i;
        if (this.itemHandler != null) {
            for (i = 0; i < this.inputItemSlots; ++i) {
                if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
        }
        if (this.fluidHandler != null) {
            for (i = 0; i < this.inputFluidSlots; ++i) {
                if (this.fluidHandler.getFluidInSlot(i).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static enum RelativeDirection {
        FRONT,
        BACK,
        LEFT,
        RIGHT,
        UP,
        DOWN;


        public static Direction toAbsolute(RelativeDirection relativeDirection, Direction facing) {
            switch (relativeDirection) {
                case FRONT: {
                    return facing;
                }
                case BACK: {
                    return facing.m_122424_();
                }
                case LEFT: {
                    return facing.m_122427_();
                }
                case RIGHT: {
                    return facing.m_122428_();
                }
                case UP: {
                    return Direction.UP;
                }
                case DOWN: {
                    return Direction.DOWN;
                }
            }
            return null;
        }

        public static RelativeDirection toRelative(Direction absoluteDirection, Direction facing) {
            if (absoluteDirection == facing) {
                return FRONT;
            }
            if (absoluteDirection == facing.m_122424_()) {
                return BACK;
            }
            if (absoluteDirection == facing.m_122427_()) {
                return LEFT;
            }
            if (absoluteDirection == facing.m_122428_()) {
                return RIGHT;
            }
            if (absoluteDirection == Direction.UP) {
                return UP;
            }
            if (absoluteDirection == Direction.DOWN) {
                return DOWN;
            }
            return null;
        }

        public static String getDirectionName(int direction) {
            return RelativeDirection.values()[direction].name().toUpperCase();
        }
    }

    public static enum SlotType {
        INPUT,
        OUTPUT;

    }
}

