/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.capability.CapabilityUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class BarrelBlockItem
extends BlockItem {
    public BarrelBlockItem(Block pBlock, Item.Properties props) {
        super(pBlock, new Item.Properties().m_41487_(1));
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, this.getCapacity());
    }

    public int getCapacity() {
        return BarrelBlocks.all().get(this.code()).config().getCapacity();
    }

    public IFluidHandlerItem getFluid(ItemStack stack) {
        return (IFluidHandlerItem)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.FLUID_HANDLER_ITEM);
    }

    public String code() {
        return this.m_5456_().toString();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int storage = BarrelBlocks.all().get(this.code()).config().getCapacity() * 1000;
        FluidStack fluid = this.getFluid(stack).getFluidInTank(0);
        if (fluid == null || fluid.isFluidEqual(FluidStack.EMPTY)) {
            list.add((Component)TextUtils.__("tooltip.nc.liquid_capacity", TextUtils.formatLiquid(storage)).m_130940_(ChatFormatting.BLUE));
        } else {
            list.add((Component)TextUtils.__("tooltip.nc.liquid_stored", fluid.getDisplayName(), TextUtils.formatLiquid(fluid.getAmount()), TextUtils.formatLiquid(storage)).m_130940_(ChatFormatting.BLUE));
        }
        list.add((Component)TextUtils.__("tooltip.nc.use_multitool", new Object[0]).m_130940_(ChatFormatting.YELLOW));
    }
}

