/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.content.energy.BatteryBlocks;
import igentuman.nc.handler.ItemEnergyHandler;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.util.ModUtil;
import igentuman.nc.util.TextUtils;
import igentuman.nc.util.capability.CapabilityUtils;
import igentuman.nc.util.capability.CustomEnergyStorage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class BatteryBlockItem
extends BlockItem {
    public BatteryBlockItem(Block pBlock, Item.Properties props) {
        super(pBlock, new Item.Properties().m_41487_(1));
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return false;
    }

    public int m_142159_(ItemStack pStack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected int getEnergyMaxStorage() {
        return CommonConfig.ENERGY_STORAGE.getCapacityFor(this.toString());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new ItemEnergyHandler(stack, this.getEnergyMaxStorage(), this.getEnergyMaxStorage(), this.getEnergyMaxStorage());
    }

    public CustomEnergyStorage getEnergy(ItemStack stack) {
        return (CustomEnergyStorage)((Object)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY));
    }

    public int m_142158_(ItemStack stack) {
        CustomEnergyStorage energyStorage = this.getEnergy(stack);
        float chargeRatio = (float)energyStorage.getEnergyStored() / (float)this.getEnergyMaxStorage();
        return (int)Math.min(13.0f, 13.0f * chargeRatio);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.eu_energy_stored", GTUtils.formatEUEnergy(this.getEnergy(stack).getEnergyStored()), GTUtils.formatEUEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.GOLD));
            list.add((Component)TextUtils.__("tooltip.nc.energy_eu_tier", new Object[]{BatteryBlocks.all().get(this.toString()).getEnergyTier()}).m_130940_(ChatFormatting.GOLD));
        }
        if (!ModUtil.isGtLoaded() || !GTUtils.isOnlyGTCEUCapEnabled()) {
            list.add((Component)TextUtils.__("tooltip.nc.energy_stored", TextUtils.formatEnergy(this.getEnergy(stack).getEnergyStored()), TextUtils.formatEnergy(this.getEnergyMaxStorage())).m_130940_(ChatFormatting.BLUE));
        }
        list.add((Component)TextUtils.__("tooltip.nc.use_multitool", new Object[0]).m_130940_(ChatFormatting.YELLOW));
    }
}

