/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.item;

import igentuman.nc.content.fuel.FuelDef;
import igentuman.nc.content.fuel.FuelManager;
import igentuman.nc.handler.event.client.InputEvents;
import igentuman.nc.util.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemFuel
extends Item {
    public FuelDef def;
    public double heat = 0.0;
    public int forge_energy = 0;
    public double heat_boiling = 0.0;
    public int criticality = 0;
    public int depletion = 0;
    public int efficiency = 0;
    public final String group;
    public final String name;
    public final String subType;
    private boolean initialized = false;

    public ItemFuel(Item.Properties pProperties, String group, String name, String subType) {
        super(pProperties);
        this.group = group;
        this.name = name;
        this.subType = subType;
    }

    public ItemFuel initDefinition() {
        if (this.initialized) {
            return this;
        }
        this.def = FuelManager.all().get(this.group).get(this.name).subType(this.subType);
        this.heat = this.def.getHeatFEMode();
        this.heat_boiling = this.def.getHeatBoilingMode();
        this.criticality = this.def.criticality;
        this.depletion = this.def.depletion;
        this.efficiency = this.def.efficiency;
        this.forge_energy = this.def.forge_energy;
        return this;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        this.initDefinition();
        if (!InputEvents.DESCRIPTIONS_SHOW) {
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("tooltip.toggle_description_keys", new Object[0]), ChatFormatting.GRAY));
        } else {
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("fuel.heat.descr", TextUtils.numberFormat(this.heat)), ChatFormatting.GOLD));
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("fuel.forge_energy.descr", this.forge_energy), ChatFormatting.BLUE));
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("fuel.depletion.descr", this.depletion()), ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)TextUtils.__("fuel.description", new Object[0]), ChatFormatting.AQUA));
        }
    }

    public int depletion() {
        return (int)((double)this.depletion * this.def.depletionMult());
    }
}

