/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.fission;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import igentuman.nc.NuclearCraft;
import igentuman.nc.block.fission.FissionFuelCellBlock;
import igentuman.nc.block.fission.HeatSinkBlock;
import igentuman.nc.handler.config.FissionConfig;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.fission.FissionReactorMultiblock;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.StackUtils;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class HeatSinkDef {
    public double heat = 0.0;
    public String name = "";
    public String[] rules;
    protected Validator validator;
    public final Pattern COND_FUNC = Pattern.compile("=|-|>|<|\\^");
    public final Pattern ACTIVE_CHECK = Pattern.compile("^(?!.*active_).+_heat_sink$");
    private List<FluidStack> allowedFluids;

    public static HeatSinkDef of(JsonObject asJsonObject) {
        HeatSinkDef def = new HeatSinkDef();
        try {
            def.heat = asJsonObject.get("heat").getAsDouble();
            def.name = asJsonObject.get("type").getAsString();
            JsonArray rules = asJsonObject.getAsJsonArray("placement_rule");
            String[] ruleArray = new String[rules.size()];
            for (int i = 0; i < rules.size(); ++i) {
                ruleArray[i] = rules.get(i).getAsString();
            }
            def.rules = ruleArray;
            return def;
        }
        catch (Exception e) {
            NuclearCraft.LOGGER.error("Error parsing heatsink definition: " + e.getMessage());
            return null;
        }
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.initCondition(this.rules);
        }
        return this.validator;
    }

    private HeatSinkDef() {
    }

    private void initCondition(String[] rules) {
        HashMap<String[], List<String>> conditions = new HashMap<String[], List<String>>();
        for (String rule : rules) {
            int cnt = 1;
            try {
                cnt = Math.max(Integer.parseInt(rule.substring(rule.length() - 1)), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] conditionParts = rule.split("=|-|>|<|\\^");
            String[] blocks = conditionParts[0].split("\\|");
            List<String> actualBlocks = this.collectBlocks(blocks);
            conditions.put(new String[]{this.getConditionFunc(rule), String.valueOf(cnt), rule}, actualBlocks);
        }
        this.validator = new Validator(conditions);
    }

    private String getConditionFunc(String rule) {
        Matcher matcher = this.COND_FUNC.matcher(rule);
        ArrayList<String> matches = new ArrayList<String>();
        String funcType = ">";
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (!matches.isEmpty()) {
            funcType = (String)matches.get(0);
        }
        return funcType;
    }

    private List<String> collectBlocks(String[] blocks) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String block : blocks) {
            if (block.contains("#")) {
                tmp.addAll(StackUtils.getItemsByTagKey(block.replace("#", "")));
                continue;
            }
            Object blockName = block;
            if (!block.contains(":")) {
                blockName = "nuclearcraft:" + block;
            }
            tmp.add((String)blockName);
            if (!((Boolean)FissionConfig.FISSION_CONFIG.ACTIVE_HEATSINK_PRIME.get()).booleanValue() || !this.ACTIVE_CHECK.matcher(block).matches()) continue;
            if (block.contains(":")) {
                String[] blockParts = block.split(":");
                blockName = blockParts[0] + ":active_" + blockParts[1];
            } else {
                blockName = "nuclearcraft:active_" + block;
            }
            tmp.add((String)blockName);
        }
        return tmp;
    }

    public double getHeat() {
        return this.heat;
    }

    public List<FluidStack> getAllowedFluids() {
        if (this.allowedFluids == null) {
            this.allowedFluids = this.getFluidByTagKey("forge:" + this.name);
        }
        return this.allowedFluids;
    }

    private List<FluidStack> getFluidByTagKey(String name) {
        ArrayList<FluidStack> tmp = new ArrayList<FluidStack>();
        Fluid fluid = TagUtil.getFirstMatchingFluidByTag(name);
        tmp.add(new FluidStack(fluid, 1));
        return tmp;
    }

    public static class Validator {
        private final HashMap<String[], List<String>> blockLines;
        private final HashMap<String[], List<Block>> blocks = new HashMap();

        public Validator(HashMap<String[], List<String>> conditions) {
            this.blockLines = conditions;
        }

        public boolean isValid(Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            boolean result = false;
            BlockPos p = new BlockPos((Vec3i)pos);
            for (String[] condition : this.blocks().keySet()) {
                if (result = (switch (condition[0]) {
                    case ">" -> this.isAtLeast(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "<" -> this.isLessThan(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "-" -> this.isBetween(condition, level, p, multiblock);
                    case "=" -> this.isExact(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    case "^" -> this.inCorner(Integer.parseInt(condition[1]), condition, level, p, multiblock);
                    default -> result;
                })) continue;
                return false;
            }
            return result;
        }

        public boolean validateFuelCellAttachment(Level level, AbstractMultiblock multiblock, BlockPos ... pos) {
            for (BlockPos p : pos) {
                for (Direction dir : Direction.values()) {
                    if (multiblock != null ? multiblock.checkAttachmentToBlock(FissionFuelCellBlock.class, level, p, dir) : MultiblockHandler.get((ResourceKey<Level>)level.m_46472_()).checkAttachmentToBlock(FissionFuelCellBlock.class, level, p, dir)) {
                        return true;
                    }
                    BlockState block = null;
                    if (multiblock != null) {
                        block = multiblock.getBlockState(p.m_121945_(dir));
                    }
                    if (block == null) {
                        block = level.m_8055_(p.m_121945_(dir));
                    }
                    if (!(block.m_60734_() instanceof FissionFuelCellBlock)) continue;
                    return true;
                }
            }
            return false;
        }

        private BlockState getBlockState(Level level, BlockPos pos, AbstractMultiblock multiblock) {
            BlockState target = null;
            if (multiblock != null) {
                target = multiblock.getBlockState(pos);
            }
            if (target == null) {
                target = level.m_8055_(pos);
            }
            return target;
        }

        private boolean validatePlacement(String[] condition, Level level, FissionReactorMultiblock multiblock, BlockPos ... pos) {
            BlockState target = this.getBlockState(level, pos[0], multiblock);
            if (this.blocks.get(condition).contains(target.m_60734_())) {
                if (multiblock != null) {
                    if (target.m_60734_() instanceof HeatSinkBlock && !multiblock.validHeatSinks.containsKey(pos[0].m_121878_())) {
                        return false;
                    }
                    if (multiblock.isModerator(target) && !multiblock.moderators.contains(pos[0].m_121878_())) {
                        return false;
                    }
                }
                return this.mustCheckFuelCellConnection(condition) || this.validateFuelCellAttachment(level, multiblock, pos);
            }
            return false;
        }

        private boolean inCorner(int qty, String[] condition, Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            int initial = this.blocks.get(condition).contains(this.getBlockState(level, pos.m_6630_(1), multiblock).m_60734_()) ? 1 : 0;
            initial = this.blocks.get(condition).contains(this.getBlockState(level, pos.m_6625_(1), multiblock).m_60734_()) ? 1 : initial;
            int[] matches = new int[4];
            int i = 0;
            for (Direction dir : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir))) {
                    if (1 + initial >= qty) {
                        return true;
                    }
                    matches[i] = 1;
                }
                ++i;
            }
            for (int k = 0; k < 4; ++k) {
                int next = k + 1;
                if (next > 3) {
                    next = 0;
                }
                if (matches[k] + matches[next] + initial < qty) continue;
                return true;
            }
            return false;
        }

        private boolean isExact(int s, String[] condition, Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir)) || ++counter <= s) continue;
                return false;
            }
            return counter == s;
        }

        private boolean isBetween(String[] condition, Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            for (Direction dir : Direction.values()) {
                if (!this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir)) || !this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir.m_122424_()))) continue;
                return true;
            }
            return false;
        }

        private boolean isLessThan(int s, String[] condition, Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir)) || ++counter < s) continue;
                return false;
            }
            return counter < s;
        }

        private boolean mustCheckFuelCellConnection(String[] condition) {
            return condition[2].contains("casing");
        }

        private boolean isAtLeast(int s, String[] condition, Level level, BlockPos pos, FissionReactorMultiblock multiblock) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!this.validatePlacement(condition, level, multiblock, pos.m_121945_(dir)) || ++counter < s) continue;
                return true;
            }
            return counter >= s;
        }

        public HashMap<String[], List<String>> blockLines() {
            return this.blockLines;
        }

        /*
         * WARNING - void declaration
         */
        public HashMap<String[], List<Block>> blocks() {
            if (this.blocks.isEmpty()) {
                for (String[] condition : this.blockLines().keySet()) {
                    ArrayList<Block> tmp = new ArrayList<Block>();
                    for (String string : this.blockLines().get(condition)) {
                        void var5_5;
                        if (string.contains("#")) {
                            tmp.addAll(TagUtil.getBlocksByTagKey(string));
                            continue;
                        }
                        if (!string.contains(":")) {
                            String string2 = "nuclearcraft:" + string;
                        }
                        tmp.add((Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString((String)var5_5)));
                    }
                    this.blocks.put(condition, tmp);
                }
            }
            return this.blocks;
        }
    }
}

