/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.particle_chamber;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.target_chamber.DetectorBlock;
import igentuman.nc.block.target_chamber.entity.TargetChamberBeamPortBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.content.particles.ParticleStack;
import igentuman.nc.handler.config.AcceleratorConfig;
import igentuman.nc.multiblock.AbstractMultiblock;
import igentuman.nc.multiblock.MultiblockHandler;
import igentuman.nc.multiblock.ValidationResult;
import igentuman.nc.multiblock.accelerator.AcceleratorRegistration;
import igentuman.nc.multiblock.particle_chamber.TargetChamberController;
import igentuman.nc.multiblock.particle_chamber.TargetChamberRegistration;
import igentuman.nc.util.BlockPosInstance;
import igentuman.nc.util.PortMode;
import igentuman.nc.util.TagUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TargetChamberMultiblock
extends AbstractMultiblock {
    protected final HashMap<Long, DetectorBlock> validDetectors = new HashMap();
    protected final HashSet<Long> allDetectors = new HashSet();
    public double efficiency = 0.0;
    public int power = 0;
    public final HashMap<Long, BlockEntity> beamPorts = new HashMap();

    @Override
    public int maxHeight() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxWidth() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int maxDepth() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MAX_SIZE.get();
    }

    @Override
    public int minHeight() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minWidth() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MIN_SIZE.get();
    }

    @Override
    public int minDepth() {
        return (Integer)AcceleratorConfig.PARTICLE_CHAMBER_CONFIG.MIN_SIZE.get();
    }

    public TargetChamberMultiblock(TargetChamberControllerBE TargetChamberControllerBE2) {
        super(TagUtil.getBlocksByTagKey(TargetChamberRegistration.TARGET_CHAMBER_CASING_BLOCKS.f_203868_().toString()), TagUtil.getBlocksByTagKey(TargetChamberRegistration.TARGET_CHAMBER_INNER_BLOCKS.f_203868_().toString()), new TargetChamberController(TargetChamberControllerBE2));
        this.id = "target_chamber_" + TargetChamberControllerBE2.m_58899_().m_123344_();
        this.controllerBe = TargetChamberControllerBE2;
        MultiblockHandler.get((ResourceKey<Level>)this.getLevel().m_46472_()).addMultiblock(this);
    }

    public Map<Long, DetectorBlock> validateDetectors() {
        if (this.validDetectors.isEmpty()) {
            for (long packedPos : this.allDetectors) {
                DetectorBlock hs;
                BlockPos hpos = BlockPos.m_122022_((long)packedPos);
                Block block = this.getBlockState(hpos).m_60734_();
                if (!(block instanceof DetectorBlock) || !(hs = (DetectorBlock)block).isValid(this.getLevel(), hpos, this)) continue;
                this.validDetectors.put(packedPos, hs);
            }
        }
        this.controllerBE().detectorsCount = this.validDetectors.size();
        return this.validDetectors;
    }

    protected boolean isDetector(BlockState bs) {
        return bs.m_60734_() instanceof DetectorBlock;
    }

    protected boolean isDetector(BlockPos pos) {
        return this.allDetectors.contains(pos.m_121878_()) || this.isDetector(this.getBlockState(pos));
    }

    @Override
    public void validateOuter() {
        NuclearCraft.debugLog("Starting target chamber outer validation");
        super.validateOuter();
        if (!this.validationResult.isValid) {
            NuclearCraft.debugLog("Base outer validation failed with result: " + this.validationResult);
            return;
        }
        NuclearCraft.debugLog("Checking target chamber proportions - " + this.width() + "x" + this.height() + "x" + this.depth());
        if (this.height() % 2 == 0 || this.width() % 2 == 0 || this.depth() % 2 == 0 || this.height() != this.width() || this.height() != this.depth() || this.width() != this.depth()) {
            NuclearCraft.debugLog("Proportion validation failed - dimensions must be odd and equal (cube)");
            NuclearCraft.debugLog("Current: " + this.width() + "x" + this.height() + "x" + this.depth() + " (even dimensions: H=" + (this.height() % 2 == 0) + ", W=" + (this.width() % 2 == 0) + ", D=" + (this.depth() % 2 == 0) + ")");
            this.validationResult = ValidationResult.WRONG_PROPORTIONS;
            this.outerValid = false;
            return;
        }
        this.outerValid = true;
        this.validationResult = ValidationResult.VALID;
        NuclearCraft.debugLog("Target chamber outer validation completed successfully");
    }

    @Override
    public void validate() {
        NuclearCraft.debugLog("=== Starting Target Chamber validation at " + this.controllerPos.m_123344_() + " ===");
        this.validDetectors.clear();
        this.allDetectors.clear();
        NuclearCraft.debugLog("Cleared target chamber specific caches");
        super.validate();
        if (this.validationResult.isValid) {
            NuclearCraft.debugLog("Target chamber validation completed successfully");
            NuclearCraft.debugLog("Detectors - All: " + this.allDetectors.size() + ", Valid: " + this.validDetectors.size() + ", Efficiency: " + String.format("%.2f%%", this.efficiency * 100.0) + ", Power: " + this.power);
        } else {
            NuclearCraft.debugLog("Target chamber validation failed with result: " + this.validationResult);
        }
    }

    @Override
    public void validateInner() {
        NuclearCraft.debugLog("Starting target chamber inner validation");
        this.efficiency = 1.0;
        this.power = 0;
        if (!this.outerValid) {
            NuclearCraft.debugLog("Skipping inner validation - outer validation failed");
            this.clearStats();
            return;
        }
        NuclearCraft.debugLog("Indexing inner blocks for target chamber");
        this.indexInnerBlocks();
        if (!this.validationResult.isValid) {
            NuclearCraft.debugLog("Inner block indexing failed with result: " + this.validationResult);
            this.clearStats();
            return;
        }
        NuclearCraft.debugLog("Checking center block for camera at " + this.getCenterBlock().m_123344_());
        if (!this.getBlockState(this.getCenterBlock()).m_60713_((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_camera").get())) {
            NuclearCraft.debugLog("Center block validation failed - expected camera, found: " + this.getBlockState(this.getCenterBlock()).m_60734_().m_7705_());
            this.validationResult = ValidationResult.WRONG_INNER;
            this.errorBlockPos = this.getCenterBlock();
            this.clearStats();
            return;
        }
        NuclearCraft.debugLog("Validating beam lines");
        this.validateBeamLines();
        this.controllerBE().allDetectors = this.allDetectors.size();
        this.controllerBE().efficiency = this.efficiency * 100.0;
        this.controllerBE().energyPerTick = this.power;
        this.controllerBE().connectedPorts = this.connectedPorts;
        this.controllerBE().detectorsCount = this.validDetectors.size();
        this.controllerBE().height = this.height;
        this.controllerBE().width = this.width;
        NuclearCraft.debugLog("Target chamber inner validation completed - Efficiency: " + String.format("%.2f%%", this.efficiency * 100.0) + ", Power: " + this.power + ", Detectors: " + this.validDetectors.size() + "/" + this.allDetectors.size());
        this.controllerBE().depth = this.depth;
        if (this.validDetectors.isEmpty()) {
            this.validationResult = ValidationResult.NO_DETECTORS;
            this.errorBlockPos = this.getCenterBlock();
            this.clearStats();
            return;
        }
        this.controllerBE().refresh();
    }

    private void validateBeamLines() {
        for (Direction dir : List.of(Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH)) {
            BlockState bs;
            BlockPos pos = this.getCenterBlock();
            for (int i = 1; i < this.width() / 2; ++i) {
                bs = this.getBlockState(pos = pos.m_5484_(dir, i));
                if (bs.m_60713_((Block)AcceleratorRegistration.ACCELERATOR_BLOCKS.get("particle_beam").get())) continue;
                this.validationResult = ValidationResult.WRONG_INNER;
                this.errorBlockPos = pos;
                return;
            }
            BlockPos target = this.getCenterBlock().m_5484_(dir, this.width() / 2);
            bs = this.getBlockState(target);
            if (!bs.m_60713_((Block)TargetChamberRegistration.TARGET_CHAMBER_BLOCKS.get("target_chamber_beam_port").get())) {
                this.validationResult = ValidationResult.NO_PORT;
                this.errorBlockPos = new BlockPos((Vec3i)target);
                return;
            }
            this.beamPorts.put(target.m_121878_(), this.getBlockEntity(target, new boolean[0]));
        }
    }

    private void indexInnerBlocks() {
        BlockPosInstance toCheck = new BlockPosInstance((Vec3i)this.initialPos());
        for (int y = 1; y < this.height - 1; ++y) {
            for (int x = 1; x < this.width - 1; ++x) {
                for (int z = 1; z < this.depth - 1; ++z) {
                    switch (this.getMultiblockDirection().ordinal()) {
                        case 3: {
                            toCheck.revert().m_122030_(x - this.leftCasing);
                            break;
                        }
                        case 5: {
                            toCheck.revert().m_122013_(x - this.leftCasing);
                            break;
                        }
                        case 2: {
                            toCheck.revert().m_122025_(x - this.leftCasing);
                            break;
                        }
                        case 4: {
                            toCheck.revert().m_122020_(x - this.leftCasing);
                        }
                    }
                    toCheck.m_6630_(y - this.bottomCasing).m_5484_(this.getControllerDirection(), -z);
                    if (this.processInnerBlock(toCheck)) continue;
                    this.validationResult = ValidationResult.WRONG_INNER;
                    this.errorBlockPos = new BlockPos((Vec3i)toCheck);
                    return;
                }
            }
        }
        this.validationResult = ValidationResult.VALID;
        this.errorBlockPos = null;
    }

    @Override
    protected TargetChamberControllerBE controllerBE() {
        if (this.controllerBe == null) {
            this.controllerBe = this.controller().controllerBE();
        }
        return (TargetChamberControllerBE)this.controllerBe;
    }

    @Override
    protected boolean processInnerBlock(BlockPos toCheck) {
        this.addIfNotExists(toCheck, (HashSet<Long>)this.allBlocks);
        BlockState bs = this.getBlockState(toCheck);
        if (this.isDetector(bs)) {
            DetectorBlock detectorBlock = (DetectorBlock)bs.m_60734_();
            if (detectorBlock.isValid(this.getLevel(), toCheck, this)) {
                this.efficiency += detectorBlock.efficiency;
                this.power += detectorBlock.power;
                this.validDetectors.put(toCheck.m_121878_(), detectorBlock);
            }
            this.addIfNotExists(toCheck, this.allDetectors);
            return true;
        }
        return this.isValidForInner(bs);
    }

    @Override
    public boolean checkAttachmentToBlock(Class<?> toCheck, Level level, BlockPos pos, Direction dir) {
        if (this.getBottomLeftBlock().m_123341_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123342_() >= pos.m_123341_() && this.getBottomLeftBlock().m_123343_() >= pos.m_123343_() && this.getTopRightBlock().m_123341_() <= pos.m_123341_() && this.getTopRightBlock().m_123342_() <= pos.m_123342_() && this.getTopRightBlock().m_123343_() <= pos.m_123343_() && !this.allBlocks.contains(pos.m_121878_())) {
            return false;
        }
        return false;
    }

    @Override
    public void removeFromCacheIfChanged(BlockPos pos) {
        BlockEntity be;
        long packedPos = pos.m_121878_();
        if (this.beCache.containsKey(packedPos) && ((be = this.getLevel().getExistingBlockEntity(pos)) != this.beCache.get(packedPos) || be != null && be.m_58901_())) {
            this.beCache.remove(packedPos);
        }
        if (this.bsCache.containsKey(packedPos)) {
            BlockState bs = this.getLevel().m_8055_(pos);
            BlockState cachedState = (BlockState)this.bsCache.get(packedPos);
            if (cachedState == null || !bs.m_60713_(((BlockState)this.bsCache.get(packedPos)).m_60734_())) {
                this.bsCache.remove(packedPos);
                this.allDetectors.remove(packedPos);
            }
        }
    }

    @Override
    public void clearStats() {
        this.controller().clearStats();
        this.controllerBE().bottomLeft = BlockPos.f_121853_;
        this.controllerBE().topRight = BlockPos.f_121853_;
        this.controllerBE().m_6596_();
    }

    @Override
    protected Direction getControllerDirection() {
        return this.controllerBE().getFacing();
    }

    public void extractParticle(int id, ParticleStack outputParticle) {
        int i = -1;
        for (long pos : this.beamPorts.keySet()) {
            if (this.getBlockState(pos).m_61143_(PortMode.PORT_MODE) != PortMode.Mode.OUTPUT) continue;
            BlockEntity be = this.beamPorts.get(pos);
            if (id != ++i || !(be instanceof TargetChamberBeamPortBE)) continue;
            TargetChamberBeamPortBE port = (TargetChamberBeamPortBE)be;
            port.extractParticle(outputParticle);
        }
    }
}

