/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.particle_chamber;

import igentuman.nc.block.target_chamber.DetectorBlock;
import igentuman.nc.block.target_chamber.TargetChamberBeamPortBlock;
import igentuman.nc.block.target_chamber.TargetChamberBlock;
import igentuman.nc.block.target_chamber.TargetChamberCameraBlock;
import igentuman.nc.block.target_chamber.TargetChamberControllerBlock;
import igentuman.nc.block.target_chamber.TargetChamberPortBlock;
import igentuman.nc.block.target_chamber.entity.TargetChamberBeamPortBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberControllerBE;
import igentuman.nc.block.target_chamber.entity.TargetChamberPortBE;
import igentuman.nc.container.TargetChamberControllerContainer;
import igentuman.nc.container.TargetChamberPortContainer;
import igentuman.nc.multiblock.particle_chamber.DetectorDef;
import igentuman.nc.setup.registration.NCBlocks;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.setup.registration.Tags;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class TargetChamberRegistration {
    public static final Item.Properties TARGET_CHAMBER_ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties NO_OCCLUSION_BLOCK_PROPS = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_().m_60955_();
    public static final BlockBehaviour.Properties TARGET_CHAMBER_BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(4.0f).m_60999_();
    public static final HashMap<String, RegistryObject<Block>> TARGET_CHAMBER_BLOCKS = new HashMap();
    public static final HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> TARGET_CHAMBER_BE = new HashMap();
    public static final HashMap<String, RegistryObject<Item>> TARGET_CHAMBER_ITEMS = new HashMap();
    public static final TagKey<Block> TARGET_CHAMBER_CASING_BLOCKS = Tags.blockTag("target_chamber_casing");
    public static final TagKey<Block> TARGET_CHAMBER_INNER_BLOCKS = Tags.blockTag("target_chamber_inner");
    public static final TagKey<Item> TARGET_CHAMBER_INNER_ITEMS = Tags.itemTag("target_chamber_inner");
    public static final TagKey<Item> TARGET_CHAMBER_CASING_ITEMS = Tags.itemTag("target_chamber_casing");
    public static final Pattern TRANSPARENT_BLOCKS_PATTERN = Pattern.compile(".*glass.*");
    public static final HashMap<String, DetectorDef> TARGET_CHAMBER_DETECTORS = new HashMap();
    public static final RegistryObject<MenuType<TargetChamberControllerContainer>> TARGET_CHAMBER_CONTROLLER_CONTAINER = Registries.CONTAINERS.register("target_chamber_controller", () -> IForgeMenuType.create((windowId, inv, data) -> new TargetChamberControllerContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<TargetChamberPortContainer>> TARGET_CHAMBER_PORT_CONTAINER = Registries.CONTAINERS.register("target_chamber_port", () -> IForgeMenuType.create((windowId, inv, data) -> new TargetChamberPortContainer(windowId, data.m_130135_(), inv)));

    public static List<DetectorDef> detectors() {
        return List.of(DetectorDef.make("bubble_chamber", 0.075, 200, 2), DetectorDef.make("silicon_tracker", 0.15, 2000, 1), DetectorDef.make("wire_chamber", 0.1, 1000, 2), DetectorDef.make("em_calorimeter", 0.05, 200, 3), DetectorDef.make("hadron_calorimeter", 0.025, 100, 4));
    }

    public static void init() {
        for (DetectorDef def : TargetChamberRegistration.detectors()) {
            TargetChamberRegistration.registerDetector(def.name, def);
        }
        TargetChamberRegistration.registerSimpleBlock("target_chamber_camera");
        TargetChamberRegistration.registerSimpleBlock("target_chamber_casing");
        TargetChamberRegistration.registerSimpleBlock("target_chamber_casing_glass");
        TargetChamberRegistration.registerOrientedBlock("target_chamber_controller");
        TargetChamberRegistration.registerOrientedBlock("target_chamber_port");
        TargetChamberRegistration.registerOrientedBlock("target_chamber_beam_port");
        TARGET_CHAMBER_BE.put("target_chamber_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("target_chamber_port", () -> BlockEntityType.Builder.m_155273_(TargetChamberPortBE::new, (Block[])new Block[]{(Block)TARGET_CHAMBER_BLOCKS.get("target_chamber_port").get()}).m_58966_(null)));
        TARGET_CHAMBER_BE.put("target_chamber_beam_port", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("target_chamber_beam_port", () -> BlockEntityType.Builder.m_155273_(TargetChamberBeamPortBE::new, (Block[])new Block[]{(Block)TARGET_CHAMBER_BLOCKS.get("target_chamber_beam_port").get()}).m_58966_(null)));
        TARGET_CHAMBER_BE.put("target_chamber_controller", (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register("target_chamber_controller", () -> BlockEntityType.Builder.m_155273_(TargetChamberControllerBE::new, (Block[])new Block[]{(Block)TARGET_CHAMBER_BLOCKS.get("target_chamber_controller").get()}).m_58966_(null)));
    }

    private static void registerOrientedBlock(String key) {
        BlockBehaviour.Properties props;
        BlockBehaviour.Properties properties = props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? NO_OCCLUSION_BLOCK_PROPS : TARGET_CHAMBER_BLOCK_PROPERTIES;
        if (key.equals("target_chamber_controller")) {
            TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new TargetChamberControllerBlock(props)));
        }
        if (key.equals("target_chamber_port")) {
            TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new TargetChamberPortBlock(props)));
        }
        if (key.equals("target_chamber_beam_port")) {
            TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new TargetChamberBeamPortBlock(props)));
        }
        TARGET_CHAMBER_ITEMS.put(key, NCBlocks.fromMultiblock(TARGET_CHAMBER_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, TARGET_CHAMBER_ITEMS.get(key));
    }

    private static void registerDetector(String key, DetectorDef def) {
        BlockBehaviour.Properties props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? NO_OCCLUSION_BLOCK_PROPS : TARGET_CHAMBER_BLOCK_PROPERTIES;
        TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new DetectorBlock(props, def)));
        TARGET_CHAMBER_DETECTORS.put(key, def);
        TARGET_CHAMBER_ITEMS.put(key, NCBlocks.fromMultiblock(TARGET_CHAMBER_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, TARGET_CHAMBER_ITEMS.get(key));
    }

    private static void registerSimpleBlock(String key) {
        BlockBehaviour.Properties props;
        BlockBehaviour.Properties properties = props = TRANSPARENT_BLOCKS_PATTERN.matcher(key).matches() ? NO_OCCLUSION_BLOCK_PROPS : TARGET_CHAMBER_BLOCK_PROPERTIES;
        if (key.equals("target_chamber_camera")) {
            TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new TargetChamberCameraBlock(props)));
        } else {
            TARGET_CHAMBER_BLOCKS.put(key, (RegistryObject<Block>)Registries.BLOCKS.register(key, () -> new TargetChamberBlock(props)));
        }
        TARGET_CHAMBER_ITEMS.put(key, NCBlocks.fromMultiblock(TARGET_CHAMBER_BLOCKS.get(key)));
        NCItems.ALL_NC_ITEMS.put(key, TARGET_CHAMBER_ITEMS.get(key));
    }
}

