/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.multiblock.turbine;

import igentuman.nc.block.turbine.entity.TurbineCoilBE;
import igentuman.nc.handler.config.TurbineConfig;
import igentuman.nc.multiblock.turbine.TurbineRegistration;
import igentuman.nc.setup.registration.Registries;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.TagUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class CoilDef {
    public double efficiency = 0.0;
    public String name = "";
    public String[] rules;
    protected Validator validator;
    private boolean initialized = false;

    public Validator getValidator() {
        if (this.validator == null) {
            this.rules = ((List)TurbineConfig.TURBINE_CONFIG.PLACEMENT_RULES.get(this.name).get()).toArray(new String[((List)TurbineConfig.TURBINE_CONFIG.PLACEMENT_RULES.get(this.name).get()).size()]);
            this.initCondition(this.rules);
        }
        return this.validator;
    }

    public CoilDef() {
    }

    public CoilDef(String name, int h, String ... rules) {
        this.efficiency = h;
        this.name = name;
        this.rules = rules;
    }

    private void initCondition(String[] rules) {
        HashMap<String[], List<String>> conditions = new HashMap<String[], List<String>>();
        for (String rule : rules) {
            int cnt = 1;
            try {
                cnt = Math.max(Integer.parseInt(rule.substring(rule.length() - 1)), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String[] conditionParts = rule.split("=|-|>|<|\\^");
            String[] blocks = conditionParts[0].split("\\|");
            List<String> actualBlocks = this.collectBlocks(blocks);
            conditions.put(new String[]{this.getConditionFunc(rule), String.valueOf(cnt), rule}, actualBlocks);
        }
        this.validator = new Validator();
        this.validator.blockLines = conditions;
    }

    private String getConditionFunc(String rule) {
        Pattern func = Pattern.compile("=|-|>|<|\\^");
        Matcher matcher = func.matcher(rule);
        ArrayList<String> matches = new ArrayList<String>();
        String funcType = ">";
        while (matcher.find()) {
            matches.add(matcher.group());
        }
        if (!matches.isEmpty()) {
            funcType = (String)matches.get(0);
        }
        return funcType;
    }

    public List<String> getItemsByTagKey(String key) {
        ArrayList<String> tmp = new ArrayList<String>();
        TagKey tag = TagKey.m_203882_(Registries.ITEM_REGISTRY, (ResourceLocation)NcUtils.rlFromString(key));
        Ingredient ing = Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(tag)));
        for (ItemStack item : ing.m_43908_()) {
            tmp.add(item.m_41720_().toString());
        }
        return tmp;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> collectBlocks(String[] blocks) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (String string : blocks) {
            void var6_6;
            if (string.contains("#")) {
                tmp.addAll(this.getItemsByTagKey(string.replace("#", "")));
                continue;
            }
            if (!string.contains(":")) {
                String string2 = "nuclearcraft:" + string;
            }
            tmp.add((String)var6_6);
        }
        return tmp;
    }

    public CoilDef(int i) {
        this.efficiency = i;
    }

    public CoilDef config() {
        if (!this.initialized) {
            this.initialized = true;
            int id = TurbineRegistration.coils.keySet().stream().toList().indexOf(this.name);
            this.efficiency = (Double)((List)TurbineConfig.TURBINE_CONFIG.EFFICIENCY.get()).get(id);
        }
        return this;
    }

    public double getEfficiency() {
        return this.config().efficiency;
    }

    public static class Validator {
        private TurbineCoilBE be;
        private HashMap<String[], List<String>> blockLines = new HashMap();
        private HashMap<String[], List<Block>> blocks = new HashMap();

        public boolean isValid(TurbineCoilBE be) {
            this.be = be;
            boolean result = false;
            for (String[] condition : this.blocks().keySet()) {
                switch (condition[0]) {
                    case ">": {
                        result = this.isMoreThan(Integer.parseInt(condition[1]), this.blocks().get(condition));
                        break;
                    }
                    case "<": {
                        result = this.isLessThan(Integer.parseInt(condition[1]), this.blocks().get(condition));
                        break;
                    }
                    case "-": {
                        result = this.isBetween(2, this.blocks().get(condition));
                        break;
                    }
                    case "=": {
                        result = this.isExact(Integer.parseInt(condition[1]), this.blocks().get(condition));
                        break;
                    }
                    case "^": {
                        result = this.inCorner(Integer.parseInt(condition[1]), this.blocks().get(condition));
                    }
                }
                if (result) continue;
                return false;
            }
            return result;
        }

        private boolean inCorner(int qty, List<Block> blocks) {
            BlockPos pos = this.be.m_58899_();
            Level level = Objects.requireNonNull(this.be.m_58904_());
            int initial = blocks.contains(level.m_8055_(pos.m_6630_(1)).m_60734_()) ? 1 : 0;
            initial = blocks.contains(level.m_8055_(pos.m_6625_(1)).m_60734_()) ? 1 : initial;
            int[] matches = new int[4];
            int i = 0;
            for (Direction dir : List.of(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST)) {
                if (blocks.contains(level.m_8055_(pos.m_121945_(dir)).m_60734_())) {
                    if (1 + initial >= qty) {
                        return true;
                    }
                    matches[i] = 1;
                }
                ++i;
            }
            for (int k = 0; k < 4; ++k) {
                int next = k + 1;
                if (next > 3) {
                    next = 0;
                }
                if (matches[k] + matches[next] + initial < qty) continue;
                return true;
            }
            return false;
        }

        private boolean isExact(int s, List<Block> blocks) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!blocks.contains(Objects.requireNonNull(this.be.m_58904_()).m_8055_(this.be.m_58899_().m_121945_(dir)).m_60734_()) || ++counter <= s) continue;
                return false;
            }
            return counter == s;
        }

        private boolean isBetween(int s, List<Block> blocks) {
            for (Direction dir : Direction.values()) {
                if (!blocks.contains(Objects.requireNonNull(this.be.m_58904_()).m_8055_(this.be.m_58899_().m_121945_(dir)).m_60734_()) || !blocks.contains(Objects.requireNonNull(this.be.m_58904_()).m_8055_(this.be.m_58899_().m_121945_(dir.m_122424_())).m_60734_())) continue;
                return true;
            }
            return false;
        }

        private boolean isLessThan(int s, List<Block> blocks) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!blocks.contains(Objects.requireNonNull(this.be.m_58904_()).m_8055_(this.be.m_58899_().m_121945_(dir)).m_60734_()) || ++counter < s) continue;
                return false;
            }
            return counter < s;
        }

        private boolean isMoreThan(int s, List<Block> blocks) {
            int counter = 0;
            for (Direction dir : Direction.values()) {
                if (!blocks.contains(Objects.requireNonNull(this.be.m_58904_()).m_8055_(this.be.m_58899_().m_121945_(dir)).m_60734_()) || ++counter < s) continue;
                return true;
            }
            return counter >= s;
        }

        public HashMap<String[], List<String>> blockLines() {
            return this.blockLines;
        }

        /*
         * WARNING - void declaration
         */
        public HashMap<String[], List<Block>> blocks() {
            if (this.blocks.isEmpty()) {
                for (String[] condition : this.blockLines().keySet()) {
                    ArrayList<Block> tmp = new ArrayList<Block>();
                    for (String string : this.blockLines().get(condition)) {
                        void var5_5;
                        if (string.contains("#")) {
                            tmp.addAll(TagUtil.getBlocksByTagKey(string));
                            continue;
                        }
                        if (!string.contains(":")) {
                            String string2 = "nuclearcraft:" + string;
                        }
                        tmp.add((Block)ForgeRegistries.BLOCKS.getValue(NcUtils.rlFromString((String)var5_5)));
                    }
                    this.blocks.put(condition, tmp);
                }
            }
            return this.blocks;
        }
    }
}

