/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.network.toServer;

import igentuman.nc.block.entity.MultiblockControllerBE;
import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.block.entity.processor.NCProcessorBE;
import igentuman.nc.block.fission.entity.FissionControllerBE;
import igentuman.nc.block.fission.entity.FissionPortBE;
import igentuman.nc.block.fusion.entity.FusionCoreBE;
import igentuman.nc.block.fusion.entity.FusionCoreProxyBE;
import igentuman.nc.block.kugelblitz.entity.ChamberPortBE;
import igentuman.nc.block.kugelblitz.entity.EXPLBE;
import igentuman.nc.block.turbine.entity.TurbinePortBE;
import igentuman.nc.item.ContainerBlockItem;
import igentuman.nc.network.INcPacket;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketGuiButtonPress
implements INcPacket {
    private BlockPos tilePosition;
    private UUID playerUUID;
    private int buttonId;

    public PacketGuiButtonPress(Player player, int bId) {
        this.playerUUID = player.m_20148_();
        this.tilePosition = BlockPos.f_121853_;
        this.buttonId = bId;
    }

    public PacketGuiButtonPress(BlockPos position, int bId) {
        this.tilePosition = position;
        this.playerUUID = UUID.randomUUID();
        this.buttonId = bId;
    }

    public PacketGuiButtonPress() {
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ItemStack stack;
        Item item;
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        if (!this.tilePosition.equals((Object)BlockPos.f_121853_)) {
            this.toggleBlockEntity(player, this.tilePosition);
        }
        if (this.playerUUID.equals(player.m_20148_()) && this.buttonId == 184 && (item = (stack = player.m_6844_(EquipmentSlot.MAINHAND)).m_41720_()) instanceof ContainerBlockItem) {
            ContainerBlockItem containerBlockItem = (ContainerBlockItem)item;
            containerBlockItem.toggleMagnetMode(stack);
        }
    }

    private void toggleBlockEntity(ServerPlayer player, BlockPos tilePosition) {
        BlockEntity be = player.m_9236_().m_7702_(tilePosition);
        switch (this.buttonId) {
            case 70: {
                if (!(be instanceof NCProcessorBE)) {
                    return;
                }
                NCProcessorBE processor = (NCProcessorBE)be;
                processor.toggleRedstoneMode();
                break;
            }
            case 72: {
                if (!(be instanceof FissionControllerBE)) {
                    return;
                }
                FissionControllerBE controller = (FissionControllerBE)be;
                controller.toggleMode();
                break;
            }
            case 777: {
                if (!(be instanceof MultiblockControllerBE)) {
                    return;
                }
                MultiblockControllerBE controller = (MultiblockControllerBE)be;
                controller.runAnalyze();
                break;
            }
            case 71: {
                if (!(be instanceof FissionPortBE)) {
                    return;
                }
                FissionPortBE port = (FissionPortBE)be;
                port.toggleRedstoneMode();
                break;
            }
            case 74: {
                if (!(be instanceof TurbinePortBE)) {
                    return;
                }
                TurbinePortBE port = (TurbinePortBE)be;
                port.toggleRedstoneMode();
                break;
            }
            case 73: {
                NuclearCraftBE port;
                if (be instanceof FusionCoreBE) {
                    port = (FusionCoreBE)be;
                    ((FusionCoreBE)port).toggleRedstoneMode();
                }
                if (!(be instanceof FusionCoreProxyBE)) break;
                port = (FusionCoreProxyBE)be;
                ((FusionCoreProxyBE)port).toggleRedstoneMode();
                break;
            }
            case 75: {
                if (!(be instanceof ChamberPortBE)) break;
                ChamberPortBE port = (ChamberPortBE)be;
                port.toggleComparatorMode();
                break;
            }
            case 77: {
                if (!(be instanceof EXPLBE)) break;
                EXPLBE expl = (EXPLBE)be;
                expl.activated = true;
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.tilePosition);
        buffer.m_130077_(this.playerUUID);
        buffer.writeInt(this.buttonId);
    }

    public static PacketGuiButtonPress decode(FriendlyByteBuf buffer) {
        PacketGuiButtonPress packet = new PacketGuiButtonPress();
        packet.tilePosition = buffer.m_130135_();
        packet.playerUUID = buffer.m_130259_();
        packet.buttonId = buffer.readInt();
        return packet;
    }
}

