/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes;

import igentuman.nc.NuclearCraft;
import igentuman.nc.block.entity.processor.NuclearFurnaceBE;
import igentuman.nc.block.turbine.entity.TurbineControllerBE;
import igentuman.nc.client.NcClient;
import igentuman.nc.content.processors.Processors;
import igentuman.nc.recipes.INcRecipeTypeProvider;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.ingredient.creator.IngredientCreatorAccess;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.registry.RecipeTypeDeferredRegister;
import igentuman.nc.registry.RecipeTypeRegistryObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NcRecipeType<RECIPE extends NcRecipe>
implements RecipeType<RECIPE>,
INcRecipeTypeProvider<RECIPE> {
    public static final RecipeTypeDeferredRegister RECIPE_TYPES = new RecipeTypeDeferredRegister("nuclearcraft");
    public static boolean initialized = false;
    public static final HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> ALL_RECIPES = NcRecipeType.initializeRecipes();
    private List<RECIPE> cachedRecipes = Collections.emptyList();
    private final ResourceLocation registryName;
    public boolean isLoaded = false;

    private static HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> initializeRecipes() {
        HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>> recipes = new HashMap<String, RecipeTypeRegistryObject<? extends NcRecipe>>();
        recipes.put("fission_reactor_controller", NcRecipeType.register("fission_reactor_controller"));
        recipes.put("nc_ore_veins", NcRecipeType.register("nc_ore_veins"));
        recipes.put("fusion_core", NcRecipeType.register("fusion_core"));
        recipes.put("fusion_coolant", NcRecipeType.register("fusion_coolant"));
        recipes.put("accelerator_coolant", NcRecipeType.register("accelerator_coolant"));
        recipes.put("fission_boiling", NcRecipeType.register("fission_boiling"));
        recipes.put("kugelblitz_chamber", NcRecipeType.register("kugelblitz_chamber"));
        recipes.put("target_chamber", NcRecipeType.register("target_chamber"));
        recipes.put(TurbineControllerBE.NAME, NcRecipeType.register(TurbineControllerBE.NAME));
        for (String processorName : Processors.all().keySet()) {
            if (!Processors.all().get(processorName).hasRecipes()) continue;
            recipes.put(processorName, NcRecipeType.register(processorName));
        }
        initialized = true;
        return recipes;
    }

    public static <RECIPE extends NcRecipe> RecipeTypeRegistryObject<RECIPE> register(String name) {
        return RECIPE_TYPES.register(name, () -> new NcRecipeType(name));
    }

    private NcRecipeType(String name) {
        this.registryName = NuclearCraft.rl(name);
    }

    public static void invalidateCache() {
        if (!initialized) {
            return;
        }
        for (RecipeTypeRegistryObject<? extends NcRecipe> recipeType : ALL_RECIPES.values()) {
            recipeType.getRecipeType().cachedRecipes = Collections.emptyList();
        }
    }

    public static void init() {
    }

    public static List<? extends NcRecipe> getAllRecipesFor(String name, Level level) {
        return ALL_RECIPES.get(name).getRecipeType().getRecipes(level);
    }

    public String toString() {
        return this.registryName.toString();
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public NcRecipeType<RECIPE> getRecipeType() {
        return this;
    }

    @Override
    @NotNull
    public List<RECIPE> getRecipes(@Nullable Level world) {
        if (Processors.all().containsKey(this.registryName.m_135815_()) && !Processors.all().get(this.registryName.m_135815_()).config().isRegistered()) {
            return Collections.emptyList();
        }
        if (world == null && (world = (Level)DistExecutor.unsafeRunForDist(() -> NcClient::tryGetClientWorld, () -> () -> ServerLifecycleHooks.getCurrentServer().m_129783_())) == null) {
            return this.cachedRecipes;
        }
        if (this.cachedRecipes.isEmpty()) {
            RecipeManager recipeManager = world.m_7465_();
            List<Object> recipes = new ArrayList();
            recipes = this.registryName.m_135815_().equals("nuclear_furnace") ? this.getSmeltingRecipes(recipeManager) : recipeManager.m_44013_((RecipeType)this);
            this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
        }
        return this.cachedRecipes;
    }

    private List<RECIPE> getSmeltingRecipes(RecipeManager recipeManager) {
        List smelting = recipeManager.m_44013_(f_44108_);
        ArrayList<NuclearFurnaceBE.Recipe> recipes = new ArrayList<NuclearFurnaceBE.Recipe>();
        for (SmeltingRecipe recipe : smelting) {
            if (recipe.m_142505_()) continue;
            ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
            Ingredient input = (Ingredient)recipe.m_7527_().get(0);
            if (result.m_41619_() || input.m_43947_()) continue;
            ItemStackIngredient output = IngredientCreatorAccess.item().from(result);
            recipes.add(new NuclearFurnaceBE.Recipe(NuclearCraft.rl(this.getNFRecipeId(recipe)), new ItemStackIngredient[]{IngredientCreatorAccess.item().from(input)}, new ItemStackIngredient[]{output}, new FluidStackIngredient[0], new FluidStackIngredient[0], (double)recipe.m_43753_() / 2000.0, 1.0, 1.0, 1.0));
        }
        return recipes;
    }

    private String getNFRecipeId(SmeltingRecipe recipe) {
        return recipe.m_6423_().toString().replaceAll("[^a-z0-9/._-]", "_") + "_nf";
    }

    public static <C extends Container, RECIPE_TYPE extends Recipe<C>> Optional<RECIPE_TYPE> getRecipeFor(RecipeType<RECIPE_TYPE> recipeType, C inventory, Level level) {
        return level.m_7465_().m_44015_(recipeType, inventory, level).filter(recipe -> !recipe.m_142505_());
    }

    public static Optional<? extends Recipe<?>> byKey(Level level, ResourceLocation id) {
        return level.m_7465_().m_44043_(id).filter(recipe -> !recipe.m_142505_());
    }

    public void loadRecipes(Level level) {
        if (this.isLoaded) {
            return;
        }
        this.getRecipes(level);
        this.isLoaded = true;
    }

    public void loadRecipes(RecipeManager manager) {
        this.getRecipes(manager);
        this.isLoaded = true;
    }

    private void getRecipes(RecipeManager manager) {
        List recipes = manager.m_44013_((RecipeType)this);
        this.cachedRecipes = recipes.stream().filter(recipe -> !recipe.m_142505_()).toList();
    }
}

