/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.ingredient.creator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import igentuman.nc.NuclearCraft;
import igentuman.nc.network.BasePacketHandler;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.IMultiIngredient;
import igentuman.nc.recipes.ingredient.InputIngredient;
import igentuman.nc.recipes.ingredient.creator.IFluidStackIngredientCreator;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.SerializerHelper;
import igentuman.nc.util.TagUtil;
import igentuman.nc.util.annotation.NothingNullByDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidStackIngredientCreator
implements IFluidStackIngredientCreator {
    public static final FluidStackIngredientCreator INSTANCE = new FluidStackIngredientCreator();

    private FluidStackIngredientCreator() {
    }

    @Override
    public FluidStackIngredient from(FluidStack instance) {
        Objects.requireNonNull(instance, "FluidStackIngredients cannot be created from a null FluidStack.");
        if (instance.isEmpty()) {
            // empty if block
        }
        return new SingleFluidStackIngredient(instance.copy());
    }

    @Override
    public FluidStackIngredient from(JsonElement instance) {
        return this.deserialize(instance);
    }

    @Override
    public FluidStackIngredient from(TagKey<Fluid> tag, int amount) {
        Objects.requireNonNull(tag, "FluidStackIngredients cannot be created from a null tag.");
        if (amount <= 0) {
            throw new IllegalArgumentException("FluidStackIngredients must have an amount of at least one. Received size was: " + amount);
        }
        return new TaggedFluidStackIngredient(tag, amount);
    }

    @Override
    public FluidStackIngredient read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "FluidStackIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.m_130066_(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> this.from(FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            case IngredientType.TAGGED -> this.from(FluidTags.create((ResourceLocation)buffer.m_130281_()), buffer.m_130242_());
            case IngredientType.MULTI -> this.createMulti(BasePacketHandler.readArray(buffer, FluidStackIngredient[]::new, this::read));
        };
    }

    @Override
    public FluidStackIngredient deserialize(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient cannot be null.");
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            int size = jsonArray.size();
            if (size == 0) {
                throw new JsonSyntaxException("Ingredient array cannot be empty, at least one ingredient must be defined.");
            }
            if (size > 1) {
                FluidStackIngredient[] ingredients = new FluidStackIngredient[size];
                for (int i = 0; i < size; ++i) {
                    ingredients[i] = this.deserialize(jsonArray.get(i));
                }
                return this.createMulti(ingredients);
            }
            json = jsonArray.get(0);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expected fluid to be object or array of objects.");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (jsonObject.has("fluid") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an fluid, not both.");
        }
        if (jsonObject.has("fluid")) {
            FluidStack stack = SerializerHelper.deserializeFluid(jsonObject);
            if (stack.isEmpty()) {
                throw new JsonSyntaxException("Unable to create an ingredient from an empty stack.");
            }
            return this.from(stack);
        }
        if (jsonObject.has("tag")) {
            if (!jsonObject.has("amount")) {
                throw new JsonSyntaxException("Expected to receive a amount that is greater than zero.");
            }
            JsonElement count = jsonObject.get("amount");
            if (!GsonHelper.m_13872_((JsonElement)count)) {
                throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
            }
            int amount = count.getAsJsonPrimitive().getAsInt();
            if (amount < 1) {
                throw new JsonSyntaxException("Expected amount to be greater than zero.");
            }
            ResourceLocation resourceLocation = NcUtils.rlFromString(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
            ITagManager tagManager = TagUtil.manager(ForgeRegistries.FLUIDS);
            TagKey key = tagManager.createTagKey(resourceLocation);
            return this.from(key, amount);
        }
        throw new JsonSyntaxException("Expected to receive a resource location representing either a tag or a fluid.");
    }

    public FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<FluidStackIngredient> cleanedIngredients = new ArrayList<FluidStackIngredient>();
        for (FluidStackIngredient ingredient : ingredients) {
            if (ingredient instanceof MultiFluidStackIngredient) {
                MultiFluidStackIngredient multi = (MultiFluidStackIngredient)ingredient;
                Collections.addAll(cleanedIngredients, multi.ingredients);
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new MultiFluidStackIngredient(cleanedIngredients.toArray(new FluidStackIngredient[0]));
    }

    @Override
    public FluidStackIngredient from(Stream<FluidStackIngredient> ingredients) {
        return this.createMulti((FluidStackIngredient[])ingredients.toArray(FluidStackIngredient[]::new));
    }

    @NothingNullByDefault
    public static class SingleFluidStackIngredient
    extends FluidStackIngredient {
        private final FluidStack fluidInstance;

        private SingleFluidStackIngredient(FluidStack fluidInstance) {
            this.fluidInstance = Objects.requireNonNull(fluidInstance);
        }

        @Override
        public String getName() {
            return this.fluidInstance.getFluid().getFluidType().toString().replace(":", "_");
        }

        @Override
        public boolean test(FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.fluidInstance.getAmount();
        }

        @Override
        public boolean testType(FluidStack fluidStack) {
            return Objects.requireNonNull(fluidStack).isFluidEqual(this.fluidInstance);
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack fluidStack) {
            return this.test(fluidStack) ? this.fluidInstance.copy() : FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            return this.testType(stack) ? (long)this.fluidInstance.getAmount() : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return false;
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            return Collections.singletonList(this.fluidInstance);
        }

        public FluidStack getInputRaw() {
            return this.fluidInstance;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.SINGLE);
            this.fluidInstance.writeToPacket(buffer);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.fluidInstance.getAmount());
            json.addProperty("fluid", NcUtils.getName(this.fluidInstance.getFluid()).toString());
            if (this.fluidInstance.hasTag()) {
                json.addProperty("nbt", this.fluidInstance.getTag().toString());
            }
            return json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleFluidStackIngredient other = (SingleFluidStackIngredient)o;
            return this.fluidInstance.isFluidStackIdentical(other.fluidInstance);
        }

        public int hashCode() {
            return this.fluidInstance.hashCode();
        }
    }

    @NothingNullByDefault
    public static class TaggedFluidStackIngredient
    extends FluidStackIngredient {
        protected final ITag<Fluid> tag;

        private TaggedFluidStackIngredient(TagKey<Fluid> tag, int amount) {
            this(TagUtil.tag(ForgeRegistries.FLUIDS, tag), amount);
        }

        private TaggedFluidStackIngredient(ITag<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public String getName() {
            return this.tag.getKey().f_203868_().m_135815_().replace('/', '_').replace(':', '.');
        }

        @Override
        public boolean test(FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(FluidStack fluidStack) {
            return this.tag.contains((Object)Objects.requireNonNull(fluidStack).getFluid());
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack fluidStack) {
            if (this.test(fluidStack)) {
                return new FluidStack(fluidStack, this.amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return this.tag.isEmpty();
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            ArrayList<@NotNull FluidStack> representations = new ArrayList<FluidStack>();
            for (Fluid fluid : this.tag) {
                representations.add(new FluidStack(fluid, this.amount));
            }
            if (representations.isEmpty()) {
                Fluid fallbackFluid = TagUtil.getFirstMatchingFluidByTag(this.tag.getKey().f_203868_().toString());
                if (fallbackFluid != FluidStack.EMPTY.getFluid()) {
                    representations.add(new FluidStack(fallbackFluid, this.amount));
                } else {
                    NuclearCraft.LOGGER.error("No fluid found for tag {}", (Object)this.tag.getKey().f_203868_());
                }
            }
            return representations;
        }

        public Iterable<Fluid> getRawInput() {
            return this.tag;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.TAGGED);
            buffer.m_130085_(this.tag.getKey().f_203868_());
            buffer.m_130130_(this.amount);
        }

        @Override
        public JsonElement serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("amount", (Number)this.amount);
            json.addProperty("tag", this.tag.getKey().f_203868_().toString());
            return json;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaggedFluidStackIngredient other = (TaggedFluidStackIngredient)o;
            return this.amount == other.amount && this.tag.equals(other.tag);
        }

        public int hashCode() {
            return Objects.hash(this.tag, this.amount);
        }
    }

    private static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    @NothingNullByDefault
    public static class MultiFluidStackIngredient
    extends FluidStackIngredient
    implements IMultiIngredient<FluidStack, FluidStackIngredient> {
        private final FluidStackIngredient[] ingredients;

        private MultiFluidStackIngredient(FluidStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(FluidStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testType(FluidStack stack) {
            return Arrays.stream(this.ingredients).anyMatch(ingredient -> ingredient.testType(stack));
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                FluidStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return Arrays.stream(this.ingredients).allMatch(InputIngredient::hasNoMatchingInstances);
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            ArrayList<@NotNull FluidStack> representations = new ArrayList<FluidStack>();
            for (FluidStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public boolean forEachIngredient(Predicate<FluidStackIngredient> checker) {
            boolean result = false;
            for (FluidStackIngredient ingredient : this.ingredients) {
                result |= checker.test(ingredient);
            }
            return result;
        }

        @Override
        public final List<FluidStackIngredient> getIngredients() {
            return List.of(this.ingredients);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)IngredientType.MULTI);
            BasePacketHandler.writeArray(buffer, this.ingredients, InputIngredient::write);
        }

        @Override
        public JsonElement serialize() {
            JsonArray json = new JsonArray();
            for (FluidStackIngredient ingredient : this.ingredients) {
                json.add(ingredient.serialize());
            }
            return json;
        }

        @Override
        public String getName() {
            return this.getRepresentations().get(0).getFluid().getFluidType().toString().split(":")[1];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.ingredients, ((MultiFluidStackIngredient)o).ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }
}

