/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.recipes.type;

import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import igentuman.nc.recipes.ingredient.ItemStackIngredient;
import igentuman.nc.recipes.type.NcRecipe;
import igentuman.nc.setup.registration.NCItems;
import igentuman.nc.util.insitu_leaching.OreVeinProvider;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class OreVeinRecipe
extends NcRecipe {
    private HashMap<ItemStackIngredient, Integer> itemsPool = new HashMap();
    private int roll;

    public OreVeinRecipe(ResourceLocation id, ItemStackIngredient[] input, ItemStackIngredient[] output, FluidStackIngredient[] inputFluids, FluidStackIngredient[] outputFluids, double timeModifier, double powerModifier, double radiation, double rarityModifier) {
        super(id, input, output, timeModifier, powerModifier, radiation, rarityModifier);
    }

    public HashMap<ItemStackIngredient, Integer> getItemsPool() {
        if (this.itemsPool.isEmpty()) {
            for (ItemStackIngredient item : this.inputItems) {
                if (!item.isValid()) continue;
                this.itemsPool.put(item, item.getAmount());
            }
        }
        return this.itemsPool;
    }

    @Override
    @NotNull
    public String m_6076_() {
        return this.codeId;
    }

    @Override
    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)NCItems.NC_PARTS.get("research_paper").get());
    }

    private int gameTimeSeed(ServerLevel level) {
        Random rand = new Random(level.m_46467_());
        return rand.nextInt();
    }

    public ItemStack getRandomOre(ServerLevel level, int x, int z, int id) {
        int score = OreVeinProvider.get(level).rand(x, z, id, this.gameTimeSeed(level)).nextInt(50) + 50;
        this.roll = 1;
        ItemStack ore = this.getOreByScore(score, level, x, z).m_41777_();
        ore.m_41764_(1);
        return ore;
    }

    public ItemStack getOreByScore(int score, ServerLevel level, int x, int z) {
        for (ItemStackIngredient item : this.getItemsPool().keySet()) {
            if (score <= this.getItemsPool().get(item) && OreVeinProvider.get(level).rand(x, z, score, this.gameTimeSeed(level)).nextInt(10) > this.roll) {
                return (ItemStack)item.getRepresentations().get(0);
            }
            ++this.roll;
            this.roll = Math.min(this.roll, 8);
            score -= this.getItemsPool().get(item) / 2;
        }
        return this.getOreByScore(score, level, x, z);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeDouble(this.rarityModifier);
    }
}

