/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.setup.registration;

import igentuman.nc.block.storage.BarrelBlock;
import igentuman.nc.block.storage.ContainerBlock;
import igentuman.nc.container.StorageContainerContainer;
import igentuman.nc.container.StorageContainerItemContainer;
import igentuman.nc.content.storage.BarrelBlocks;
import igentuman.nc.content.storage.ContainerBlocks;
import igentuman.nc.item.BarrelBlockItem;
import igentuman.nc.item.ContainerBlockItem;
import igentuman.nc.setup.registration.Registries;
import java.util.HashMap;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.registries.RegistryObject;

public class NCStorageBlocks {
    public static HashMap<String, RegistryObject<Block>> STORAGE_BLOCKS = new HashMap();
    public static HashMap<String, RegistryObject<Item>> BLOCK_ITEMS = new HashMap();
    public static final Item.Properties ITEM_PROPERTIES = new Item.Properties();
    public static final BlockBehaviour.Properties BLOCK_PROPERTIES = BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(2.0f).m_60999_().m_60955_();
    public static HashMap<String, RegistryObject<BlockEntityType<? extends BlockEntity>>> STORAGE_BE = new HashMap();
    public static final RegistryObject<MenuType<StorageContainerContainer<?>>> STORAGE_CONTAINER = Registries.CONTAINERS.register("storage_container", () -> IForgeMenuType.create((windowId, inv, data) -> new StorageContainerContainer(windowId, data.m_130135_(), inv)));
    public static final RegistryObject<MenuType<StorageContainerItemContainer<?>>> STORAGE_ITEM_CONTAINER = Registries.CONTAINERS.register("storage_item_container", () -> IForgeMenuType.create((windowId, inv, data) -> new StorageContainerItemContainer(windowId, data.m_130135_(), inv, data.readInt())));

    public static void init() {
        NCStorageBlocks.registerBlocks();
        NCStorageBlocks.registerBlockEntities();
        NCStorageBlocks.registerContainers();
    }

    private static void registerContainers() {
    }

    private static void registerBlockEntities() {
        for (String name : BarrelBlocks.all().keySet()) {
            STORAGE_BE.put(name, (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_(BarrelBlocks.all().get(name).getBlockEntity(), (Block[])new Block[]{(Block)STORAGE_BLOCKS.get(name).get()}).m_58966_(null)));
        }
        for (String name : ContainerBlocks.all().keySet()) {
            STORAGE_BE.put(name, (RegistryObject<BlockEntityType<? extends BlockEntity>>)Registries.BLOCK_ENTITIES.register(name, () -> BlockEntityType.Builder.m_155273_(ContainerBlocks.all().get(name).getBlockEntity(), (Block[])new Block[]{(Block)STORAGE_BLOCKS.get(name).get()}).m_58966_(null)));
        }
    }

    private static void registerBlocks() {
        for (String name : BarrelBlocks.all().keySet()) {
            STORAGE_BLOCKS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name, () -> new BarrelBlock(BLOCK_PROPERTIES)));
            BLOCK_ITEMS.put(name, NCStorageBlocks.fromBarrelBlock(STORAGE_BLOCKS.get(name)));
        }
        for (String name : ContainerBlocks.all().keySet()) {
            STORAGE_BLOCKS.put(name, (RegistryObject<Block>)Registries.BLOCKS.register(name, () -> new ContainerBlock(BLOCK_PROPERTIES)));
            BLOCK_ITEMS.put(name, NCStorageBlocks.fromContainerBlock(STORAGE_BLOCKS.get(name)));
        }
    }

    public static <B extends Block> RegistryObject<Item> fromBarrelBlock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BarrelBlockItem((Block)block.get(), ITEM_PROPERTIES));
    }

    public static <B extends Block> RegistryObject<Item> fromContainerBlock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new ContainerBlockItem((Block)block.get(), ITEM_PROPERTIES));
    }

    public static <B extends Block> RegistryObject<Item> fromBlock(RegistryObject<B> block) {
        return Registries.ITEMS.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), ITEM_PROPERTIES));
    }
}

