/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import igentuman.nc.util.NcUtils;
import igentuman.nc.util.annotation.NothingNullByDefault;
import igentuman.nc.util.math.FloatingLong;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class SerializerHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerHelper() {
    }

    public static FloatingLong getFloatingLong(@NotNull JsonObject json, @NotNull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        JsonElement jsonElement = json.get(key);
        if (!jsonElement.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a json primitive representing a FloatingLong");
        }
        try {
            return FloatingLong.parseFloatingLong(jsonElement.getAsNumber().toString(), true);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a valid FloatingLong (positive decimal number)");
        }
    }

    private static void validateKey(@NotNull JsonObject json, @NotNull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        if (!json.get(key).isJsonObject()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be an object");
        }
    }

    public static ItemStack getItemStack(@NotNull JsonObject json, @NotNull String key) {
        SerializerHelper.validateKey(json, key);
        return ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static ItemStack getItemStack(@NotNull JsonObject json) {
        return ShapedRecipe.m_151274_((JsonObject)json);
    }

    public static FluidStack getFluidStack(@NotNull JsonObject json, @NotNull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static FluidStack getFluidStack(@NotNull JsonObject json) {
        return SerializerHelper.deserializeFluid(json);
    }

    public static FluidStack deserializeFluid(@NotNull JsonObject json) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!GsonHelper.m_13872_((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        int amount = count.getAsJsonPrimitive().getAsInt();
        if (amount < 1) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = NcUtils.rlFromString(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid type '" + resourceLocation + "'");
        }
        CompoundTag nbt = null;
        if (json.has("nbt")) {
            JsonElement jsonNBT = json.get("nbt");
            try {
                nbt = jsonNBT.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(jsonNBT)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)jsonNBT, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT entry for fluid '" + resourceLocation + "'");
            }
        }
        return new FluidStack(fluid, amount, nbt);
    }

    public static JsonElement serializeItemStack(@NotNull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    public static JsonElement serializeFluidStack(@NotNull FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }
}

