/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.builder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public class MultiblockRenderer {
    public static Vec3i getSize(HashMap<BlockPos, Block> blockMap) {
        if (blockMap.isEmpty()) {
            return new Vec3i(1, 1, 1);
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : blockMap.keySet()) {
            maxX = Math.max(maxX, pos.m_123341_());
            maxY = Math.max(maxY, pos.m_123342_());
            maxZ = Math.max(maxZ, pos.m_123343_());
        }
        return new Vec3i(maxX, maxY, maxZ);
    }

    public static void render(HashMap<BlockPos, Block> structure, PoseStack stack, int x, int y, int w, int h) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
        Vec3i size = MultiblockRenderer.getSize(structure);
        int width = size.m_123341_();
        int height = size.m_123342_();
        int depth = size.m_123343_();
        ShaderInstance initial = RenderSystem.getShader();
        float maxDimension = Math.max(Math.max(width, height), depth);
        float scaleFactor = 0.8f;
        float scale = scaleFactor * (float)Math.min(w, h) / maxDimension;
        stack.m_85836_();
        stack.m_252880_((float)x + (float)w / 2.0f, (float)y + (float)h / 2.0f, 100.0f);
        RenderSystem.setShader(GameRenderer::m_172749_);
        stack.m_252781_(new Quaternionf().rotationX((float)Math.toRadians(30.0)));
        stack.m_252781_(new Quaternionf().rotationY((float)Math.toRadians(-135.0)));
        stack.m_85841_(scale, scale, scale);
        stack.m_252880_((float)(-width) / 2.0f, (float)(-height) / 2.0f, (float)(-depth) / 2.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        int i = 0;
        for (Map.Entry<BlockPos, Block> entry : structure.entrySet()) {
            BlockPos pos = entry.getKey();
            BlockState state = entry.getValue().m_49966_();
            stack.m_85836_();
            RenderSystem.setShader(GameRenderer::m_172749_);
            stack.m_252880_((float)(pos.m_123341_() - 1), (float)(pos.m_123342_() - 1), (float)(pos.m_123343_() - 1));
            blockRenderer.renderSingleBlock(state, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
            stack.m_85849_();
            if (i++ <= 1) continue;
        }
        bufferSource.m_109911_();
        stack.m_85849_();
    }
}

