/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.capability;

import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CapabilityUtils {
    private CapabilityUtils() {
    }

    public static void addListener(@NotNull LazyOptional<?> lazyOptional, @NotNull NonNullConsumer listener) {
        lazyOptional.addListener(listener);
    }

    public static <T> T getPresentCapability(ICapabilityProvider provider, Capability<T> cap) {
        return Objects.requireNonNull(CapabilityUtils.getCapability(provider, cap, null));
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> cap) {
        return CapabilityUtils.getCapability(provider, cap, null);
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider provider, Capability<T> cap, @Nullable Direction side) {
        LazyOptional optional = provider.getCapability(cap, side);
        if (optional.isPresent()) {
            return (T)optional.orElseThrow(RuntimeException::new);
        }
        return null;
    }
}

