/*
 * Decompiled with CFR 0.152.
 */
package igentuman.nc.util.capability;

import igentuman.nc.block.entity.NuclearCraftBE;
import igentuman.nc.compat.gregtech.GTUtils;
import igentuman.nc.handler.config.CommonConfig;
import igentuman.nc.util.ModUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.EnergyStorage;

public class CustomEnergyStorage
extends EnergyStorage {
    public boolean wasUpdated = true;
    private int receivedEnergy = 0;
    private boolean limit = false;
    private long outputAmperage;
    private long outputVoltage;
    private long inputAmperage;
    private long inputVoltage;
    public static final long[] V = new long[]{8L, 32L, 128L, 512L, 2048L, 8192L, 32768L, 131072L, 524288L, 0x200000L, 0x800000L, 0x2000000L, 0x8000000L, 0x20000000L, 0x80000000L};

    public CustomEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, 0);
    }

    public CustomEnergyStorage(int capacity, int maxTransfer, int maxExtract, long outputAmerage, long outputVoltage, long inputAmerage, long inputVoltage) {
        super(capacity, maxTransfer, maxExtract);
        this.outputAmperage = outputAmerage;
        this.outputVoltage = V[(int)outputVoltage];
        this.inputAmperage = inputAmerage * 2L;
        this.inputVoltage = V[(int)inputVoltage];
    }

    public CustomEnergyStorage(int capacity, int maxTransfer, int maxExtract) {
        this(capacity, maxTransfer, maxExtract, GTUtils.tierByFe(maxExtract), GTUtils.tierByFe(maxExtract), GTUtils.tierByFe(maxTransfer), GTUtils.tierByFe(maxTransfer));
    }

    public CustomEnergyStorage(int capacity, int maxTransfer, int maxExtract, boolean limit) {
        this(capacity, maxTransfer, maxExtract);
        this.limit = limit;
    }

    public CustomEnergyStorage setInputAmperage(long value) {
        this.inputAmperage = value;
        return this;
    }

    public CustomEnergyStorage setOutputAmperage(long value) {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled() && ((Boolean)CommonConfig.GTCEU_CONFIG.LIMIT_FE_OUTPUT.get()).booleanValue()) {
            this.maxExtract = GTUtils.convert2FE(value * this.outputVoltage);
        }
        this.outputAmperage = value;
        return this;
    }

    public CustomEnergyStorage setInputEnergyTier(long value) {
        this.inputAmperage = value * 2L;
        this.inputVoltage = V[(int)value];
        return this;
    }

    public CustomEnergyStorage setOutputEnergyTier(long value) {
        this.outputAmperage = value;
        this.outputVoltage = V[(int)value];
        return this;
    }

    protected void onEnergyChanged() {
        this.wasUpdated = true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.limit && this.receivedEnergy >= maxReceive) {
            return 0;
        }
        int rc = super.receiveEnergy(maxReceive, simulate);
        if (rc > 0 && !simulate) {
            this.receivedEnergy += rc;
            this.onEnergyChanged();
        }
        return rc;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int rc = super.extractEnergy(maxExtract, simulate);
        if (rc > 0 && !simulate) {
            this.onEnergyChanged();
        }
        return rc;
    }

    public void setEnergy(int energy) {
        int wasEnergy = this.energy;
        this.energy = energy;
        this.energy = Math.max(this.energy, 0);
        this.energy = Math.min(this.energy, this.getMaxEnergyStored());
        if (energy != wasEnergy) {
            this.onEnergyChanged();
        }
    }

    public void addEnergy(int energy) {
        this.energy += energy;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getEnergyStored();
        }
        this.energy = Math.max(this.energy, 0);
        this.energy = Math.min(this.energy, this.getMaxEnergyStored());
        if (energy != 0) {
            this.onEnergyChanged();
        }
    }

    public void consumeEnergy(int energy) {
        this.energy -= energy;
        if (this.energy < 0) {
            this.energy = 0;
        }
        if (energy != 0) {
            this.onEnergyChanged();
        }
    }

    public void setMaxCapacity(int cap) {
        if (cap != this.capacity) {
            this.onEnergyChanged();
        }
        this.capacity = cap;
    }

    public void setMaxExtract(int i) {
        if (i != this.maxExtract) {
            this.onEnergyChanged();
        }
        this.maxExtract = i;
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("energy", this.getEnergyStored());
        tag.m_128405_("capacity", this.getMaxEnergyStored());
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof IntTag) {
            IntTag intNbt = (IntTag)nbt;
            this.energy = intNbt.m_7047_();
        } else {
            this.energy = ((CompoundTag)nbt).m_128451_("energy");
            this.capacity = ((CompoundTag)nbt).m_128451_("capacity");
        }
    }

    public void tick() {
        this.receivedEnergy = 0;
    }

    public long getGTOutputAmperage() {
        return this.outputAmperage;
    }

    public long getGTOuputVoltage() {
        return this.outputVoltage;
    }

    public long getGTInputAmperage() {
        return this.inputAmperage;
    }

    public long getGTInputVoltage() {
        return this.inputVoltage;
    }

    public int getMaxExtract() {
        if (ModUtil.isGtLoaded() && NuclearCraftBE.isGTEUCapEnabled()) {
            return GTUtils.convert2FE(this.outputAmperage * this.outputVoltage);
        }
        return this.maxExtract;
    }
}

